+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-09-23T19:44:00-04:00"
lastmod = "2018-09-25T10:21:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537746208598/sqdc_t8a2655_pr.jpg.jpg"
primary_image_credit = "Plácido Domingo as Rodrigo and Ferruccio Furlanetto as King Philip II in LA Opera's 2018 production of Don Carlo. Photo: Cory Weaver/LA Opera."
publishDate = "2018-09-24T10:40:00-04:00"
related_companies = ["scene/companies/los-angeles-opera.md"]
related_people = ["scene/people/plcido-domingo.md","scene/people/morris-robinson.md","scene/people/ana-maria-martinez.md","scene/people/ramon-vargas.md","scene/people/anna-smirnova.md"]
short_description = "Morris Robinson hits his third home run in a row at LA Opera as the blind, self-righteous, single-minded Grand Inquisitor.  Having wowed us as Zaccaria in Nabucco, and Sparafucile in Rigoletto, he’s become a regular at LA Opera and he lifts any production to the sublime in any role that he plays."
slug = "la-opera-season-opens-with-the-rodrigo-show"
title = "LA Opera season opens with The Rodrigo Show"
+++

The good news is that Placido Domingo doesn't appear to be retiring any time soon. The great news is that he is still a phenom. If you were an opera lover who arrived at [LA Opera](/scene/companies/los-angeles-opera/) last night in a time machine (from an era when there was no Domingo) you would have been knocked out by the performance of the man playing Rodrigo in Verdi's *Don Carlo*. You would have concluded that this is a man at the top of his game, somewhere in the middle of his career. No doubt you then would have been stunned to learn that this Rodrigo is in fact 77 years old, and further stunned to learn that he was once perhaps the greatest tenor in his field and that he reinvented himself to become one of the greatest baritones. 

Powerful in presence, powerful in voice, this reviewer defies anyone to find a man of any age who has brought more to this role. Though *Don Carlo* is ostensibly about the title character, it's Domingo as Rodrigo who manages to steal the show, even though the rest of production is almost perfect. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537745986668/dc_t8a2745_pr.jpg.jpg)
<figcaption>Plácido Domingo as Rodrigo in LA Opera's production of *Don Carlo*, 2018. Photo: Cory Weaver/LA Opera.</figcaption>
</figure>

Some forty years ago, Domingo, the tenor, played the title role and he has been quoted as saying that it is a "thrill" to return to the work, which he considers "one of Verdi's greatest achievements." No one can argue (or should argue – it's, after all, Plácido Domingo.)

As written by Verdi and several librettists, Don Carlo may be the least interesting character in the story. His bromantic friend Rodrigo gets all the heroic lines, all the best arias and all the tragedy to boot.  Don Carlo comes off as a hothead, unable to control his anger or his lust and only the counsel and loyalty from Rodrigo protects him from his own destruction. Originally written as *Don Carlos* in French (for the Paris Opera), as a sprawling five-act evening with a ballet, Verdi needed to make some cuts, so he dropped the "s" from the title. (An old opera joke.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537746045858/dc_t8a3251_pr.jpg.jpg)
<figcaption>A scene from LA Opera's production of *Don Carlo*, 2018. Photo: Cory Weaver/LA Opera.</figcaption>
</figure>

In fact, he made a number of cuts and reworked the show several times until it became the four-act Italian version from the 1880's that is now constantly revived as part of today's repertory. At three hours (plus a twenty minute intermission), it feels just right - and with the expert direction of Louisa Muller (making her LA Opera debut) and the conducting of the always august James Conlon, time flies.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537746063033/dc_37a2129_pr.jpg.jpg)
<figcaption>Ana Maria Martinez as Elisabeth de Valois in LA Opera's production of *Don Carlo*, 2018. Photo: Cory Weaver/LA Opera.</figcaption>
</figure>

Based on historical events, the main story revolves around King Philip II of Spain (yes, that King Philip II of Spain, the one with the Spanish Armada.) King Philip ([Ferruccio Furlanetto](/scene/people/ferruccio-furlanetto/) who played the same role here in 2006), and his political marriage to Elisabeth De Valois ([Ana Maria Martinez](/scene/people/ana-maria-martinez/)) sets up a love triangle as Don Carlo ([Ramón Vargas](/scene/people/ramon-vargas/)) gains a stepmother when in fact he wishes to gain a wife. Further complicating things is The Grand Inquisitor ([Morris Robinson](/scene/people/morris-robinson/)), who is ready to put everyone to death, (even the king himself), and Princess Eboli ([Anna Smirnova](/scene/people/anna-smirnova/)) who is, herself, in love with Don Carlo. But from the beginning to the end, it's Don Carlo's best friend Rodrigo, who continually saves the day and proves to be the epitome of devotion and self-sacrifice. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537746090849/dc_t8a2581_pr.jpg.jpg)
<figcaption>Anna Smirnova as Princess Eboli in LA Opera's production of *Don Carlo*, 2018. Photo: Cory Weaver/LA Opera.</figcaption>
</figure>

There are superlatives for almost every member of the cast. Bass Furlanetto, whose voice and acting are equally deep, brings humanity to the villainous Philip, capturing both the public hubris and private agony of the troubled king. (The second half of the opera opens with a moving rendition of the King's anguished "Ella giammai m'amo".)	

Soprano Ana Maria Martinez shows off her versatility, playing the repressed Elisabeth after having played the passionate and flighty Carmen last season. But the best mezzo material is given to Anna Smirnova as Princess Eboli. Running the gamut from comic relief to passionate jealousy and finally to dramatic repentance, Ms. Smirnova makes a breathtaking debut at LA Opera, and leaves us with her voice ringing in our memory.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537746113469/dc_t8a3042_pr.jpg.jpg)
<figcaption>Morris Robinson as the Grand Inquisitor in LA Opera's production of *Don Carlo*, 2018. Photo: Cory Weaver/LA Opera.</figcaption>
</figure>

Morris Robinson hits his third home run in a row at LA Opera as the blind, self-righteous, single-minded Grand Inquisitor.  Having wowed us as Zaccaria in *Nabucco*, and Sparafucile in *Rigoletto*, he’s become a regular at LA Opera and he lifts any production to the sublime in any role that he plays. The up-and-coming Soloman Howard has the small but important book-ending role as the ghostly Friar.

Only Ramón Vargas, in the title role, doesn't quite live up to expectations. His voice is not a trumpet but more like a horn with a mute, thin at the top and often hidden by the other voices. Though overpowered in the duets, he rises to the occasion in the quartet with Domingo, Martinez and Furlanetto.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537746128891/dc_37a2661_pr.jpg.jpg)
<figcaption>Ramón Vargas as Don Carlo in LA Opera's production of *Don Carlo*, 2018. Photo: Cory Weaver/LA Opera.</figcaption>
</figure>

The evocative set was created by the late John Gunter.  A labyrinth of arches moves in and out easily and efficaciously (hurray for quick set changes) creating different spaces (a tomb, a garden, etc.) by simply changing the depth of field.  Above it all and pressing down on the entire proceedings are recreations of Great Masters' paintings depicting The Inquisition. Scenes of blood and torture remind us that things could go very badly at any moment for Don Carlo and friends. At the end of Act II, Mr. Gunter has an enormous crucifix, with an enormous Jesus, rise from the stage and hang over the crowd like the sword of Damocles. (This moment begins a scene with the entire cast and crew gathering for an *auto-de-fe*, hauntingly staged by Ms. Muller.)

Black is the new black with Tim Goodchild's costumes, who has found a myriad of ways to individualize all the members of the aristocracy with variations on the same dark but ornate theme. A great moment is when King Philip and Elizabeth appear in spectacular gold crowns and breastplates, and look like sun gods standing in relief against the inky company of players.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537746172680/dc_t8a9640_pr.jpg.jpg)
<figcaption>A scene from LA Opera's production of *Don Carlo*, 2018. Photo: Cory Weaver/LA Opera.</figcaption>
</figure>

The opening night performance was simulcast to a crowd at the Santa Monica Pier. Mr. Conlon received a small inflatable palm tree at the curtain call. Mr. Domingo tossed a beach ball into the orchestra pit. What is it they say about "young at heart?"

There are five more performances of *Don Carlo* between September 29 and October 14. There will also be a concert performance of *Don Carlo* presented at 7:30pm on Monday, October 1, at the Musco Center for the Arts at Chapman University (1 University Drive, Orange, CA 92866). For information about this performance, please visit [MuscoCenter.org](http://muscocenter.org/).
