+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2017-09-15T19:39:00-04:00"
lastmod = "2017-09-16T09:19:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505520495584/2017-09-15---square---car_0638.jpg.jpg"
primary_image_credit = "Ana Maria Martinez in the title role of LA Opera's production of Carmen, 2017. Photo: Ken Howard/LA Opera."
publishDate = "2017-09-16T09:19:00-04:00"
related_articles = ["articles/in-review-carmen-at-the-coc.md", "articles/carmen-don-juan-and-gender-reversal-pants-roles-indeed.md", "articles/nabucco-is-hard-to-find-in-the-latest-la-opera-production.md", "articles/a-dreamy-indulgence-the-pearl-fishers-in-chicago.md"]
related_companies = ["scene/companies/los-angeles-opera.md"]
related_people = ["scene/people/riccardo-massi.md", "scene/people/ana-maria-martinez.md", "scene/people/philip-cokorinos.md", "scene/people/theo-hoffman.md", "scene/people/kelley-oconnor.md", "scene/people/liv-redpath.md", "scene/people/amanda-woodbury.md", "scene/people/brandon-jovanovich.md"]
short_description = "If you&#039;re someone who has seen little or no opera, Carmen is perhaps the perfect place to start because it&#039;s a perfect show; the libretto and score are true partners. Although the show runs about three and a half hours, the drama is so compelling and the music is so beautiful, you never find yourself looking at your watch (or, depending on your age, the clock on your cellphone)."
slug = "la-opera-scores-in-first-half-of-bizet-double-header"
title = "LA Opera scores in first half of Bizet double-header"

+++
[LA Opera](/scene/companies/los-angeles-opera/), now in its fourth decade (bravi!), begins its 2017-18 season with [*Carmen*](https://www.laopera.org/season/1718-Season/Carmen/), also known as "Bizet's Greatest Hits." Georges Bizet, alas, died too young to see *Carmen* become one of the most beloved operas of all time. He also died long before practically every one of his melodies was co-opted by the film and advertising industries, making the music instantly recognizable and popular for completely different reasons.

If you're someone who has seen little or no opera, *Carmen* is perhaps the perfect place to start because it's a perfect show; the libretto and score are true partners. Although the show runs about three and a half hours, the drama is so compelling and the music is so beautiful, you never find yourself looking at your watch (or, depending on your age, the clock on your cellphone).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505520674192/2017-09-15---car_0292.jpg.jpg)<figcaption>The women of the LA Opera chorus in the opening scene of LA Opera's production of *Carmen*, 2017. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

Furthermore, you don't need to take a class, or bring a scorecard to be moved by the story. The characters are complicated (i.e., three-dimensional), but the plot isn't. The story is about the conflict between lust and love, or lust and obsession, and at the center of it all is opera's hottest heroine - a woman who knows what she wants, or rather what she doesn't want - that is, to be owned. The value of liberty here is seen as more valuable than life itself, especially among the libertines. Carmen lets us know right away in her introductory aria ("Habanera") that she isn't interested in monogamy, but the smitten soldier Don José isn’t paying attention to the lyrics. He gives up his entire life, family and career for her, only to be jilted as Carmen moves on to the *toreador* Escamillo. The audience knows that tragedy is inevitable and the superb theatricality of it all won't let us look away.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505520652431/2017-09-15---car__3545.jpg.jpg)<figcaption>Anna Maria Martinez as Carmen and Riccardo Massi as Don José in LA Opera's production of *Carmen*, 2017. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

For this LA Opera production, the voice casting is exactly right. [Ana Maria Martinez](/scene/people/ana-maria-martinez/), who often plays the title role in *Madama Butterfly*, performs her first Carmen and brings a dense, resonant full-bodied mezzo to the table. Likewise, [Riccardo Massi](/scene/people/riccardo-massi/), who plays Don José (alternately with [Brandon Jovanovich](/scene/people/brandon-jovanovich/)) is a first-class spinto tenor. You can hear the tears in his voice even as he soars to daunting high notes. [Alexander Vinogradov](/scene/people/alexander-vinogradov/), as the bullfighter Escamillo, is the third side of the triangle. While he's small in stature (like a true *toreador*) he takes command of the stage whenever he lets loose with his booming baritone. Both Massi and Vinogradov make their LA Opera debuts.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505520640912/2017-09-15---car__3182.jpg.jpg)<figcaption>Alexander Vinogradov as Escamillo in LA Opera's production of *Carmen*, 2017. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

The supporting cast is tremendous. [Amanda Woodbury](/scene/people/amanda-woodbury/), who has played Micaëla before on the LA Opera stage, deserves her ovation once again. [Liv Redpath](/scene/people/liv-redpath/), [Kelley O’Connor](/scene/people/kelley-oconnor/), [Brian Michael Moore](/scene/people/brian-michael-moore/) and [Theo Hoffman](/scene/people/theo-hoffman/), whom I will refer to as the "criminal quartet" (though they drive some wonderful duets and quintets, etc.) all demonstrate that they have the chops to play leading roles. As Zuniga, [Philip Cokorinos](/scene/people/philip-cokorinos/) doesn't have enough stage time but he makes the most of it, memorable both as a threat (when sober) and as a slight buffoon (when drunk.) 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505520630657/2017-09-15---car_0430.jpg.jpg)<figcaption>Riccardo Massi as Don José and Amanda Woodbury as Micaëla in LA Opera's production of *Carmen*, 2017. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

If you are already a Carmen lover, however, you might be disappointed by the somewhat rudimentary staging by Ron Daniels. The passions inherent in the plot come through only because of the passion of the performers and the orchestra under "master of maestros" James Conlon. While the Dorothy Chandler houses a large stage, Daniels confines much of the action to downstage center, as if the singers need to be up close and personal with Conlon's baton (they're very experienced and don't need that.) 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505520593210/2017-09-15---car_0718.jpg.jpg)<figcaption>Ana Maria Martinez in the title role of LA Opera's production of *Carmen*, 2017. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

The glorious chorus - which has never sounded better - is often reduced to the status of singing statues and looks like a mirror image of those of us in the audience, trying to stay still and not cough while observing the action. Even scenes where there should be a certain amount of chaos (for example, when the cigarette girls start to riot), the actors are broken off into neat little pairs and they don't fight like real human beings. For the famous "Les voici! Voici la quadrille" almost everyone stands perfectly still as four supernumeraries walk back and forth with sequined bullheads on sticks. Over and over again. The children's chorus - also splendid in voice - is at least allowed to point and wave during this staid (and unintentionally comic) moment on stage. 

There are exceptions to all this, such as Woodbury's rendition of "Je dis que rien ne m'épouvante". It was much more poignant because she was allowed to let her emotions move her about the stage.

And then there is the dancing. Choreographer Nuria Castejon teases us with a sensual dance of the gypsies on tabletops in Act II and then stages a show-stopping flamenco outside the bullring in Act III. The exciting syncopation from the snapping of the dance fans and the tapping of heels isn't in the score and Castejon uses her dancers as unexpected musical instruments playing with the orchestra.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505520508161/2017-09-15---car__1471.jpg.jpg)
<figcaption>The dancers in the final scene of LA Opera's production of *Carmen*, 2017. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

One big mistake (made by many who produce *Carmen*) is the overlong set change from Act III, Scene One to Act III, Scene Two. Designers become so enamored of creating a realistic mountain for the smugglers that they cause problems for the transition into the bullring. The momentum of the show is always broken when the choice is made to…dare I say it?…move a mountain.

In an inspired programming choice, LA Opera next presents Bizet's *The Pearl Fishers*, giving Los Angeles a chance to hear both of the composer's operas back to back. *The Pearl Fishers* is often referred to as "Bizet's other opera" because *Carmen* is so famous but it has a universally admired score. (Bizet wrote other operas, but these two are the only ones that have made it into the world repertory.) This reviewer looks forward to seeing *The Pearl Fishers* when it opens on October 7. In the meantime, *Carmen* continues with performances on **September 17, 20, 23, 28 and October 1st**. Note that the performance on the 28th has recently been added.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505520519748/2017-09-15---car__4689.jpg.jpg)
<figcaption>Riccardo Massi as Don José and Ana Maria Martinez as Carmen in LA Opera's production of *Carmen*, 2017. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

Also please note the wonderful program that allows all Angelenos to see [*Carmen*](https://www.laopera.org/season/1718-Season/Carmen/) for FREE on two big screen outdoor broadcasts. Thanks to funding from the L.A. Board of Supervisors, the opera will be presented on **September 23 at 7:00pm** in Exposition Park and also at the Santa Monica Pier. [Click here for details.](https://www.laopera.org/operainthepark)

Bravi, indeed.