+++
author = ["authors/john-hohmann.md"]
categories = "Op-Ed"
date = "2019-02-02T08:14:50+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1548957086/media/2019/01/sqBNPg4.jpg"
primary_image_credit = "Nilsson's mischievous personality comes through even in this formal portrait. Photo courtesy of Decca Classics."
related_articles = ["articles/the-rose-elf-hot-times-in-the-cool-catacombs.md", "articles/summer-nights-at-the-opera-an-observation.md", "articles/the-medium-opera-as-film-noir.md"]
related_companies = []
related_people = []
short_description = "The box seems to generate its own energy. Covered in sophisticated hues of copper and gray with a resplendent image of Birgit Nilsson as Brünnhilde, who had surely passed through hair and make-up before leaving Valhalla, it is of monolithic proportions."
slug = "la-nilsson-celebrating-birgit-nilsson-at-100"
title = "La Nilsson: celebrating Birgit Nilsson at 100"
youtube_url = ""

+++
The box seems to generate its own energy. Covered in sophisticated hues of copper and gray with a resplendent image of Birgit Nilsson as Brünnhilde, who had surely passed through hair and make-up before leaving Valhalla, it is of monolithic proportions. The subtle click of padded magnets on the front gives the impression of substance and staying power, in short the essence of Nilsson.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548611271/media/2019/01/LaNilsson80652.jpg){{% /md %}}

<figcaption>Image: Decca Classics.</figcaption>

</figure>

This boxed set of newly remastered studio recordings, primarily on Decca, Deutsche Grammophon, and Philips, celebrates the 100th anniversary of her birth that took place on May 17, 1918. This is not so much a review as it is a consideration of greatness and how effectively it can be repackaged.

Few, if any, opera singers have achieved the consistent critical acclaim and public adoration, as has Nilsson. Her flawless technique and boundless energy are spectacularly represented on 81 disks, including 79 compact disks and two DVDs. Additionally a formidable book tops the package containing complete track listings and illuminating essays - along with a few errors that will send fans scurrying off to confirm the facts. The book is generously graced with performance and rehearsal photographs. There is also an abundance of candid shots that capture Nilsson's vibrant personality. Together they portray Nilsson in all manner or action whether riding the hell out of an exercise bike during the 1966 _Elektra_ recording or as a rather formally posed Minnie, with gun on hip from Puccini's _La fanciulla del West_.

> We've known this _Ring_ for decades. It was the first ever recording of the cycle in a studio, a pioneer in stereophonic technology, and the signature work of Decca producer, John Culshaw.

At the least this luxurious but not excessively packaged collection - let's call it Brünnhildian - offers the opportunity to worship this peerless operatic goddess from a single source. For those who are coming to know Nilsson only now, it is quite simply a treasure trove.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548609456/media/2019/01/sqBNPg84Elektra.jpg){{% /md %}}

<figcaption>Nilsson as the tormented Elektra. Her portrayal remains definitive. Photo Credit: Decca Classics.</figcaption>

</figure>

But where does one start? Channeling the mischievous spirit that has long been associated with Nilsson, I resisted the obvious lure of the _Ring_ and opted for Tosca. Yes, _La Nilsson_ travels beyond Wagner and Strauss to include Puccini, Verdi, Mozart, Beethoven, Sibelius and Weber as well.

Franco Corelli and Dietrich Fischer-Dieskau join Nilsson in this _Tosca_ that has by some been termed a veritable shouting match. With a sexually harassed Tosca, a tortured Cavaradossi, and a sadistic Scarpia, there is plenty of reason to shout. The result however is three pitch-perfect singers who go for intensity and volume over characterization. Despite this wacky approach, the recording gels in its own unorthodox manner because the powerhouse singers are matched by the ferocious intensity with which Lorin Maazel propels the orchestra of the Accademia di Santa Cecilia. If nothing else, it's an ear-opener.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548610522/media/2019/01/BNPg24.jpg){{% /md %}}

<figcaption>A youthful Nilsson as Salome in Stockholm. Photo: Decca Classics.</figcaption>

</figure>

Mischief satisfied, I succumbed to the _Ring_ and found myself in Vienna's Sofiensaal, that legendary dancehall turned Decca recording studio, for Sir Georg Solti's historic studio recording. We've known this _Ring_ for decades. It was the first ever recording of the cycle in a studio, a pioneer in stereophonic technology, and the signature work of Decca producer, John Culshaw. Listening to this _Ring_ and subsequent recordings for which Culshaw served as producer, it becomes apparent that he exerted a significant influence on Nilsson's studio recording oeuvre.

_The Golden Ring_, one of the two DVDs included, while mainly centered on the recording of _Götterdämmerung_, tells of how Culshaw convinced Decca executives that a studio _Ring Cycle_ was economically viable when he persuaded the legendary Kirsten Flagstad to sing the relatively small role of Fricka. Sadly, Flagstad's failing health allowed her to assume the role only on _Das Rheingold_. The great Christa Ludwig stepped in for _Die Walküre_.

This film, regarded as one of the best musical documentaries every made, provides some indication of Culshaw's interpersonal acumen in dealing both with Nilsson who had definite ideas about her vocal placement and with a rather highly-strung Solti. While listening anew to this _Ring_ one might go for immersion status by reading Culshaw's captivating _Ring Resounding_, his memoir that chronicles life at the Sofiensaal during the seven-year recording process. It's the ultimate insider's view of a rare artistic and technological collaboration. It is also quite funny, opinionated, and full of surprises.

> The exotically clad Nilsson looked more like the cat who swallowed the canary than the disturbed teen-age princess who had violated the severed head of John the Baptist.

An attendant luxury of _La Nilsson_ is the inclusion of still another _Ring_, this one from Wagner's own stage at Bayreuth and under the more relaxed baton of Karl Böhm. Within easy proximity we can hear how Nilsson's Brünnhilde adapts to each environment, most especially in her _Walküre_ Act III exchanges with the Wotans of Theo Adam on stage and George London in the studio. Clearly this additional _Ring_ is included not to encourage listeners to judge one over the other but to experience the voice, technique and interpretative prowess of Nilsson from a broad perspective. It would be folly to deny the pleasure and Wagnerian insight that _La Nilsson_ offers by deeming one superior to the other. This is a centennial birthday celebration after all, not a debate over a foregone conclusion.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548956581/media/2019/01/turandot1966-67.jpg){{% /md %}}

<figcaption>Nilsson's Turandot (1966-1967), arch and uncompromising, always soared over the orchestra. Photo courtesy of Decca Classics.</figcaption>

</figure>

One has a similar if less complex reaction to the two recordings of _Turandot_ included, both with the Teatro dell'Opera di Roma. The first, recorded in 1959 under Erich Leinsdorf, and borrowed for the collection from RCA, has the distinction of possessing Jussi Björling as Calaf and Renata Tabaldi as Liù. In the 1965 recording under Francesco Molinari-Pradelli, Nilsson is joined by Franco Corelli and Renata Scotto. When it comes to Nilsson, we know that her interpretation will revolve around an arch and uncompromising princess that was the _Turandot_ of her era. Recently Nina Stemme, who is in the process of becoming Nilsson's heir apparent, has done much to humanize this character. While Corelli is ardent, Björling is transcendent and listeners can compare the remastered Renatas with all of the scrutiny they care to apply. Perhaps this is _La Nilsson_'s contribution to rainy day fun.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548610352/media/2019/01/BNPg95.jpg){{% /md %}}

<figcaption>Sir Georg Solti, Birgit Nilsson, unidentified male and producer, John Culshaw during the 1960-61 recording of Un ballo in maschera at the Accademia di Santa Cecilia, Rome. Photo: Decca Classics.</figcaption>

</figure>

Richard Strauss' two one-act operas, _Salome_ and _Elektra_, both recorded at the Sofiensaal under Solti and produced by Culshaw, retain pride of place. They may constitute Nilsson's greatest hold on recorded immorality. Along with the composer's _Die Frau ohne Schatten_ with Böhm, recorded live at the Vienna State Opera, they remain definitive recordings despite what some consider excessive studio intervention on _Salome_.

_Elektra_ retains a dramatic standard that has yet to be equaled. Here it assumes the role of a companion piece to the 1980 video from the Metropolitan Opera under James Levine. Leonie Rysanek as Chrysothemis joins Nilsson in a production that looks a bit frumpy by today's standards but is nonetheless a potent reminder of two powerful singing actresses. Additionally Mignon Dunn revels in Klytaemnestra's guilt and mines every bit of the role's gallows humor.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548611166/media/2019/01/NilssonSalome.jpg){{% /md %}}

<figcaption>Nilsson's Salome cover photo has endured since its original release on LP and appears in La Nilsson.</figcaption>

</figure>

The cover photo for _Salome_, having survived several packaging concepts over the years, continues to fascinate. When I first saw it on a boxed set of LPs in a sidewalk stand outside a liquor store, the exotically clad Nilsson looked more like the cat who swallowed the canary than the disturbed teen-age princess who had violated the severed head of John the Baptist. Surely Decca's designers weren’t being flip during the photo session so perhaps Nilsson was up to some subtle mischief that has managed to last for decades. Nilsson was well known for her practical jokes and a humorous thread runs subtly through many of the photos in the accompanying book and reproduced LP covers.

Stemme, by the way, was awarded the 2018 Birgit Nilsson Prize; a $1 million gift awarded every three years by the Birgit Nilsson Foundation, for artistic excellence that will stand the test of time. She has stepped with rare distinction into Nilsson territory with acclaimed interpretations of Elektra, Isolde and Salome in addition to Turandot. While on the subject of money, Nilsson appears as a benignly rendered Elektra on the 500 Kronor Swedish bank note. She joins the likes of Ingmar Bergman and Greta Garbo to put this recognition in cultural perspective.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548610567/media/2019/01/Nilsson7592.jpg){{% /md %}}

<figcaption>Nilsson is rendered as a benign Elektra on this 500 Kronor Swedish bank note. She joins the likes of Ingmar Bergman and Greta Garbo who also appear on Swedish currency. Photo: Sveriges Riksbank.</figcaption>

</figure>

In addition to cooperating with _La Nilsson_, the foundation authorized the release of a set of live Nilsson recordings featuring _Die Walküre_ at the Metropolitan Opera under Herbert von Karajan, two _Tristans_, two _Elektras_ and a _Turandot_ conducted by Leopold Stokowski. Those inclined to listen for vocal strain in these live recordings will have their work cut out for them.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548956824/media/2019/01/BNPg57.jpg){{% /md %}}

<figcaption>Nilsson as Isolde in the 1966 Beyreuth Festival production under Karl Böhm. Photo courtesy of Decca Classics.</figcaption>

</figure>

Many collections of the size and scope of _La Nilsson_ have their catchall disk, where this and that, as it were, takes up residence. Here that role falls to the lovely collection of Scandinavian songs, _Land of the Midnight Sun_. With plenty of room left on the CD transfer, the space is filled by the Christmas standards, "O Holy Night", "Ava Maria" (Gounod), "Panis Angelicus" and "Silent Night". As if to give Culshaw the last word, the CD ends with "I Could Have Danced All Night", from Lerner and Loewe's _My Fair Lady_, in which Nilsson belts the last note into the heavens. Her show-stopping rendition appeared in a faux gala that Culshaw concocted for a recording of _Die Fledermaus_ including such opera greats as Leontyne Price, Joan Sutherland and Jussi Björling. While it does nothing to unite the disk it is a witty and dazzling moment.

> Who but Nilsson has captured with such refined exuberance and reverence Elizabeth's aria from _Tannhäuser_, "Dich, teure Halle"?

_La Nilsson_'s first three disks, the obvious entry point, capture the 1960 _Tristan and Isolde_ with Solti and the Vienna Philharmonic followed by a rehearsal session narrated by Culshaw, a sober introduction to the collection for sure. Were I to search for an entry point once again, I might forego the obvious, also resist the temptation of _Tosca_ (disks 37 and 38) and move one up to 39, the collection of arias by Wagner, Weber, and Beethoven. Who but Nilsson has captured with such refined exuberance and reverence Elizabeth's aria from _Tannhäuser_, "Dich, teure Halle"? By any measure, this is _La Nilsson_'s welcome of welcomes, one that captures Nilsson's superb artistry and, when taken out of strict operatic context, a hint of her mischievous nature as well.