+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-07-02T12:07:00-04:00"
lastmod = "2018-07-05T11:12:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530547643603/sqDSC_4942.jpg.jpg"
primary_image_credit = "Pacific Opera Project's production of La gazzetta, 2018. Photo: Martha Benedict.÷"
publishDate = "2018-07-02T12:07:00-04:00"
related_articles = ["articles/dont-miss-la-gazzetta-.md"]
short_description = "All the antics amount to nothing more than a big helium balloon and to keep the whole enterprise on the ground, director and designer Josh Shaw has approached it as if it were a musical-comedy. Every &quot;song&quot; is a &quot;number&quot; filled with coordinated movements and choreography."
slug = "la-gazzetta-the-funny-papers"
title = "La Gazzetta: The Funny Papers"
+++

When most opera lovers hear the name Rossini, they immediately think of *Il barbiere di Siviglia*, *La Cenerentola*, *Tancredi* or a few of his other titles that have made it into the worldwide repertory. Some might not even think of his operas as much as they think of his great opera overtures, such as his famous composition for *Guillaume Tell* (often performed as an orchestral piece.) Most will not think of the other thirty-plus Rossini operas that are hardly performed and which rarely see "the light of stage."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530547556574/DSC_4934.jpg.jpg)
<figcaption>Pacific Opera Project's production of *La gazzetta*, 2018. Photo: Martha Benedict.</figcaption>
</figure>

[Pacific Opera Project](https://www.pacificoperaproject.com/), however, is a bright beacon in the Los Angeles Opera world – not only illuminating well-known classics, such as [Mozart's *Don Giovanni*](/when-don-giovanni-is-the-don/), but also more obscure titles such as Rossini's *La gazzetta*, concluding its run July 6 and 7 at the Highland Park Ebell Club. Talk about rare – this production of *La gazzetta* is only the second ever seen in North America.

The title translates as "The Newspaper" but it has as much to do with the news as *The Barber of Seville* has to do with a close shave. You can see why it’s not done very often.  Musically it sounds a lot like Rossini that we've already heard. No surprise since some of the music is from earlier Rossini operas and some of the music was purloined by the composer in later works. Plot-wise, it’s a puffed pastry that's pure *opera buffa*, and we've seen it all before many times (again in other Rossini operas and in the works of his contemporaries.) A wealthy narcissist (Don Pomponio) takes out an ad to offer his daughter in marriage, not realizing she has the hots for a Parisian hotelier.  The father and daughter are, of course, staying at the very hotel where her lover works and there is, of course, another father and daughter there to begin the farcical chain of mistaken identities. The rest of the contrivance is similar to Shakespeare's *The Merry Wives of Windsor* as Pomponio becomes the victim of several practical jokes and there is a finale where everyone appears in disguise. It's also similar to *The Merchant of Venice* – in spite of all of Pomponio’s schemes, he's destined to lose his daughter to his least favorite candidate for son-in-law.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530547569676/DSC_5042.jpg.jpg)
<figcaption>Pacific Opera Project's production of *La gazzetta*, 2018. Photo: Martha Benedict.</figcaption>
</figure>

All the antics amount to nothing more than a big helium balloon and to keep the whole enterprise on the ground, director and designer Josh Shaw has approached it as if it were a musical-comedy. Every "song" is a "number" filled with coordinated movements and choreography (choreographer Amy Lawrence is also credited here.) In fact, there is hardly a moment where anyone sits still. By the end of the two-and-a-half hour opera, the audience members – but not the singers – are breathless. It's a great testament to the talented performers that they can sing through all the theatrical calisthenics.

There are perhaps one or two kick lines too many, but Mr. Shaw's approach makes for a joyous evening’s entertainment and he "finds the funny" in just about every moment.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530547581122/DSC_5057.jpg.jpg)
<figcaption>Pacific Opera Project's production of *La gazzetta*, 2018. Photo: Martha Benedict.</figcaption>
</figure>

E. Scott Levin, who was so tremendous as wingman Leperello in POP's [*Don Giovanni*](/when-don-giovanni-is-the-don/), gets the main role this time as Don Pomponio and he is the star attraction.  It's clear why he is a mainstay with this company. He is a quadruple threat: world-class singer, actor, comedian and he's light on his feet, meeting all the "dancing" demands of Mr. Shaw and Ms. Lawrence. And speaking of *The Merry Wives of Windsor*, what a thrill it would be to see this superb performer take on Verdi's *Falstaff* one day (soon we hope).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530547592806/DSC_5247.jpg.jpg)
<figcaption>Pacific Opera Project's production of *La gazzetta*, 2018. Photo: Martha Benedict.</figcaption>
</figure>

Armando Contreras as Fillipo the hotel manager, is another baritone with gravitas and he is quickly making his mark in the opera world. Molly Clementz as Doralice is a mezzo to be reckoned with.  The rest of the principals were excellent actor/comedians but their voices are more suited for light opera. Rachel Policar, who is called on to do some death-defying coloratura work as Lisetta, is a lovely crowd pleaser, though her voice doesn't quite have the presence of other sopranos who specialize in this kind of role.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530547606161/DSC_5283.jpg.jpg)
<figcaption>Pacific Opera Project's production of *La gazzetta*, 2018. Photo: Martha Benedict.</figcaption>
</figure>

As for the chorus, it doesn't get much better than this and from the very first note their blend is perfection.

The ten-piece chamber orchestra is a little shaky at times – especially during the overture – but under the baton of Brooke DeRosa they manage to carry the show on their twenty or so shoulders.

Mr. Shaw sets the show in 1963 and there is a lot of fun with 60’'s designs. The women in the hotel staff look a bit like TWA flight attendants and Ms. Clementz reminds one of Nancy Sinatra, with go-go boots and all.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530547618863/DSC_5296.jpg.jpg)
<figcaption>Pacific Opera Project's production of *La gazzetta*, 2018. Photo: Martha Benedict.</figcaption>
</figure>

[*La gazzetta*](https://www.pacificoperaproject.com/lagazzettarossini) is sold out, but the performance on Saturday, July 7th, will be streamed via Facebook Live at 8p.m. PT, giving everyone a chance to enjoy the frolic.

Upcoming later this year, POP will also present *Carmen*, *La Traviata*, and their annually popular hipster version of *La Bohème*.

*La gazzetta* concludes July 6 and 7, and details of the live broadcast performance are in the video below:

<figure data-type="video">
<iframe width="756" height="425" src="https://www.youtube.com/embed/pRoHXQ5IJJs" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</figure>

