+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-03-29T18:37:06+00:00"
disclaimer = ""
image_gallery = []
postamble = "The Royal Opera's production of _La forza del destino_ continues through 22 April. For details and ticket information, [click here](https://www.roh.org.uk/productions/la-forza-del-destino-by-christof-loy-)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553885623/media/2019/03/sq0430JonasKaufmannasDonAlvaroLudovicTezierasDonCarloROH2019photographbyBillCooper.jpg"
primary_image_credit = "Jonas Kaufmann (Don Alvaro) and Ludovic Tézier (Don Carlo) in La forza del destino, ROH, 2019. Photo: Bill Cooper."
related_articles = ["articles/in-review-il-trovatore-at-roh.md", "articles/opera-laid-bare-for-better-or-for-worse-in-the-mets-fanciulla.md", "articles/constructive-frustration-from-roh-s-queen-of-spades.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/ferruccio-furlanetto.md", "scene/people/ludovic-tezier.md", "scene/people/liudmyla-monastyrska.md", "scene/people/jonas-kaufmann.md"]
short_description = "This was a fairly standard production with a bit of a modern twist from designer Christian Schmidt, directed by Christof Loy. A star-studded production, it is currently enjoying a near sold out run at the Royal Opera."
slug = "the-powers-of-fate-great-singing-la-forza-del-destino"
title = "The powers of fate & great singing: La forza del destino"
youtube_url = ""

+++
It is undoubted that Verdi is one of the greatest operatic composers of all time and whose works remain beloved by many. His 1869 revised version [_La forza del destino_](https://www.roh.org.uk/productions/la-forza-del-destino-by-christof-loy-) is one of his greatest. It offers a level complexity and maturity not present in some of his earlier works that hints at what is to come with master-works like _Don Carlo_, _Otello_, and _Falstaff_.

Here Verdi tackles what is perhaps one of the biggest themes in opera; fate. The overbearing, all-consuming character in this opera. He also raises questions about politics, nationalism, racism, and religiosity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1553885498/media/2019/03/001JonasKaufmannasDonAlvaroLaforzadeldestinoROH2019photographbyBillCooper.jpg){{% /md %}}

<figcaption>Jonas Kaufmann (Don Alvaro) in La forza del destino, ROH, 2019. Photo: Bill Cooper.</figcaption>

</figure>

>We are presented with what appears to be a standard period piece but as the opera goes on, it appears that time a place is irrelevant.

With so many grand, overarching themes, the story at its core remains remarkably straightforward. Leonora and Alvaro are in love but her father, the Marquis will not allow her to marry below her station. In a failed attempt to elope, the Marquis is accidentally killed by Alvaro. The couple flee the pursuit of Leonora's vengeance-seeking brother Carlo and go into hiding. They are separated for years, each assuming the other is dead until fate brings the three together once more when Alvaro mortally wounds Carlo in a duel. Carlo then kills Leonora, finally avenging his father and Leonora dies in Alvaro's arms, leaving him alone once more. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1553885519/media/2019/03/069LiudmylaMonastyrskaasLeonoraLaforzadeldestinoROH2019photographBillCooper.jpg){{% /md %}}

<figcaption>Liudmyla Monastryrska (Leonora) in La forza del destino, ROH, 2019. Photo: Bill Cooper.</figcaption>

</figure>

The heavy weight of destiny can be felt throughout the opera as we move through the intervening years. It is written into Verdi's dark and ponderous music. Time unkind to the ill-fated lovers and they both find their own way to the church, committing themselves to lives of penance and hermitage. Their decades-long suffering before their tragic end, makes it all the more heartbreaking.

This was a fairly standard production with a bit of a modern twist from designer Christian Schmidt, directed by Christof Loy. A star-studded production, it is currently enjoying a near sold out run at the Royal Opera. I did however question some of the aesthetic choices and found that the production contained several unforgivable inconsistencies. 

>I have had the opportunity to see a few world-famous singers on stage, but it is very rare thing for a singer to draw a perceptible ripple from the audience.

The staged overture perfectly sets up the the story and is framed so well within the context of the score. We are presented with what appears to be a standard period piece but as the opera goes on, it appears that time a place is irrelevant. There is a fairly specific aesthetic to the stage design which draws inspiration from classic Italian cinema, devotional spaces, and the grim landscape of war, but there was a real lack in consistency in the costuming which seemed to be an unsettling patchwork of dress from across many ages. I know that when a design team makes a choice like this, it is intentional but if I can't discern the reason for it, it becomes a distracting inconvenience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1553885537/media/2019/03/1259LudovicTezierasDonCarlodiVargasLaforzadeldestinoROH2019photographbyBillCooper.jpg){{% /md %}}

<figcaption>Ludovic Tézier in La forza del destino, ROH, 2019. Photo: Bill Cooper.</figcaption>

</figure>

The production was very intelligently cast, a cash cow for the season at the Royal Opera. I have had the opportunity to see a few world-famous singers on stage, but it is very rare thing for a singer to draw a perceptible ripple from the audience. This is apparently what it is like to see [Jonas Kaufmann](/scene/people/jonas-kaufmann/) live to a sold-out house. Despite recent illness, his voice is sounding healthy. He has a glorious, infectious presence on stage. He is intuitive in his acting and you can feel in a really real way, the joy he has for singing. What I like about Kaufmann is that he takes risks with his voice, risks that are not always successful but I appreciate that when he could just plant himself on stage and give us the full force of his voice, he instead shapes the text with the sensitivity of a German lied. It is a rare and wonderful thing to hear on a stage like this.

>For me, a beautiful voice is simply not enough to carry a role.

Ukrainian soprano [Liudmyla Monastryrska](/scene/people/liudmyla-monastyrska/) takes on the role of Leonora and gives a performance that felt very confident and effortless. She was able to perfectly balance strong conviction with pity and relatability. No stranger to the leading ladies of Verdi, having performed a number of them at this point in her career, her voice was lush and vibrant. Leonora was a suitable and comfortable fit for her.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1553885580/media/2019/03/0401FerruccioFurlanettoasPadreGuardianLaforzaROH2019photographedbyBillCooper.jpg){{% /md %}}

<figcaption>Ferruccio Furlanetto (Padre Guardiano) in La forza del destino, ROH, 2019. Photo: Bill Cooper.</figcaption>

</figure>

Baritone [Ludovic Tézier](/scene/people/ludovic-tezier/) in the role of Don Carlo had one of the most remarkable voices I've heard, yet I felt that there was something lacking in his performance. He seemed to be more focused on producing a beautiful sound that the subtle complexities of his character. His motivations were weak, making his role as the villain a little implausible and the intention was missing from his eyes. For me, a beautiful voice is simply not enough to carry a role. In quite the opposite way, mezzo soprano Veronica Simeoni disappointed me in the role of Preziosilla. Vocally, she was the weakest link in a cast that was overall at a very high standard of performance, but I thought she was a very intelligent and accomplished actress. Unfortunately, though, without the voice to match, it was not enough to draw me into her performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1553885609/media/2019/03/0491JonasKaufmannasDonAlvaroLaforzadeldestinoROH2019photographbyBillCooper.jpg)}{{% /md %}}

<figcaption>Jonas Kaufmann (Don Alvaro) in La forza del destino, ROH, 2019. Photo: Bill Cooper.</figcaption>

</figure>

Two performances of note were bass [Ferruccio Furlanetto](/scene/people/ferruccio-furlanetto/) as Padre Guardiano and baritone Alessandro Corbelli as Fra Melitone. The two made a wonderful comedic pair with Furlanetto the straight man to Corbelli's fool. Corbelli in particular seemed to be the most naturalistic in his character though he did have the advantage of being an exaggerated comedic character. He was everything that I hope to see on stage; a great voice that lends itself to a performance motivated by character.

>It was the characters in relationship to one another that making this such an emotionally charged and memorable experience.

There is no denying that this opera contains some of Verdi's most beautiful and accomplished writing. It is a work that carries the maturity and sensitivity of a man who is now well into middle age. It is harmonically ambitious and often surprising. It is brooding, self-reflective, and intimate. Verdi is known for his epic, extensive opera choruses but there is a sensitivity with which he approached the choral writing in this piece that causes everything that came before to pale in comparison.

This production was an acceptable and straightforward telling of this beloved opera. It contained all of the elements I have come to expect and left me feeling satisfied and fulfilled. But it is the singing that will remembered as the details of the production begin to fade. It was the characters in relationship to one another that making this such an emotionally charged and memorable experience.