+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = 2020-02-03T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "[Houston Grand Opera's production of _La favorite_](https://www.houstongrandopera.org/favorite) continues through February 9."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1580659110/media/2020/02/sqHGO-LaFavorite-2020-OrchestraDressRehearsal-PhotographerLynnLane-206_bl4hwm.jpg"
primary_image_credit = "Houston Grand Opera's production of La favorite, 2020. Photo: Lynn Lane."
related_articles = []
related_companies = []
related_people = []
short_description = "Mezzo Jamie Barton inhabited the lead role of Léonor very naturally indeed, especially in her aria “O mon Fernand,” itself a perfect example of Donizetti’s felicitous employment of confident Parisian harpists and wind players in prominent positions. Such inspired orchestrational choices are the sort of thing that give great singers an optimal point to start their dramatic conceptions of such arias."
slug = "last-minute-surprises-a-star-performance-by-barton-hgos-la-favorite"
title = "Last-minute surprises & a star performance by Barton: HGO's La Favorite"
youtube_url = ""

+++
One could argue that, in a particularly eccentric way, Gaetano Donizetti succeeded in achieving the 19th-century equivalent of the [EGOT](https://en.wikipedia.org/wiki/List_of_people_who_have_won_Academy,_Emmy,_Grammy,_and_Tony_Awards) (Emmy, Grammy, Oscar, Tony): He was one of the few major composers to write for all three of the major opera houses in Paris - the city that served as one of his main bases (along with Vienna) in the last years of his life.

These three performance venues exhibited him tackling several different operatic genres with a sure compositional hand. Before his eventual, premature decline into the haze of mental illness, he would famously write the last major opera buffa of the first half of the century, _Don Pasquale_, for the Théâtre-Italien; he would give the Opéra-Comique the delightful _La fille du régiment_; and he would give the Paris Opera several grandiose works only slightly toned down from the model of grand opera set by Meyerbeer, Halévy, and Auber. Houston Grand Opera made a compelling case for why [_La favorite_](https://www.houstongrandopera.org/favorite) has historically been so fondly thought of among these later works.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580659414/media/2020/02/HGO-LaFavorite-2020-OrchestraDressRehearsal-PhotographerLynnLane-104_wd0rs7.jpg){{% /md %}}

<figcaption>Houston Grand Opera's production of La favorite, 2020. Photo: Lynn Lane.</figcaption>

</figure>

Surprises did await me at every turn: at this performance Lawrence Brownlee was unfortunately indisposed, so Michael Spyres was flown in from New York at the last possible moment to sing the role of Fernand, which he did from stage left as the assistant stage director, Katrina Bachus, walked through the role, essentially being anywhere she had to be and doing all necessary postures while erring on the side of subtlety when it came to emotional display. Spyres displayed all the intense projection and clarity that I have come to admire from him when it comes to singing early French Romantic opera, particularly his recent recordings with Opera Rara of Donizetti’s other operas from this late period. In short, one could easily imagine his distinctively measured and energetic, yet not overpowering, tone to be plausibly and impeccably matched to the Fernand on the stage without difficulty.

> These thematic elements were just in the background enough to enable me to feel relaxed and contemplative, and this was essentially the nature of the production as a whole.

From the grave contrapuntal opening of the overture, I could very easily sense the composer feeling his way around the fascinating new timbres he had at his disposal at the Paris Opera. Although I would greatly have enjoyed hearing what the originally scheduled conductor, Christophe Rousset, would have done with this score (given my familiarity with his championing of French operas), the Houston Grand Opera Orchestra lost nothing in terms of grace and dynamism in the substitution of Artistic Director Patrick Summers; Summers showed a great deal of willingness to engage Donizetti’s sometimes eccentric use of various color and volume choices head-on, without letting any one section of the orchestra be overpowered.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580659279/media/2020/02/HGO-LaFavorite-2020-OrchestraDressRehearsalPhotographerLynnLane-63_fzhvld.jpg){{% /md %}}

<figcaption></figcaption>

</figure>

One can hear Donizetti attempting to create an atmospheric soundscape for this opera in a manner that will become ubiquitous over the next decades, what Verdi will come to refer to as a score’s characteristic tinta. Here, the overall musical atmosphere could be said to exhibit subdued, yet measured, Gallic languor that only sporadically gives way to this composer’s more characteristically fiery temperament; however, do not expect any overt local color here; for that, one must consult [_Maria Padilla_](https://en.wikipedia.org/wiki/Maria_Padilla).

> We are allowed to perceive in an almost interactive fashion that his is a deep, yet conflicted, relationship.

The production featured a bunch of competing elements that brought to the fore HGO’s stated interest in the varied cultural and religious background of medieval Spain. The majority of this production used only one set, which featured a very European wall with many ornate curlicues. It reminded me of the virtues to be found in Islamic art, a combination of restraint and rhapsody. And yet, this design would not be out of place in many European opera productions; this wall had at least one idyllic painting of a grove with lush, verdant trees. Periodically, this wall would be elevated to reveal many Gothic-looking, gnarled tree trunks in the background which gave this plot a somewhat more Romantic twinge of despair.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580659239/media/2020/02/HGO-LaFavorite-2020-OrchestraDressRehearsalPhotographerLynnLane-81_t8cwxs.jpg){{% /md %}}

<figcaption>Houston Grand Opera's production of La favorite, 2020. Photo: Lynn Lane.</figcaption>

</figure>

These thematic elements were just in the background enough to enable me to feel relaxed and contemplative, and this was essentially the nature of the production as a whole, with one glaring exception: at the end of Act III, the male chorus took seemingly unprompted glee in engaging in a riotous frenzy of subjecting Léonor (Jamie Barton) to many attacks to her person, including painting a giant red "x" upon her dress.

I do not doubt that this staging choice got its message across in our current era, but I found its necessity questionable in proportion to its stark disunity from the rest of the production, which otherwise emphasized a sense of equipoise in which to consider the injustices of society’s attitudes towards women at leisure.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580659262/media/2020/02/HGO-LaFavorite-2020-OrchestraDressRehearsalPhotographerLynnLane-74_aakgve.jpg){{% /md %}}

<figcaption>Houston Grand Opera's production of La favorite, 2020. Photo: Lynn Lane.</figcaption>

</figure>

Mezzo [Jamie Barton](/talking-with-singers-jamie-barton/) inhabited the lead role of Léonor very naturally indeed, especially in her aria “O mon Fernand,” itself a perfect example of Donizetti’s felicitous employment of confident Parisian harpists and wind players in prominent positions. Such inspired orchestrational choices are the sort of thing that give great singers an optimal point to start their dramatic conceptions of such arias, and throughout this aria, I perceived Barton's complete awareness and control of the dramatic arc in this piece; I got the sense here particularly, as in many other places, that she picked up instantly on Donizetti's cues to shape these arias concurrently with the musical background. This willingness to infuse bel canto roles with some individuality can spell the difference between inspiration and apathy, and I definitely felt that she led the charge toward placing my impression of this work in the former.

Baritone [Jacques Imbrailo](/scene/people/jacques-imbrailo/) was also filled with many such touches throughout his very complex character. Though his voice was very thin at first, it warmed up in time, and his lyricism made for an antagonist with whom one could empathize, heightened by this production's giving King Alphonse XI a makeshift leg brace and imbuing this role with great poignancy. His relationship with Léonor is clearly more than just a passing fancy, as his aria in Act II allows us to perceive with many shades of detail. We are allowed to perceive in an almost interactive fashion that his is a deep, yet conflicted, relationship.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580659179/media/2020/02/HGO-LaFavorite-2020-OrchestraDressRehearsal-PhotographerLynnLane-176_cdlzn5.jpg){{% /md %}}

<figcaption>Houston Grand Opera's production of La favorite, 2020. Photo: Lynn Lane.</figcaption>

</figure>

Federico de Michelis as Balthasar was also a study in the contrasts his role posed: benevolent cleric to some, threatening messenger to others. Again, this is a role that requires a delicate balancing act between several different elements, and de Michelis's ability to have his vocalism and stage presence complement each other is to be commended.

> How ubiquitous this opera must have been for a composer to consider it common knowledge nearly thirty years after its premiere!

This is certainly not the one-sided image of the clergy that we get from the likes of Fra Melitone or any number of Spanish and Portuguese inquisitors (such as Donizetti would explore in the even more grandiose and nonsensical Dom Sébastien). Particularly intriguing was his Act IV chant-like prayer which featured him singing in unison with English horn and low strings, if my perception was correct. I definitely sensed him and King Alphonse having at least one moment of common understanding when attending the funeral of the King’s deceased wife, a very touching moment in the big picture, given how the vain pursuit of worldly pleasures is a key theme in this opera in any case.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580659427/media/2020/02/HGO-LaFavorite-2020-OrchestraDressRehearsal-PhotographerLynnLane-215_icj07i.jpg){{% /md %}}

<figcaption>Houston Grand Opera's production of La favorite, 2020. Photo: Lynn Lane.</figcaption>

</figure>

At times, Donizetti is apt to form melodies not solely according to his Italian instincts, having to appeal to Parisians' notoriously refined tastes. Throughout, one can hear hints of how he makes greater use of the intrinsic development of motivic cells to create longer melodies in a manner not always associated with the early Italian Romantics, a perfect example being Inès’s Act I aria, whose sheer catchiness and rhythmic appeal Elena Villalón floats effortlessly through. One scarcely conceives the notion of a soprano being a secondary role when a confidante gets such iconic arias.

Don Gaspar (Christopher Bozeka) is a Machiavellian intriguer who enjoys getting his own way without being direct about his approach, though his clear voice drives home his insistent nature at several junctures. He clearly enjoys riling the courtiers up in "Quel marché de bassesse." I mention this chorus in Act III because it is how I first heard about this opera at all, through Offenbach's ingenious verbatim quotation of it in _La Périchole_. HGO has made it a point to emphasize this opera's immense popularity in years past in their marketing campaigns for it: how ubiquitous this opera must have been for a composer to consider it common knowledge nearly thirty years after its premiere!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580659200/media/2020/02/HGO-LaFavorite-2020-OrchestraDressRehearsal-PhotographerLynnLane-144_spf9y7.jpg){{% /md %}}

<figcaption>Houston Grand Opera's production of La favorite, 2020. Photo: Lynn Lane.</figcaption>

</figure>

But that definitely forms part of the appeal of this work; it really gives somewhat of an aura of getting to know someone you have not seen for years, and asking just what this person has been up to. One gets a sense of _La favorite_ being simultaneously par for the course for Romantic opera yet intricately woven and crafted, and all the more approachable for combining both aspects.

When a great team of singers and artists tackle a work like [_La favorite_](https://www.houstongrandopera.org/favorite) on its own terms, and not solely as a representative of various classifications, one need not only call these intrepid persons musicians, but explorers!