+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2022-09-25T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1664056444/media/2022/09/sqBLO_Laboheme_OliviaMoon_2_aegigy.jpg"
primary_image_credit = "Jesus Garcia (Rodolfo) and Lauren Michelle (Mimì) in Boston Lyric Opera's production of La bohème, 2022. Photo by Olivia Moon."
related_articles = ["articles/blo-barber-brings-delightful-laughter-amid-overdesign.md", "articles/blo-s-electrifying-rape-of-lucretia-a-revelation.md", "articles/bohemian-atg-boheme.md"]
related_companies = ["scene/companies/boston-lyric-opera-1.md"]
related_people = ["scene/people/william-guanbo-su.md", "scene/people/edward-parks.md", "scene/people/lauren-michelle.md"]
short_description = "It is surprising how little effectiveness Puccini's score loses when performed in reverse order, and the score still lands each emotional beat even when the context feels radically different."
slug = "la-boheme-reliable-as-ever-even-in-reverse"
title = "La bohème reliable as ever, even in reverse"
youtube_url = ""

+++
The first time I reviewed _La bohème_ with Boston Opera Collaborative's [luminous production ](/intimate-brewery-room-la-bohme-a-revelatory-triumph/)in Turtle Swamp Brewery, I brought up the question of how to perform classics in the operatic repertory in ways that breathes fresh life into the works, and how vital that is when it's a workhorse that has been performed almost to death at this point. I never thought when I wrote that review that I would be grappling with that question once again, albeit in a more radical form.

And yet, here we are, reviewing Boston Lyric Opera's attempt to solve the same question. And their attempt is certainly novel and, to a certain degree, a little sacrilegious: they opted to transfer [Yuval Sharon's production](https://blo.org/boheme/) from this year's Spoleto Festival, which involves performing _La bohème_ in reverse. They opened the show with Act IV, then worked backwards through the entire rest of the opera until the end of Act I. Their rationale? It is meant to evoke the question of "why it happens", rather than "what happens".

I must admit, I was deeply skeptical of this production conceit when I first heard of it. As a composer, we generally tend to make important decisions on how to place things in the score, so how would performing an entire opera out of intended performance order affect how the audience perceives the use of, say, leitmotif and callback to earlier moments in the show? I also fail to grasp what playing it in reverse would reveal about “why it happens” that playing it in order does not: there is certainly nothing in the libretto by Illica and Giacosa that leaves the circumstances of our characters to the imagination, and in my estimation it answers why pretty well. So what does playing it in reverse order reveal about these characters?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1664056504/media/2022/09/BLO__La_boheme__OliviaMoon_1_fsov6h.jpg){{% /md %}}

<figcaption>A scene from Boston Lyric Opera's production of La bohème, 2022. Photo by Olivia Moon.</figcaption>  
</figure>

As it turns out, this production found itself needing to answer that question by inserting an extra character into the proceedings, listed as "The Wanderer" in the program. This was essentially a character who wandered around the stage at a few points in the show, and quite literally stopped the show at a few points to ask, in full-throated English "what would’ve happened if this character did something different at this point in the show". He did not really stop the proceedings in Act IV to ask this as it’s the end of the story, but usually the music would stop and the harp would pluck away while he asked his question.

On its own terms, I am of very mixed minds on the Wanderer and how he fits into the execution of _La bohème_ in reverse. On paper, it feels exactly like the kind of "let’s insert extratextual context into the opera" brand of direction that you see so much in, say, the Bayreuth Festpielhaus, and as somebody who thinks that particular brand of opera direction needs to die I found myself instinctively recoiling. And even as I was watching the show and watching him wander into these scenarios to interrupt the show, I was like "why is this guy here, and can he get out of the way so I can listen to the score".

In the end, though, there was one gesture that occurred right at the end of the performance that made the whole concept click for me. In what is technically the conclusion of Act I but was in practice almost the end of the evening, when Rodolfo is about to head off to Café Momus to join his friends, Mimì runs around the stage, and finds the Wanderer right in where her path is. Normally, he would have stopped the show to ask "what would've happened if X happened", but here he simply says nothing, and for the first (and only) time in the whole production the Wanderer is acknowledged by one of the characters. After this brief second, Mimì turns and asks Rodolfo if she can join them, as she does in the opera, and so they walk off in each other’s arms. The question that hangs in the air felt very much like "how worth it is love even knowing that this whole story ends in tragedy", and I have to admit that the end result at the very least made the whole conceit make some amount of sense on its own merits.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1664057404/media/2022/09/BLO_Laboheme_OliviaMoon_7_pqqm2w.jpg){{% /md %}}

<figcaption>Marshall Hughes (The Wanderer) in Boston Lyric Opera's production of La bohème, 2022. Photo by Olivia Moon.</figcaption>  
</figure>

It also does not hurt that Puccini's score is just as sumptuous in reverse as it is in proper performance order, and that the various callbacks that are situated throughout the score still land the way they should. It is surprising how little effectiveness Puccini's score loses when performed in reverse order, and the score still lands each emotional beat even when the context feels radically different. It truly showed in my reaction to it, in that I found myself in tears at multiple points at all the points I find myself emotional when listening to this score on my own. That the score lost none of its power through the reversal of its order speaks to why this opera is still performed so often in the opera house, and does so in a very strange way.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1664056635/media/2022/09/BLO_Laboheme__OliviaMoon_4_tdcxtg.jpg){{% /md %}}

<figcaption>(l-r) Edward Parks (Marcello), Chelsea Basler (Musetta), William Guanbo Su (Colline), Lauren Michelle (Mimì), Benjamin Taylor (Schaunard), and Jesus Garcia (Rodolfo) in Boston Lyric Opera's production of La bohème, 2022. Photo by Olivia Moon.</figcaption>  
</figure>

It further helps that the production design is mostly pared down, with all the action taking place on an inclined disc that rotated around. The mechanism on which the disc rotated was perhaps a little too loud and sometimes covered up the quieter moments of the orchestral playing, but the pared down production left the show feeling briskly paced, and it indeed had the intended effect of highlighting the kind of poverty the characters face through most of the show.

And for the most part, the central cast carried the show quite well. [Lauren Michelle](/scene/people/lauren-michelle/) was particularly radiant as Mimì: her voice soared above the orchestral direction, and its more melancholic color suited Mimi’s journey quite well. [Edward Parks](/scene/people/edward-parks/) also made for a soulful Marcello, and it was a sore sight when he was not onstage to keep things going. I do think Jesus Garcia’s voice perhaps does not quite project well enough as Rodolfo and I did feel he took a little too long to figure his character out, but he eventually found himself in the latter half of the performance, and he at the very least was a rather good actor. Among the rest of the cast, [Chelsea Basler](/scene/people/chelsea-basler/) made for a hilariously coquettish Musetta, and William Guanbo Su and Benjamin Taylor made for a playful Colline and Schaunard.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1664056822/media/2022/09/BLO_Laboheme_OliviaMoon_5_cwg36y.jpg){{% /md %}}

<figcaption>Jesus Garcia (Rodolfo) and Lauren Michelle (Mimì) in Boston Lyric Opera's production of La bohème, 2022. Photo by Olivia Moon.</figcaption>  
</figure>

Do I think the experiment was completely successful? I am still not sure. Starting the show in Act IV has the effect of making some characters feel much less fleshed out than they would have been in proper performance order (especially Colline and Schaunard and their relationship to Rodolfo and Marcello), and it does rob some of the impact of its finale to start with the death and then go backwards. I also feel that it still begs the question of why one would do this, even after the final curtain.  But on the other hand, the way the elements were handled at the very least kept the whole production from falling into the self-importance trap that these kinds of radical productions so frequently fall into, and as someone who generally hates the "let's add subtext that is not in the source" approach to directing that is a huge compliment. It may not be a _La bohème_ for the ages, but it had something interesting to say, and when trying to breathe new life into a well-worn classic that is the very least one can ask for.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1664056842/media/2022/09/BLO_Laboheme_OliviaMoon_6_dc9lwb.jpg){{% /md %}}

<figcaption>The Café Momus of Boston Lyric Opera's production of La bohème, 2022. Photo by Olivia Moon.</figcaption>  
</figure>