+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-03-12T18:08:00-04:00"
lastmod = "2018-03-13T09:15:00-04:00"
preamble = "With pianist Christina Faye, soprano and arts educator Kyra Millan makes up one half of [Millan & Faye](http://kyra-millan.com/millan-and-faye/), the musical comedy duo that shares opera with audiences young and not-so-young. Millan & Faye bring their [show for young audiences](http://files.coc.ca/pdfs/concert180315.pdf) to the Richard Bradshaw Amphitheatre on **March 15 at noon**, as part of the Canadian Opera Company's Free Concert Series.\n\nWe spoke with Millan about easy-to-break barriers between opera and new audiences, and her great advice about exposing young people to an old art form."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520892359472/sq---HighResMarch15RBA_1%5B1%5D.jpg.jpg"
primary_image_credit = "Soprano Kyra Millan and an Opera for All Ages participant, photo: Lara Hintelmann."
publishDate = "2018-03-13T09:15:00-04:00"
related_articles = ["articles/the-case-for-music-education.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/kyra-millan.md"]
short_description = "&quot;The singing can sound silly to some at first, because it is a very intense, open sound, but with some of the best music ever written in the hands of a skilled artist, live music can bypass the intellect and resonate directly with the soul and heart.&quot;"
slug = "kyra-millan-making-opera-for-all-ages"
title = "Kyra Millan: making Opera for All Ages"
+++

## What do young people like about opera?

That's a huge question.  I cannot speak for all kids, but in my experience, kids I have worked with or performed for, understand play.  Singing and moving and telling stories is part of what they already do.

We had a show in Ottawa where I was singing and was interrupted by a 9-month-old in the front row who started vehemently blurting at me, "AHHH!" I stopped the show, answered with a similar sound and intention and she and I continued on having a mini conversation in song for a while.  She was clearly understanding that this is what humans do - we interact, exchange energy  and connect by telling stories. In the same show, I sang a phrase in which the character finds her voice and finally releases her first big sound - and a little three-year-old threw up his hands and yelled "YAY!!!"

Opera offers a world in which they can actually explore and develop who they are, have discussions about what it is to struggle as human beings, how to understand and empathize with a character (and thus themselves), learn to project their voice, and through that, find their voice. With older children and teens in workshops, they  are *encouraged* to do what they often cannot in everyday life; to be larger than life, be expressive, explore both their voices and movement, take up space, commit to one another, and learn to tell stories with their entire bodies. They get direction on how to be freer, more expressive, or engaged with one another in their work. 

In terms of attending operas, I think if the right opera is introduced to a child, and they understand the story and context before they go in, they will enjoy themselves. *The Magic Flute*, *Carmen*, *L'enfant et les sortilèges*, *La bohème*, *The Barber of Seville* and *The Nightingale* were some of my favourites when I was young.  In fact, I am taking my children and their friends to see the COC's upcoming production of [*The Nightingale and Other Short Fables*](https://www.coc.ca/productions/13109) because it has the perfect combination: a fairy tale set to beautiful music, magical and beautiful design, directed by a master director - Robert Lepage - and his team.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520892439618/mar13hires-27-of-28%5B1%5D.jpg.jpg)
<figcaption>(l-r) Kyra Millan, Danielle MacMillan, Christina Faye and Owen McCausland, photo: Tim Flynn.</figcaption>
</figure>

## How have you overcome barriers to make opera accessible?

Getting folks (adults too, since we have a show for adults as well) gently introduced to opera requires *humour* and a clear insight into what is sublime, but also ridiculous about it. Let's face it, with great art, sometimes you have to suspend disbelief, no? Don't get me started on some of the far-fetched plots...or that characters take a really long time to die while singing.
 
Two objections brought up by audiences are the style of singing and the language barrier.  Many people are not aware that the COC invented the Surtitles™ that we now have at all productions. The plot synopsis is available to read before hand, and there are opera chats before shows to further explore the opera and its history.

The singing can sound silly to some at first, because it is a very intense, open sound, but with some of the best music ever written in the hands of a skilled artist, live music can bypass the intellect and resonate directly with the soul and heart.

## What are some ways parents and teachers can introduce young people to opera as entertainment?

Well, let me tell you about a few videos... Millan & Faye have made three videos - one for each age range. We have an [ABC video](https://youtu.be/GU3wEM6rL_k), *Sesame Street*-style, set to Mozart's and Adam's *Twinkle, Twinkle* variations, a comedic [intro into music lessons](https://youtu.be/1tN_fFKcxaw) for older kids and adults, and a Top-10 list of [all the ways in which women die in opera](https://youtu.be/Tc4wNVoZsaU) - for adults.

<figure data-type="video">
<iframe width="1212" height="681" src="https://www.youtube.com/embed/Tc4wNVoZsaU" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</figure>

YouTube offers access to all kinds of opera; you can watch many versions of actual opera scenes, like Papageno and Papagena's duet from *The Magic Flute*, which is adorable for young grades), and arias like the Doll Song from *The Tales of Hoffmann* is a hit with kids. As well, there are as [masterclasses from great artists like Joyce DiDonato](https://www.youtube.com/results?search_query=joyce+didonato+masterclass), who also blogs and has a particular interest in connecting with young folks through her social media.  

There are brilliant and fun [workshop opportunities](https://learn.coc.ca/eventsprograms), as well as camps right here at the Canadian Opera Company, for teachers and kids who would like more hands-on exposure.  Opera is already pervasive in culture, in movies, commercials, cartoons, and books. (My favourite kid's book about opera is ["The Great Poochini" by Gary Clement](https://www.amazon.ca/Great-Poochini-Gary-Clement/dp/0888999909), in which a dog has a secret life of being a great opera star by night and house hound by day.) 

However, nothing quite matches seeing, feeling and hearing it live.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520892463642/Millan-and-Faye%5B1%5D.jpg.jpg)<figcaption>Millan & Faye: pianist Christina Faye and soprano Kyra Millan.</figcaption>
</figure>

## What can people expect from your Opera For All Ages concert in the RBA this month?

We will be doing a bit of our touring family show, which is a relaxed, whirlwind, interactive introduction to  the world of opera and singing for all ages. While we perform some gorgeous and playful music, we also invite the audience to become part of our show, either as  an orchestra making an overture of inappropriate audience noises, through improvised conversation in recitative,  or by creating a short opera scene with us - finishing with everyone singing a rousing chorus together! They can also expect to laugh, as, occasionally, we are funny.

Our biggest fans while touring this year, have been folks who thought they would hate opera. That always makes us happy, but our goal isn’t just to sell opera. For me, it is about sharing the message of  overcoming fear - of one's own voice, or experiencing something new, and how on the other side of those barriers can be wonderful discovery, growth and Joy.
