+++
author = ["authors/kristen-seikaly.md"]
categories = "Op-ed"
date = "2015-04-16T21:46:00-04:00"
lastmod = "2015-04-20T14:17:00-04:00"
preamble = "This is a repost of a great [article](http://www.kristenseikaly.com/3-steps-to-role-prep-a-guide-to-learning-an-operatic-role/) by mezzo-soprano [Kristen Seikaly](http://www.kristenseikaly.com/). She's got a great [blog](http://www.kristenseikaly.com/blog/), and she was kind enough to let me put her article up for Schmopera readers. Kristen has put together a beautifully detailed list of steps for singers who have a role to learn. Read on and show up to rehearsal like a pro.\n\nFor a follow-up to this article, read Kristen's new post, [*Secco Recitative: A Guide to Learning Operatic Dialogue*](http://www.kristenseikaly.com/secco-recitative-a-guide-to-learning-operatic-dialogue/)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429552948318/Kristen_Fotor.jpg.jpg"
primary_image_credit = "Photo: kristenseikaly.com"
publishDate = "2015-04-17T08:04:00-04:00"
related_articles = ["articles/6-learn-language.md","articles/quick-tips-the-rolled-r-test.md","articles/4-steps-to-taking-fixing-notes.md"]
related_people = ["scene/people/kristen-seikaly.md"]
short_description = "Whether you are just learning your first role or seasoning your role-learning technique, this guide is intended to help you with learning an operatic role as efficiently and painlessly as possible. I hope that you will share with me any tips and tricks that I have not mentioned here."
slug = "kristen-seikaly-on-how-to-learn-a-role"
title = "Kristen Seikaly on how to learn a role"
+++

Whether you are just learning your first role or seasoning your role-learning technique, this guide is intended to help you with learning an operatic role as efficiently and painlessly as possible. I hope that you will share with me any tips and tricks that I have not mentioned here. Not only will it be helpful to my readers, it just so happens that I am learning a role right now myself! I will use the role I’m covering, Prince Orlofsky from Johann Strauss’ *Die Fledermaus*, as my guide for this tutorial. 

## 1. Organize your score 

There is nothing more frustrating and detrimental to the learning process than having to backtrack. That is why my role-learning process aims to minimize this as much as possible. It all begins with organizing your score. What does that mean exactly? 

#### Get the right score


Nothing will help your process more than obtaining the right edition of the score. If you don’t, your page numbers, cut marks, and perhaps even notes and words could be all wrong. Make sure that you find out from the musical director which edition of the score your production will be using. If you are learning a role for your own preparation, do some research and ask around to find out what the best edition of the opera exists. For example, if you are learning Mozart and can afford to shell out the money for a Bärenreiter, do it. Notice the clean lines that are easily erasable, and the VI- on the top left. A -DE will appear at the end of the cut. 

#### Put in your cuts

Be sure to ask the director for any music they may cut from the score as well. Oftentimes the cuts will be organized by page number, then staff number, and finally measure number (to look like this: p/s/m). For example, for *Fledermaus*, we have a cut from 49/3/1 to 51/2/6\. Once you have that information, mark it clearly but sparsely in your score as pictured below. The idea behind this is if and when you perform this role again, you can easily erase previous cuts. Be sure to begin and end your cut with VI-DE (I am unclear as to why it is notated that way; if any of my readers know, please comment below!).

#### Tab your score

There are a wide variety of ways you can tab your score. Some people tab everything while others only tab the exact moment their character enters. I personally like to tab the beginning of a scene number I’m in as that seems to be how rehearsals are normally called. It really depends on what is most helpful to you and the role. As a bare minimum, you will want tabs for your musical entrances.

#### Mark your part

Some people will highlight their entire line. I prefer to highlight only my character’s name. I especially recommend this if there’s any chance that you might play a different character in the same opera someday so that your previous marks are not too distracting. 

## 2. Organize your musical learning process

You’ve organized your score - great! Now it will be that much easier to figure out what you need to learn in what order. I tend to break my learning down like this. 

#### Figure out which sections are easier or harder

Some sections of the score will just take you more time or mental power than others. They may be longer, more musically difficult, or just generally frustrating. Similarly, other sections will take nothing to learn. I like to organize my learning by alternating these kinds of sections. For example, if I start with a difficult section, the next day I’ll work on an easy section. That way, nothing gets put off until the end, nor do you get learner’s fatigue. It’s just like exercise: you wouldn’t want to put in strenuous exercise several days in a row. Instead, you would mix it up with some lighter activity. 

#### Put in your language work before your musical work

If your role is in your native language, congratulations! Your work is easier… for now. If your score is in a foreign language, do your translation and pronunciation work now. Not only will it help you understand how and why the music is written the way it is, you’ll have an understanding of what your character is building towards. I also recommend writing your own translation, first word-for-word and then a poetic one (which I’ll give in more detail for a future post). If you want more help on translating your role, [check out my blog post here](http://www.kristenseikaly.com/why-wordreference-com-is-the-best-translation-tool-for-singers/)
on my favorite FREE translation and pronunciation tool.

#### Learn the rhythms and notes

Wow, that’s a LOT of work to put in before we even get to the actual music! You’ll thank yourself for it later, since you’ll realize how easy they can come to you now that you’ve already been sitting with the score for a while. Different singers have different opinions on how you should learn the notes. Should you listen to recordings or should you play them out for yourself first? Personally, I say if you need a concept of the style, listen to several recordings once through. That way you don’t get stuck on any one singer’s style, but you have a sense of how the opera runs. Then, learn the rhythms first. Not only will it help line up the words, you’ll already be inclined to add rhythms when you start working notes, so it’ll be helpful if the rhythm is already right. As you learn both notes and rhythms, be sure to isolate parts that give you difficulty rather than barrel through them. It will solve the problem more efficiently. It also helps to look for musical themes. If anything repeats or comes back in a variation, this will speed up your learning process.

#### Work with a coach

Once you feel strong about your notes, go back to those recordings and listen more thoroughly, perhaps even sing along. Be sure to also meet with a coach, preferably one who knows the role or opera well. Now the name of the game is to be ready with the accompaniment, and to have someone spot check anything you may have missed or learned incorrectly. 

## 3. Become the character

Your music is now learned. Your musical director is very happy with you, and you’re all ready for the sitzprobe (the orchestral rehearsal) before you’ve staged a single thing. You’re not done yet though! While composers do an excellent job of creating musical characters, they can only take you so far. Now is the time to dive into your character’s story and make this role your own.

#### Gather as much information as possible

Find any historical, literary, or first-hand information possible about your character. Go back to your translation, and figure out not only what kinds of things your character says, but what other characters say about you. Learn about the time period your character lived in. If you can, read any books or poetry your character may be based on. The beginning stages of my Prince Orlofsky Pinterest board.

#### Fill in the gaps

If there are any gaps in your character’s life, fill them in for yourself. Write out your character’s life story, act like your character at home, or create a Pinterest board filled with images you associate with your character (again, spoilers on my future posts!). The idea is to create a rich backstory.

#### Create a quirk

Remember, your character is a living, breathing person. We have all sorts of natural quirks, twitches, and nuances to how we talk, move, even breathe. Think about what quirks your character might have. For example, when I played Cherubino, I found him to be rather twitchy and nervous, especially around the Countess. Therefore, I often scratched or rubbed my neck in shy nervousness. 

#### Meet with an acting coach or your director

You may have a thousand amazing ideas about your character, but knowledgeable, focused feedback is always helpful. Find out if your director has any particular ideas about your character. This kind of feedback will also help you discover if what you are attempting to portray is actually coming across. If you feel I have missed something important or would like clarification on anything, please comment below or contact me. If you would like any one-on-one help with a role you’re learning, please feel free to [contact me](http://www.kristenseikaly.com/contact/) and I’d either be happy to coach you myself or direct you to someone who can help you out.

[Kristen Seikaly](http://www.kristenseikaly.com/) is a singer, teacher, and blogger. She received her Bachelor’s from the University of Michigan and her Master’s from Westminster Choir College. She currently resides in Philadelphia, PA.
