+++
author = ["authors/greg.md"]
categories = "Review"
date = "2019-04-06T17:11:55+00:00"
disclaimer = ""
image_gallery = []
postamble = "_Kopernikus_ runs through April 13. For details and ticket information, [click here](http://againstthegraintheatre.com/kopernikus-2/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1554572203/media/2019/04/sq190403_ATG_KOPERNIKUS_703.jpg"
primary_image_credit = "Danielle MacMillan as Agni in Kopernikus, Against the Grain Theatre, 2019. Photo: Darryl Block Photography."
related_articles = []
related_companies = ["scene/companies/against-the-grain-theatre.md"]
related_people = ["scene/people/christopher-mokrzewski.md", "scene/people/joel-ivany.md", "scene/people/annemarie-macintosh.md", "scene/people/alain-coulombe.md", "scene/people/dion-mazerolle.md", "scene/people/bruno-roy.md", "scene/people/krisztina-szab.md", "scene/people/danielle-macmillan.md"]
short_description = "The only visibly identifiable ritual is partway through the show, we see Agni become \"assimilated\" and she's changed from her warm golden-orange, mid-century style dress into a dark charcoal version of the clothes in which the other denizens of the afterlife are dressed."
slug = "a-great-spectacle-kopernkius"
title = "A great spectacle: Kopernikus"
youtube_url = ""

+++
Claude Vivier's trip to the afterlife is definitely that. A trip.

Billed as Canada's "Most Famous Unknown Opera", Claude Vivier's _Kopernikus_ is being presented in Toronto by Against the Grain Theatre. Stage directed by the company's Artistic Director Joel Ivany, co-directed and choreographed by Matjash Mrozewski with Musical Direction by Topher Mokrzewski the opera is an examination of what happens after death.

_Kopernikus_ tells the tale of the arrival of the newest resident to the afterlife, a young woman named Agni. Vivier, through the use of a small wind ensemble and a collection singers, shows Agni's afterlife unfolding in front of her.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554572278/media/2019/04/190403_ATG_KOPERNIKUS_356.jpg){{% /md %}}

<figcaption>The Ensemble of Kopernikus, Against the Grain Theatre, 2019. Photo: Darryl Block Photography.</figcaption>

</figure>

Set on a stage full of scaffolding and industrial-looking lighting, the design was very brutalist, from the decor down to the costumes. The cast and ensemble spent the entire production in perpetual motion, giving the scene as a whole an ethereal, viscous quality. The instrumentalists join in with the choreography throughout, which makes _Kopernikus_ feel as though every tiny thing is interconnected and in constant flux.

_Kopernikus_ isn't the kind of opera with sweeping arias and grand love duets. It's the kind of opera where everyone involved needs to be a musician of the highest calibre. At times, the score reminded me of the choral works of R. Murray Schafer I used to sing, that were written roughly around the same time as this work. Complex rhythms, free metres, and dense harmonies and tone clusters date the piece clearly, but the effects that Vivier is exploring here are astounding.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554572341/media/2019/04/190403_ATG_KOPERNIKUS_681.jpg){{% /md %}}

<figcaption>Danielle MacMillan (Agni) and Bruno Roy in Kopernikus, Against the Grain Theatre, 2019. Photo: Darryl Block Photography.</figcaption>

</figure>

It's also not the kind of opera where there is a standout role or performance, because of the difficulty, intricacy, and inter-connectivity of all the music. Even though Agni would be viewed as the protagonist in this Alice-in-Wonderland-meets-Labyrinth kind of story, she sings comparatively little. The singers are all top-notch.

[Danielle MacMillan](/scene/people/danielle-macmillan/) as Agni brings a Verdian, steely, bright mezzo to Vivier's Agni. Mezzo [Krisztina Szabo](/scene/people/krisztina-szabo/), baritone [Dion Mazerolle](/scene/people/dion-mazerolle/), and bass [Alain Coulombe](/scene/people/alain-coulombe/), sang some amazing ensemble work. Singing the coloratura soprano role, [Anne-Marie MacIntosh](/scene/people/anne-marie-macintosh/) gave some great contemporary singing. Singing the baryton-Martin role was [Bruno Roy](/scene/people/bruno-roy/), who had the unenviable task of singing the lion's share of Vivier's created language. The most intriguing singing for me of the evening came from soprano Jonelle Sills. Sills manages to keep her warm, full, elastic tone intact while managing such difficult music.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554572383/media/2019/04/190403_ATG_KOPERNIKUS_865.jpg){{% /md %}}

<figcaption>(clockwise from top) Anisa Tejpar, Anne-Marie MacIntosh, Danielle MacMillan, and Krisztina Szabó in Kopernikus, Against the Grain Theatre, 2019. Photo: Darryl Block Photography.</figcaption>

</figure>

The piece is sung in French. German (okay, I got this) and a language of Viver's own creation - #interrobang. Now, I'm not one to judge on a made-up language, considering how die-hard a fan I am of Tolkien's Middle-Earth Saga, which is chock-full of them. That being said, when singing music of this heightened quality and incredible difficulty, if you're performing in a language that doesn't have the benefit of a translation available to your audience, you need to pull a few more communication tools out of your bag.

I felt at times that there wasn't always a thorough translation running through the singer's mind, which makes it hard to communicate to the listener. I would have been okay with this disconnect if the other players onstage were also lost, but they very clearly understood this language - including the new arrival, Agni - so I felt like I was left out of a large part of the story, since this language creates the bulk of the libretto. Unfortunately, I felt like Roy's performance suffered the most from this disconnect.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554572461/media/2019/04/190403_ATG_KOPERNIKUS_203.jpg){{% /md %}}

<figcaption>Danielle MacMillan (Agni) in Kopernikus, Against the Grain Theatre, 2019. Photo: Darryl Block Photography.</figcaption>

</figure>

To be clear, Vivier also uses bizarre syllables and vocalisations throughout the piece as instrumentation, but he has a very clear delineation between which ones are "orchestral" and which are an actual lexicon with meanings and definitions.

The piece is described as a "Opera-Rituel de Mort" (Ritual Opera for the Dead), which led me to believe that this was a ritual - something that is done over, and over again - yet each element of said ritual seemed to be confused by its own participation. I got the sense that Ivany was exploring an idea that each person's afterlife is unique and they do not arrive there to an afterlife that's fully realized yet. The ritual here is probably the unfolding of a new afterlife in this manner.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554572488/media/2019/04/190403_ATG_KOPERNIKUS_1198.jpg){{% /md %}}

<figcaption>Anisa Tejpar lifted by William Yong, Brad Cherwin in background in Kopernikus, Against the Grain Theatre, 2019. Photo: Darryl Block Photography.</figcaption>

</figure>

The only visibly identifiable ritual is partway through the show, we see Agni become "assimilated" and she's changed from her warm golden-orange, mid-century style dress into a dark charcoal version of the clothes in which the other denizens of the afterlife are dressed. I felt that this happened too soon in the piece. It feels like a moment of resolution for the audience, yet the exploration continues and you realize this happened before the halfway mark of the show. Without the strong definitions needed in Vivier's lexicon, I felt lost as to what we were now exploring if the ritual was over; I feel as though it cost the production some of the audience's trust.

The instrumental ensemble was great, even in a space like Theatre Passe-Muraille, which is not very acoustically kind to classical musicians. There was use of some microphones, yet the mixing seemed quite off. Sometimes it sounded like the singers microphone was in a tin-can (maybe this was a sound design choice?); other times it was mixed down so low we missed extended passages - in particular any extended passages where Roy was using his falsetto. I also felt the difficulty of the music may have robbed some of the singers on stage of the comfort they needed to really deep dive into the exploration of this woman's afterlife.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554572514/media/2019/04/190403_ATG_KOPERNIKUS_948.jpg){{% /md %}}

<figcaption>Krisztina Szabó in Kopernikus, Against the Grain Theatre, 2019. Photo: Darryl Block Photography.</figcaption>

</figure>

ATG's _Kopernikus_ is a very creative night of theatre, and the kind of theatre I love to see and have done a lot during my career. It's a great spectacle - Jason Hand's lighting is breathtaking - and anyone who is a Canadian opera lover has a duty to experience Vivier's work at least once. Mokrzewski conducted Vivier cleanly, steadily, and creatively, reminding us that it's a veritable shame that this piece, which at the point AtG revived it for workshop at their program at the Banff Centre for Arts and Creativity, hadn't been presented in Canada since 2001.

Against the Grain Theatre always promises a theatrical experience unlike any other, and never disappoints. _Kopernikus_ is the next in a growing pedigree of AtG shows that people will be talking about for a while to come. They have a couple more performances for you to catch if you want to be in on that conversation.