+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-12-02T21:04:00-05:00"
lastmod = "2015-12-10T10:43:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1449760789153/2015-12-09---Bijou.jpg.jpg"
publishDate = "2015-12-10T10:35:00-05:00"
short_description = "There are assumptions being made about the phrase, &quot;age appropriate, attractive artists,&quot; the first of which is that it&#039;s synonymous with saying, &quot;no ugly, old singers allowed.&quot; Age appropriate can mean not too old to pass for a character in La bohème (including Benoit, I figure), or not too young to sing Rodolfo right to the end. &quot;Attractive&quot; could mean a lot of things, but Knoxville Opera didn&#039;t specify what; they also didn&#039;t say that they were planning to prioritize physical attractiveness over vocal. "
slug = "knoxville-opera-poor-diction-and-prerogative"
title = "Knoxville Opera, poor diction, and prerogative"
+++

Singers reacted boldly to the [YAP Tracker posting](http://slippedisc.com/2015/12/ugly-old-singers-need-not-apply/) by Knoxville opera last week, which mentioned in their audition call, "Knoxville Opera will cast age appropriate, attractive artists in these roles."

On top of strong responses from the opera-types on social media, there was a flow of new writing about the topic, both formal and rant-like. Voice teacher Dr. Claudia Friedlander wrote an [open letter](http://www.claudiafriedlander.com/the-liberated-voice/brian-selesky.html) to Knoxville Opera's Executive Director and Conductor, Brian Salesky, claiming that his language was "out of step with industry inclusiveness standards," the "objectification of singers based on age and appearance" is damaging to the art form. American bass Morris Robinson [told Slipped Disc](http://slippedisc.com/2015/12/an-american-bass-thunders-at-anti-old-ugly-opera/), "I’ve called (executive director and conductor Brian) Salesky’s office…he hasn’t returned my call. I figured he wouldn’t. This business is full of folks who sit behind shields and throw darts…yet are too afraid to stand behind their own words. I hope that he’s packing up his office...The real shame is that these practices are prevalent yet clandestine and covert. Knoxville just let the secret out...and I hope they pay for it."

Wolf Trap Opera's Kim Witman wrote a [great blog post](http://opera.wolftrap.org/blog/2015/12/04/we-are-all-in-this-together/
) from the point of view of an opera company, where the urge to "pander" and take a cue from for-profit models can be a "a misdirected solution to the larger problem of making sure we can sell tickets, stay in business, eventually thrive, and continue to offer jobs to artists. At the heart of this solution is the desire to break down barriers, get out of our ivory tower bubble, and present what we do as relevant, important, vital and interesting. And singers, you must help us do that. In spades."

Knoxville Opera has since [published an apology](http://slippedisc.com/2015/12/opera-apologises-for-ageist-lookist-casting-sort-of/) for the posting, an apology that I don't think was necessary at all. Their asking for "age appropriate, attractive artists" is one of the few instances I've seen of a company putting in writing what they're really looking for. The folks who cast opera, whether they're aware of it or not, are looking and listening for what a singer offers in addition to his or her instrument; whether or not they explicitly it in an audition posting, factors outside of The Voice come in to play during any casting decision. It appears that the honesty isn't refreshing, however.

There are assumptions being made about the phrase, "age appropriate, attractive artists," the first of which is that it's synonymous with saying, "no ugly, old singers allowed." Age appropriate can mean not too old to pass for a character in *La bohème* (including Benoit, I figure), or not too young to sing Rodolfo right to the end. "Attractive" could mean a lot of things, but Knoxville Opera didn't specify what; they also didn't say that they were planning to prioritize physical attractiveness over vocal. I won't be dense and ignore the implications in the wording of this audition call; it does smell a bit like choosing a hot cast with A- or B+ singing chops. But are there not skilled, stage-worthy opera singers who are also easy on the eyes? Are the complaints in part a result of the bar continuing to be set higher? 

What struck me when I first read about Knoxville Opera's post was that it sounded more like a call for music theatre than opera. Music theatre has the problem-luxury of having a huge pool of auditioning singers from which to cast; as a result, they've coined the 16-bar audition, where it's common to find out ahead of time that singers under 6 ft or without natural red hair will not be considered. That pool of artists is bigger in musical theatre than in opera, but as conservatory and university class sizes continue to grow, so will the number of opera singers who audition for available roles. I don't blame a company like Knoxville Opera for taking the bull by the horns and proactively specifying what they're looking for. 

If a singer doesn't agree with me, that's completely fine. It's a company's own prerogative if they want to explicitly incude stricter guidelines for the auditioning singers, and it's a singer's prerogative to choose not to sing for a company that does that. You won't find a company who professes to value anything other than the voice as a top priority in casting; we've all been to shows with confusing casting decisions, whether or not the company specified standards for age and appearance. 

The main concern, and it's a valid one, is that opera companies will ignore great voices and go with hot stars. Opera companies are in enough peril as it is; if Knoxville Opera really does deserve some backlash from their audition posting, let us not cause it with mob-like negative feedback. If their aesthetic devalues great singing in favour of flat stomachs, the product won't be as engaging, and audiences will notice, and the company will suffer the slap on the wrist in the form of financial woes. But I don’t see a problem with a company imagining an ideal artist for a production, and asking for it.

If Knoxville hadn't added that problematic phrase to their audition call, their standards of age-appropriateness and attractiveness would still exist; they'd just be locked away in the minds of the staff instead of on the Internet. It's already difficult to anticipate what opera bosses are asking for in their casting decisions; couldn't an honest heads-up save plenty of singers some time, money, and self-esteem? 
