+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-03-20T10:57:00+00:00"
lastmod = "2017-03-21T09:22:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490043970715/2017-03-20---Square---170306_1561_meistersinger-BRYN-TERFEL-AS-HANS-SACHS-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg"
primary_image_credit = "Bryn Terfel as Hans Sachs in Die Meistersinger von Nürnberg. Photo by Clive Barda."
publishDate = "2017-03-21T08:52:00+00:00"
related_articles = ["articles/in-review-tannhauser-at-roh.md","articles/in-review-gotterdammerung-at-the-coc.md","articles/talking-with-singers-christine-goerke.md","articles/antoine-wagner-gesamtkunstwerk-in-2018.md","articles/the-flying-dutchman-a-stellar-homecoming-for-hgo.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/bryn-terfel.md","scene/people/gwyn-hughes-jones.md","scene/people/rachel-willis-sorensen.md","scene/people/hanna-hipp.md","scene/people/allan-clayton.md"]
short_description = "Die Meistersinger is a story about tradition, and whether or not it&#039;s good for anything; it exposes how people treat tradesman differently from artists, and the contempt that makers of &quot;high art&quot; can have for the opinions of the general public. Holten&#039;s production seems to shine extra light on the tradition of using women as prizes, even complicating the matter with an Eva Pogner who doesn&#039;t even get the chance to manipulate the system to her own advantage."
slug = "kinder-schafft-neues-die-meistersinger-von-nrnberg"
title = "&quot;Kinder schafft neues&quot;: Die Meistersinger von Nürnberg"
+++

Kasper Holten makes his final mark as Director of Opera at The Royal Opera with his new production of [*Die Meistersinger von Nürnberg*](http://www.roh.org.uk/productions/die-meistersinger-von-nurnberg-by-kasper-holten). Wagner's comedy premiered three years after *Tristan und Isolde*, in the middle of the respite he took from writing his *Ring Cycle*. *Die Meistersinger* is on the list of operas for which Wagner is composer and librettist; it's a habit that's particularly interesting, since it creates both a rare level of cohesion between music and text, and an extremely clear, intimate look at how Wagner viewed the world and his art.

It was our first time hearing *Die Meistersinger*, and it felt a bit like a rite of passage to make it through the lengthy - oftentimes exhaustively so - opera. Music Director Antonio Pappano led the Orchestra of the Royal Opera House through a rich, thrilling score; Pappano mercifully kept Wagner's music moving, pausing for the moments of comedy and beauty alike.

*Die Meistersinger* is a story about tradition, and whether or not it's good for anything; it exposes how people treat tradesman differently from artists, and the contempt that makers of "high art" can have for the opinions of the general public. Holten's production seems to shine extra light on the tradition of using women as prizes, even complicating the matter with an Eva Pogner who doesn't even get the chance to manipulate the system to her own advantage.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490042872038/2017-03-20---170306_1664_meistersinger-BRYN-TERFEL-AS-HANS-SACHS-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>Bryn Terfel as Hans Sachs in *Die Meistersinger von Nürnberg*, ROH, 2017. Photo by Clive Barda.</figcaption>
</figure>

Holten's sets are looming, if not beautiful, but it seems an ongoing mystery to pinpoint exactly where and when the action unfolds. Cell phones and rock-concert T-shirts make it a contemporary setting, and the anachronistic, stuffy suits of the Master singers certainly prove them an old-guard kind of society, valuing what was rather than what could be. Amid a problematic combination of literal spaces which become vaguely symbolic - and require more suspended disbelief than the story itself - it is the thrilling cast of *Die Meistersinger* which gives the production life. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490042889976/2017-03-20---170306_1546_meistersinger-BRYN-TERFEL-AS-HANS-SACHS-RACHEL-WILLIS-S%C3%98RENSEN-AS-EVA-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>Bryn Terfal as Hans Sachs and Rachel Willis-Sørensen as Eva in *Die Meistersinger von Nürnberg*, ROH, 2017. Photo by Clive Barda.</figcaption>
</figure>

[Rachel Willis-Sørensen](/scene/people/rachel-willis-sorensen/) is a flirty, human Eva. She sings with a lovely, clear ring that's full of personality, like a teenager who knows more than one expects. Eva seems a product of her strong father, perfectly embodied in the grand size of volume of [Stephen Milling](/scene/people/stephen-milling/). Willis-Sørensen has real chemistry with [Gwyn Hughs Jones](/scene/people/gwyn-hughes-jones/) as Walther von Stolzing, the rebel singer who inserts himself into the rule-laden world of Master singers in order to have a chance at winning Eva's hand in marriage. The pair seem real, a breath of fresh air among tradition for tradition's sake. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490042917752/2017-03-20---170308_1686_meistersinger-WILLIAM-SPAULDING-AS-CHORUS-DIRECTOR-RACHEL-WILLIS-S%C3%98RENSEN-AS-EVA-BRYN-TERFEL-AS-HANS-SACHS-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>William Spaulding as Chorus Director, Rachel Willis-Sørensen as Eva, and Bryn Terfel as Hans Sachs in *Die Meistersinger von Nürnberg*, ROH, 2017. Photo by Clive Barda.</figcaption>
</figure>

Eva and Walther have a great supporter in [Bryn Terfel](/scene/people/bryn-terfel/) as Hans Sachs, whose large, cavalier posture seems a perfect bridge between respect for the old and an affinity for forward-thinking. Though he certainly sings with that side-mouthed brightness that can make Terfel sound the same in nearly every role he plays, the pleasing honesty in his sound suits Sachs beautifully. He is a companion to Walther, and a charming antagoniser to Beckmesser, who clearly takes himself much too seriously. Johannes Martin Kränzle earns everything from laughs to pity as the would-be contender for Eva's hand; his singing, be it "bad" or "good", was wildly impressive in execution; he created a Beckmesser who shows just how little affect comes from overthought art.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490042936872/2017-03-20---170306_1481_meistersinger-HANNA-HIPP-AS-MAGDALENE-ALLAN-CLAYTON-AS-DAVID-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>Hanna Hipp as Magdalene and Allan Clayton as David in *Die Meistersinger von Nürnberg*, ROH, 2017. Photo by Clive Barda.</figcaption>
</figure>

A total highlight was [Allan Clayton](/scene/people/allan-clayton/) as Sachs' apprentice in shoemaking and singing, David. He captured that well-known trope of the artist with a day job; he takes seriously his work as a cobbler, and has tangible respect for his pursuit of singing. Wagner writes some of his most imaginative music for David, and Clayton had skilful fun with an enormous spectrum of vocal colours. He sounded the best we've heard him yet. He was a lovely other half to [Hanna Hipp](/scene/people/hanna-hipp/)'s Magdalene, whose strong mezzo is a lovely surprise from the small-statured singer. They too share a real relationship, full of humour and love.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490042961062/2017-03-20---170308_2103_meistersinger-BRYN-TERFEL-AS-HANS-SACHS-JOHANNES-MARTIN-KRANZLE-AS-SIXTUS-BECKMESSER-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>Bryn Terfel as Hans Sachs and Johannes Martin-Kränzle as Sixtus Beckmesser in *Die Meistersinger von Nürnberg*, ROH, 2017. Photo by Clive Barda.</figcaption>
</figure>

Holten no doubt missed several opportunities to bring out more humour in Wagner's comedy. Though the piece itself seems more of a light story than a real comedy - it's hard to be funny when one is long-winded and pedantic - moments like Beckmesser's silent, solo scene in Act III seemed to come with music that begged for slapstick. There's something disappointing about the end, stepping back from a pure tale of a rebel who injects a much-needed dose of change in a tired society. 

It's a little bit like the end of *Grease*, where one hopes that Danny tells Sandy he liked her better before the catsuit. Wagner certainly has a point to his everything-in-moderation approach to tradition and change, yet for this 21st-century, first-time watcher of *Die Meistersinger*, the concept of "Kinder schafft neues" was overshadowed by a bit of preaching.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490043002012/2017-03-20---170308_2514_meistersinger-GWYN-HUGHES-JONES-AS-WALTHER-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>Gwen Hughes Johnes as Walther von Stolzing in *Die Meistersinger von Nürnberg*, ROH, 2017. Photo by Clive Barda.</figcaption>
</figure>

>Die Meistersinger von Nürnberg runs at the Royal Opera House until March 31. For details and ticket information, [click here.](http://www.roh.org.uk/productions/die-meistersinger-von-nurnberg-by-kasper-holten)
