+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-10-25T11:20:00+01:00"
lastmod = "2016-10-26T09:33:00+01:00"
preamble = "[Shadwell Opera](/scene/companies/shadwell-opera/) is gearing up for its creative double-bill, pairing together Schoenberg's *Erwartung* and Mark-Anthony Turnage's *Twice Through the Heart* on [November 4 and 5 at Hackney Showroom](http://www.hackneyshowroom.com/shadwellopera/). The production is directed by Shadwell Opera Artistic Director Jack Furness and Associate Director Celine Lowenthal, and conducted by Musical Director Finnegan Downie Dear; soprano [Madeleine Pierard](http://www.madeleinepierard.com/) and mezzo-soprano [Kate Howden](http://www.katehowden.co.uk/) perform.\n\n\"I can't think of a more challenging, extraordinary pairing of pieces, both of them filled with all of the crazy texture of the modern world,\" says Artistic Director Jack Furness. \"This is more than just a show for Shadwell Opera - it is a statement of company identity.\"\n\nWe spoke with Furness about Shadwell Opera's *Erwartung* and *Twice Through the Heart*, and what gets him excited about presenting them together.\n\nFor more details and ticket information, [click here.](http://www.hackneyshowroom.com/shadwellopera/)"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477390985124/2016-10-25---8-Songs-for-a-Mad-King---Nick-Rutter.jpg.jpg"
primary_image_credit = "Nicholas Morris performing \"8 Songs for a Mad King\", Shadwell Opera, 2016. Photo by Nick Rutter."
publishDate = "2016-10-26T09:29:00+01:00"
related_articles = ["articles/in-review-bluebeards-castle-erwartung.md","articles/in-review-death-desire.md","articles/ghost-stories-true-stories-the-lighthouse.md","articles/i-opera-run-by-the-cool-kids.md"]
related_companies = ["scene/companies/shadwell-opera.md"]
related_people = ["scene/people/kate-howden.md"]
short_description = "&quot;I think the honesty and compassion of these pieces can have a saline, stripping effect on boring ideas about how the mind works. Somehow the psychology of a single human being is unfathomably more complex than we pretend from day to day. Without the music, it would not be possible to explore those depths in the same way.&quot;"
slug = "killer-women-shadwell-operas-doublebill"
title = "Killer women: Shadwell Opera&#039;s double-bill"
+++

## Where did the idea come from of pairing these two one-acts together?
 
[Music Director] Finnegan Downie Dear and I have talked about doing erwartung for a long time - it's a real challenge, musically, dramatically, vocally. There's something hugely exciting about that. Then we heard the Turnage and it was so clearly a perfect pairing. Here are two monodramas, separated by ninety odd years, that could have been commissioned as a double-bill in the first place! Often, though, it's just a case of instinct - Finn and I both listen to something and have these moments of going "we have to do this piece." In this case, as we,ve got to know the pieces more and more, the double-bill has seemed a better and better idea!
 
## What sort of story do *Erwartung* and *Twice Through the Heart* tell, collectively?
 
As we've worked on this project it's become clearer that the beautiful thing about the pieces is that they don't so much tell a story as have a conversation with each other. 

Both in their way are concerned with the way that these two women deal with silent male authority figures from their past. Both pieces are textured, because of their genesis stories, with the ways in which institutions such as prisons or asylums have treated - or do treat - women. The fact that the librettist in both cases was a woman [(Marie Pappenheim for *Erwartung* and Jackie Kay for *Twice Through the Heart*)] and probably in both cases was working from real-life source material is fascinating. 

The thing is, that although both of the women are killers, one always feels on their side. I'd have expected that for the Turnage but it's really surprised me about *Erwartung*. Both pieces also seem to be very deep considerations of memory and how it imprisons us - how the things we have experienced mark us indelibly. Memory is both pieces is an active, visual, present, sensory experience rather than something safe and containable. In these pieces, memory is a terrifying eruption into the fabric of the present. But both pieces are deeply compassionate in their representation of that.

It's also good to think about how the two are different. The music in *Erwartung* is constantly developing but on an almost bar-by-bar basis. Everything is suggestion, allusion, mystery. The Turnage has this clarity to it that makes a great contrast. Despite the similarities there are very great differences in terms of the conception of how to represent a character, dramatic pace, language, etc. You can, perhaps, find some trace of how attitudes have changed about everything over the last one hundred years.

## How does this production fit in with Shadwell Opera's mission?
 
We want to make opera that really thrums with the texture of the world as it is today. We're interested in telling stories that people today can relate to. And both of these pieces, in complementary ways, satisfy that need. As long as we're doing that, we feel like we're on track.

We also have this mission to reintroduce recently written pieces to try to expand people's idea of what the standard repertoire should be, and a great way to do this is to contextualise a newer piece with something older.

It's really exciting to have such an unbelievable pair of singers to work with. Both Madeleine Pierard and Kate Howden are fantastic singers and it's such a pleasure to be able to have them both doing these roles for the first time.
 
## What do you hope audiences will take away from the double-bill?
 
I think the honesty and compassion of these pieces can have a saline, stripping effect on boring ideas about how the mind works. Somehow the psychology of a single human being is unfathomably more complex than we pretend from day to day. Without the music, it would not be possible to explore those depths in the same way. I hope people take the example of the fearlessness of erwartung and allow the music to bury down deep into them.

I hope they won’t go away saying "Oh, maybe opera is ok." I hope they'll go away saying "I love going to the theatre."


<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477391544790/2016-10-25---Shadwell-Opera-poster.jpg.jpg)
</figure>
