+++
author = ["authors/darren-saady.md"]
categories = "Op-ed"
date = "2017-09-14T09:42:00-04:00"
lastmod = "2017-09-14T22:16:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505397395425/2017-09-14---Thread.jpg.jpg"
publishDate = "2017-09-14T21:46:00-04:00"
related_articles = ["articles/vibrato-all-the-reasons-why.md","articles/4-tips-for-when-there-are-too-many-notes.md"]
short_description = "The body only does what the mind tells it and allows it to do. Intense, almost loving attention to every single note can help realize a tricky passage like this. When it comes to runs and coloratura in general, this approach is useful because it can help give fast singing a real clarity, accuracy and a sense that there is plenty of time to sing all the notes and for them to be heard. "
slug = "keeping-the-thread-momenttomoment-awareness-in-singing"
title = "Keeping the thread: moment-to-moment awareness in singing"
+++

One of the most important elements of music making, and one that I find is somewhat undervalued in the general conversation around performance, is the role played by our awareness during singing; that is, where our attention lies as performers while we are playing or singing. My own observations with singers I have worked with have led me to the firm conclusion that a performance is greatly improved when our attention is fully and intensely involved on a note-to-note basis in the music. This includes the breath, too, since as well as being a physical necessity, breathing is very much involved in the drama of the music. 

A wonderful musician and coach, Richard Hetherington, first explained this awareness to me as, "do not allow a single note to pass by without making music with it". He meant that singers should allow each note to speak and to be expressive in some way, no matter how fast or unimportant it appears to be. This does not mean changing what’s in the score or the natural shaping of the phrase; I am simply talking about not allowing any note to fall under the radar, but rather allowing each note to be expressed fully by giving it our full attention. What tends to happen when we are continuously alert in this way, is that we realize just how much time there is to allow each and every note to speak, and for the ear to register it.

### Making the lives of singers easier

I like to see this awareness too as being coupled with a strong desire to express oneself through the music. This can really assist the release of any tension held in the body, and allow the natural energy of communication to dissolve some of the technical barriers singers sometimes come up against. Letting the sheer joy and involvement in telling the story shine seems to allow the body’s reflexes to more naturally function, because the singer is no longer so conscious of "performing" for an audience. Therefore I think this can really help to bring about the natural “release” that is so important for singing. 

This approach has a lot of implications on a practical technical level. As a vocal coach I have noticed that short notes can sometimes pass by, both in recitatives and arias, without being fully sounded. This could be for a number of reasons: because the note falls on a short word which is therefore interpreted as "unimportant", because there is perhaps a high note or difficult passage coming up which draws the attention before the earlier note has been properly dealt with. Singers know well that if an earlier note hasn't been given the attention (i.e. the "spin") it needs, certainly in lyrical music, it becomes that much harder to successfully negotiate the later part of the phrase. This sense of constant presence can also help in particular in preventing the energy to slip as the music heads downwards in pitch, as well as other technical issues too.

### When it's hard to do, you need it more

One passage where I have found this approach useful is Donna Elvira's coloratura at the end of "Mi tradì nell'alma ingrata" in *Don Giovanni*. It is composed of some tricky patterns and intervals and throws up some tuning challenges for the singer:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505439819105/2017-09-15---Mi-tradi.jpg.jpg)
<figcaption>Musical example, from "Mi tradì nell'alma ingrata" (*Don Giovanni*).</figcaption>
</figure>

The body only does what the mind tells it and allows it to do. Intense, almost loving attention to every single note can help realize a tricky passage like this. When it comes to runs and coloratura in general, this approach is useful because it can help give fast singing a real clarity, accuracy and a sense that there is plenty of time to sing all the notes and for them to be heard. The difficulties inherent in faster singing can often, unconsciously, be exacerbated by rushing – the worry that there isn’t quite enough time to sing every note clearly. The mind tells us that the music has to go "fast" and this may sometimes lead to hectic singing and an unclear sound. The body tenses and contracts, and the mind abandons the present moment, looking further ahead in order to deal with the challenges that lie there.

Also, since it is important, I feel, to think of coloratura in terms of long, outward-flowing breaths, awareness of the individual notes helps to gain the clarity and articulation that coloratura needs. Some singers may find it challenging to marry the ideas of a long phrase with the precision required in fast singing. I think that the mental approach I'm discussing here can very much help with precise, well- articulated singing.

In the first instance it takes a certain degree of courage to be intensely aware in the present moment rather than to avoid it. But the great asset of attending to every note, is that it tends to give a sense of enough time, space and structure even in the fastest coloratura, where even split seconds can be immensely valuable. It also allows the body to respond in a much more natural way guided by this calmer, yet engaged attitude of mind. We then allow the body to respond to the intensity of this engagement with an appropriate level of physical support.

### Pay attention, feel free

Critically, this intense awareness also works against that great enemy of singers - and instrumentalists - the judging mind, which offers a running and rarely favourable commentary on how things are going as we make our way through a piece. A great advantage of the attitude advocated here, is that it doesn't allow our minds to go off into commentary mode, but supports us remaining available to the music as it unfolds, committed and alert but not unhelpfully tense. We become much more involved in the drama of the music and the story we are telling, rather than in pleasing others, which is an important aspect of successful performance. 

This is an approach that I would encourage all singers and instrumentalists to explore.  It can open the door to an endless possibility of ever more engagement with the music, expression and a feeling of technical stability. And what's more, it can be fun!
