+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-02-06T17:29:45+00:00"
disclaimer = ""
image_gallery = []
postamble = "Katya Kabanova runs at The Royal Opera through 26 February. For details, [click here](https://www.roh.org.uk/productions/katya-kabanova-by-richard-jones)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1549474644/media/2019/02/sq1195BickleyasKabanovaMajeskiasKatyStaplesasTichonROH2019photographbyCliveBarda.jpg"
primary_image_credit = "Susan Bickley (Kabanova), Amanda Majeski (Kát'a), and Andrew Staples as Tichon in Kát'a Kabanova, ROH, 2019. Photo: Clive Barda."
related_articles = ["articles/constructive-frustration-from-roh-s-queen-of-spades.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/amanda-majeski.md"]
short_description = "It is a piece that is so clearly a microcosm of a very specific place and time. Director Richard Jones has chosen to set it in the mid-60s in a repressive, religious Russian community where a life of domesticity, is a woman's only option."
slug = "majeski-makes-sensitive-subtle-roh-debut-in-kata-kabanova"
title = "Majeski makes sensitive, subtle ROH debut in Kát'a Kabanova"
youtube_url = ""

+++
This production of Janáček’s [_Kát'a Kabanová_](https://www.roh.org.uk/productions/katya-kabanova-by-richard-jones) (1921) is the second in a cycle of four works the Royal Opera will be staging over the next two seasons. Last season, his final opera _From the House of the Dead_ (1930) was premiered in a new production directed by Krzysztof Warlikowski.

> It was a privilege to witness a piece of art that was deeply moving and poignant, that spoke volumes in its intelligibility.

_Kát'a_ is a striking work. Translated into Czech from the original Russian Ostrovsky play _The Storm_ and adapted for the opera, it tells the story of a young woman who is unhappily married. Abused by her husband, berated by her cruel mother-in-law, and against her better judgement, she engages in an ill-fated love affair. Unable to bare the shame, she admits her lapse in judgement to her husband. Seeing no way out, she drowns herself in the river Volga.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549474580/media/2019/02/1015AndrewStaplesasTichonandAmandaMajeskiasKatyaROH2019photographbyCliveBarda.jpg){{% /md %}}

<figcaption>Andrew Staples as Tichon and Amanda Majeski as Kát'a in Kát'a Kabanova, ROH, 2019. Photo: Clive Barda. </figcaption>

</figure>

It is a piece that is so clearly a microcosm of a very specific place and time. Director Richard Jones has chosen to set it in the mid-60s in a repressive, religious Russian community where a life of domesticity, is a woman's only option. Amidst all of this, the river Volga weaves its way into the music and into the heart of its central character, calling to her and creating a watery metaphor that winds its way through the entire piece.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549474627/media/2019/02/1170PavelCernochasBorisandAmandaMajeskiasKatyaROH2019photographbyCliveBarda.jpg){{% /md %}}

<figcaption>Pavel Cernoch as Boris and Amanda Majeski as Kát'a in Kát'a Kabanova, ROH, 2019. Photo: Clive Barda. </figcaption>

</figure>

The weather, and the natural world both play important roles in this opera. The heat and the impending storm reflect the characters emotional landscapes. It is a common theme, Particularly in film, for a heat-wave to cause an outbreak of sinful acts. This heavy, languid weather was beautifully depicted in Antony McDonald's simple stage designs which employed bare wooden walls, and muted colour schemes. Paired with lighting designer Lucy Carter's yellow, stark, and often unforgiving lighting choices, a picture of unbearable, repressive heat is painted. It is only when this heat is broken by the storm in the beginning of the third act that the characters also begin to break. Kát'a admits to her affair, making the decision to free herself from the prison of her marriage though she knows it will be her downfall. With the storm, she is changed, and all the while, the river is calling to her in the muted voices of the chorus that only she seems to be able to hear.

> Majeski gave a fully integrated, and detail sensitive performance that touched on so many of the subtleties of her character.

Kát'a is a woman torn in two. She wants to be a good wife and daughter, but she is unhappy with her domestic lot and punishes herself for desiring more. She is portrayed in stark contrast to Varvara, a young ward in the Kabanov' household, portrayed by soprano [Emily Edmonds](/spotlight-on-emily-edmonds/). Varvara is young and carefree; choosing not to conform to the norms of society, she regularly sneaks out to the garden in the middle of the night to meet with her lover, Váňa Kudrjaš. And in a world where the custom is to cover up, she roams barefoot and bare-shouldered. In these two characters censorship and domesticity are contrasted with self-expression and sexual liberation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549474728/media/2019/02/1431AmandaMajeskiasKatyaSusanBickleyasKabanovaROH2019photographbyCliveBarda.jpg){{% /md %}}

<figcaption>Amanda Majeski as Kát'a and Susan Bickley as Kabanova in Kát'a Kabanova, ROH, 2019. Photo: Clive Barda. </figcaption>

</figure>

The role of Kát’a was performed by American soprano [Amanda Majeski](/spotlight-on-amanda-majeski/) who debuts both in the role and at Royal Opera this season. Majeski gave a fully integrated, and detail sensitive performance that touched on so many of the subtleties of her character. Janáček quite noticeably reserved some of the most beautiful music in the opera for his title character which I think had to do primarily with the fact that Kát'a has the most interesting, and unusual things to say of anyone on stage. She is pensive and ethereal, her thoughts growing stranger and more deranged as the story progresses. Kát'a is the personification of the water that carries such weight in this piece and this is reflected in her music. Janáček has created a backdrop of sound for her that bubbles and froths with a multitude of colours. There is a reverence to everything she sings that is held in direct contrast to the vocal lines of Kabanicha, her mother-in-law, who sings in a stunted, comical recitative.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549474812/media/2019/02/1472ProductionshotKatyaKabanovaROH2019photographbyCliveBarda.jpg){{% /md %}}

<figcaption>Production image from Kát'a Kabanova, ROH, 2019. Photo: Clive Barda. </figcaption>

</figure>

It is a masterful score, so expressive in its evocative nature and intricate subtleties. It is tragic but in a simple, understated way, a world away from the works that were being composed in Italy by Puccini, Leoncavallo, and Mascagni around the same time. At its core, it is a story about a tragic outsider, a nod to the mournful heroines of Russian literature as well as a reflection of Janáček’s own experience with alienation. In a society that is becoming increasingly polarized, perhaps this story has never been more relevant. In any case, it was a privilege to witness a piece of art that was deeply moving and poignant, that spoke volumes in its intelligibility.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549474900/media/2019/02/1243AmandaMajeskiasKatyaKabanovaROH2019photographbyCliveBarda.jpg){{% /md %}}

<figcaption>Amanda Majeski as Kát'a Kabanova in Kátya Kabanova, ROH, 2019. Photo: Clive Barda. </figcaption>

</figure>