+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = 2019-11-02T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Opera Omaha's production of [_Madama Butterfly_](https://www.operaomaha.org/season-tickets/current-season/2020/madama-butterfly) runs through November 3."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1572742481/media/2019/11/sqKanekoMB15_d5lpzx.jpg"
primary_image_credit = "Opera Omaha's production of Madama Butterfly, 2019. Photo: Thomas Grady."
related_articles = ["articles/when-art-is-not-enough-opera-activism.md", "articles/in-review-madam-butterfly-at-eno.md"]
related_companies = ["scene/companies/opera-omaha.md"]
related_people = []
short_description = "\"Son's entire demeanor shifted in this scene from distraught mess to calm intensity. The effect was quite jarring, ending the opera with a truly tragic shock.\""
slug = "karah-son-a-true-jewel-of-opera-omahas-madama-butterfly"
title = "Karah Son a \"true jewel\" of Opera Omaha's Madama Butterfly"
youtube_url = ""

+++
Polka dots and Puccini! Opera Omaha's production of [_Madama Butterfly_](https://www.operaomaha.org/season-tickets/current-season/2020/madama-butterfly) is an intriguing marriage of modern art and musical drama. This opera classic intermingled with a kaleidoscope of colors and patterns to create a unique experience that celebrates collaboration between the visual and musical arts.

This production is a revival of Opera Omaha's 2006 collaboration with Japanese ceramic artist and Omaha resident, Jun Kaneko. This was Kaneko's first foray into the art form, and his signature style was splashed across the stage from start to finish. The set design was minimalist but featured an overwhelming amount of color. At times the spiral shaped setting felt sterile and unwelcoming, and at other times, the use of multiple projections and colored streamers transformed the space into a chaotic cacophony.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572743117/media/2019/11/KanekoMB02_kqrxpf.jpg){{% /md %}}

<figcaption>Opera Omaha's production of Madama Butterfly, 2019. Photo: Thomas Grady.</figcaption>

</figure>

Kaneko employed a distinct shift in color palate between the happier first act and the more tragic final acts. The wedding scene is full of vibrant hues, but as soon as Pinkerton abandons Cio-Cio-San, darker muted tones take over. This change was most evident in the costumes which were a mish-mash of color blocks and patterns, often asymmetrical like the set design.

> It was their offstage singing that had the greatest impact, a distant and atmospheric backdrop for Cio-Cio-San's anguish.

Kaneko's artistic style made for some striking vignettes, but Leslie Swackhamer's staging came across as awkward and unsettled. I wanted the physical movements to match the bold visual choices, but often the characters seemed unsure or aimless when they should be unapologetically embracing the drama. The use of square headed, faceless supernumeraries to move props around the stage was perplexing and drew attention away from the main action of the opera. I felt like their presence did little for the production, superfluous at best.

In spite of the strange choices, there were certain scenes that struck the audience to their core. Cio-Cio-San's death had the strongest impact, her slumped body highlighted beneath a bleeding red homage to the Japanese flag. These moments of musical and artistic unification are what opera is all about.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572743153/media/2019/11/KanekoMB03_q8uxvd.jpg){{% /md %}}

<figcaption>Opera Omaha's production of Madama Butterfly, 2019. Photo: Thomas Grady.</figcaption>

</figure>

The orchestra, under the direction of Joseph Rescigno, filled the theater with Puccini's lush musical atmosphere, but the tempos lacked much of the push and pull that gives his music its emotional heft. I'm not sure if some of the timing issues were related to the use of projections and having to hit certain cues, but at times, it felt like the singers and the orchestra could not agree on the subtle nuances. Despite this, Puccini's orchestration wielded its dramatic power when it counted the most.

The chorus in this opera is minimal and spends much of their performance singing from offstage. Chorus Master Sean Kelly's troupe of singers sang admirably, alternating between the shimmering tones and the sharper shocking scenes. My only disappointment was that their volume came across as perpetually softer than desired despite the healthy number of chorus members onstage. Oddly it was their offstage singing that had the greatest impact, a distant and atmospheric backdrop for Cio-Cio-San's anguish.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572743174/media/2019/11/KanekoMB07_xmbbxi.jpg){{% /md %}}

<figcaption>Opera Omaha's production of Madama Butterfly, 2019. Photo: Thomas Grady.</figcaption>

</figure>

The sound balance with the orchestra was also an issue for most of the male characters in the opera, an obstacle which made the opening scene difficult to enjoy. Robin Yujoong Kim played the role of Goro, the marriage broker. Kim's performance came across as energetic but scattered, and his voice was the most frequently drowned out by the orchestra which was a shame. Hidenori Inoue made an imposing vocal presence in the role of the Bonze, but his performance was undermined by the strange choreography required of him. He kept squatting and stomping during his confrontation with Cio-Cio-San which was distracting rather than intimidating. I wanted him to just stand still and look menacing.

> Pinkerton is egotistical and confident, and even when he finds himself giddy about his new plaything wife, he should maintain a predator's focus.

Luis Ledesma portrayed Sharpless, the Consul and voice of reason in this opera. Ledesma's performance came across as fairly bland, like an awkward father figure that doesn't know how to interact with young folk. He has the vocal potential, but I wanted more emotion from him, especially when he has to be the bearer of bad news. Sharpless is witnessing the heartbreak of an innocent woman, and we need to see the impact this has on him, especially when he calls Pinkerton out on his bullshit.

Abby Roth was a stern but kind presence as Pinkerton's American wife, Kate. Her rich mezzo tone was ominous and calm in the face of Suzuki's anguish. I can only hope that Kate wises up, adopts the child, and divorces Pinkerton's ass as soon as she can.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572743191/media/2019/11/KanekoMB09_j7a2jq.jpg){{% /md %}}

<figcaption>Opera Omaha's production of Madama Butterfly, 2019. Photo: Thomas Grady.</figcaption>

</figure>

Kristen Choi was charming and sympathetic in the role of Suzuki. The mezzo's voice cut through the orchestra even in her lower registers. Choi brought a touch of candor to the part, and the chemistry between Suzuki and Cio-Cio-San felt natural and refreshing. Their playful rendition of the flower duet was one of the highlights of the night, a much needed moment of happiness in an otherwise tragic story.

> Son brought believable growth to Cio-Cio-San's story, evolving from bashful bride to devastated mother.

Alok Kumar sang the role of Pinkerton, the romantic lead and villain of this opera. Kumar's voice was well suited for Puccini, but the tenor lacked the vocal and physical swagger needed for Pinkerton. He flitted around the stage with a restless energy that lacked purpose. Pinkerton is egotistical and confident, and even when he finds himself giddy about his new plaything wife, he should maintain a predator's focus. Much of Kumar's dramatic murkiness was the result of staging choices, especially in the love duet with Cio-Cio-San. The chemistry in that scene was thrown off by unnecessary movement, and Pinkerton seemed like he was along for the ride when he should the driving force in the seduction.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572743229/media/2019/11/KanekoMB10_esmsga.jpg){{% /md %}}

<figcaption>Opera Omaha's production of Madama Butterfly, 2019. Photo: Thomas Grady.</figcaption>

</figure>

Kumar showed his true potential in the role when Pinkerton returned in the final act. His expressions of remorse were some of his most vocally compelling moments, and even though I hate Pinkerton as a character, he tugged my heartstrings for a few seconds. Puccini tries to trick us into liking the tenor with his beautiful music, but when you listen to the words, it is cringeworthy and vile at best. (I even heard a lady hissing at Pinkerton at one point in the opera.) Cio-Cio-San deserved better!

> The effect was quite jarring, ending the opera with a truly tragic shock.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572743253/media/2019/11/KanekoMB12_tvfemu.jpg){{% /md %}}

<figcaption>Opera Omaha's production of Madama Butterfly, 2019. Photo: Thomas Grady.</figcaption>

</figure>

The true jewel of this opera was rightfully Karah Son in the role Cio-Cio-San. As soon as Son entered the stage and hit her first velvety high note it was easy to see why Pinkerton is so enamoured with his new bride. Cio-Cio-San is one of Son's signature roles, and it shows in her polished embodiment of the character. The soprano's liquid legato was at times inconsistent in her lower registers, but the glorious sustained notes in combination with the swelling orchestra hit me in the feels hard. 

Son brought believable growth to Cio-Cio-San's story, evolving from bashful bride to devastated mother. Her most powerful dramatic moment of the opera occured when Cio-Cio-San resolves to kill herself. Son's entire demeanor shifted in this scene from distraught mess to calm intensity. The effect was quite jarring, ending the opera with a truly tragic shock.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572743307/media/2019/11/KanekoMB16_zbbes5.jpg){{% /md %}}

<figcaption>Opera Omaha's production of Madama Butterfly, 2019. Photo: Thomas Grady.</figcaption>

</figure>

Opera Omaha's revival of this collaborative production is a testament to embracing other art forms. Kaneko's designs might be considered a departure from traditional and beloved tropes, but his visuals are fiercely and unapologetically unique. Often opera companies are content to stick to the familiar, but taking risks and exploring new interpretations is vital to continued growth. The marriage between modern art and opera may seem as ill matched as Pinkerton and Cio-Cio-San, but the end result is a bold partnership based on powerful emotions.