+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-08-31T14:50:00-04:00"
lastmod = "2017-09-09T11:11:00-04:00"
preamble = "Ottawa-based singer [Justin Ralph](https://www.justinralph.com/about) has roots in opera and operetta; with companies like [Opera Five](/scene/companies/opera-five/), [Toronto Operetta Theatre](/scene/companies/toronto-operetta-theatre/) and [Opera In Concert](/scene/companies/opera-in-concert/), Ralph has sung roles like Ferrando (*Così fan tutte*), Jupiter (*Semele*), Nanki-Poo (*The Mikado*), Frederick (*The Pirates of Penzance*) and Eisenstein (*Die Fledermaus*).\n\nHis love of the classical stage is balanced by a connection to country and folk music, with Schubert and Strauss as much inspiring figures as Hank Williams and Johnny Cash. Ralph has released his first folk/country EP, [*By the Old Railroad*](https://www.justinralph.com/music), where he shows off impressive versatility with his voice, and proves the universal nature of storytelling through music.\n\nHe chats with us about his surprising influences, and making a nod to art song with his debut album."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1504205536628/2017-08-31---justinheader3.jpg.jpg"
publishDate = "2017-09-09T11:11:00-04:00"
short_description = "&quot;Whether you&#039;re singing opera, art song, folk music, or even country, you&#039;re unfolding a story for the audience and transporting them to a different time and place than the present. Schubert&#039;s traveller in Winterreise and Hank Williams&#039; lonesome soul in &#039;Lost Highway&#039; have a lot in common despite the centuries between them, and immersing myself in either character brings me a lot of satisfaction.&quot;"
slug = "justin-ralph-it-all-comes-down-to-storytelling"
title = "Justin Ralph: &quot;It all comes down to storytelling.&quot;"
+++

## What do you find are some surprising similarities between singing in an operatic context, and recording a folk/country EP?

On the surface, it's kind of crazy how different the styles are - you probably couldn't get two genres that are more opposite from each other. Going into the studio, I was actually nervous that I was going to have a lot of work to do to pull back on my classical training, and not sound too "opera-y" on the tracks. Once I was recording, I was surprised at how much of an asset the classical background was. 

A couple big things stand out in my mind. One is endurance. When you're recording, you often hit the vocals at least twice so the producer has some choice when it comes to mixing the final track. Often it ends up being more than twice. We had sessions where I was singing for a few hours at a time, and having solid vocal training helped me stay fresh and still be able to speak the next day. 

The second thing that transfers really well is the intense attention to musical detail. Folk and country music sound really simple, but once we had the songs in the studio, we made a lot of choices about rhythm, melody, phrasing, and even very specific vocal decisions like where to use vibrato and where not to. On this EP we went with a more sparse arrangement to give the songs lots of space, and that means all these musical choices become even more important. 

## Why were you drawn to these styles of music, which seem quite different from each other?

I think for me it all comes down to storytelling. Whether you're singing opera, art song, folk music, or even country, you're unfolding a story for the audience and transporting them to a different time and place than the present. Schubert's traveller in *Winterreise* and Hank Williams' lonesome soul in "Lost Highway" have a lot in common despite the centuries between them, and immersing myself in either character brings me a lot of satisfaction.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1504205593261/2017-08-31---justin_ralph_album_cover.jpg.jpg)
</figure>

## How has your album been inspired by art song cycles?

For *By the Old Railroad*, I wanted to link each song conceptually, and have a strong theme throughout the six pieces. I started to focus in on an old railroad track by the house we live in (the one that now lives on the album cover), and decided that each song should somehow link to the location. I wanted it to seem like each song could actually have been written about this area, by the different souls that have passed through it. And finally, I wanted there to be a sense of journey from the first track to the last. I wanted to start the EP with a literal beginning, the birth of my son, "Beckett", through to the kind of dark heart of the EP, "In the Pines", to a song that is all about endings, "Will Circle be Unbroken". 

The biggest influence song cycle wise was Vaughan Williams' *Songs of Travel*, which has always been a personal favourite of mine. In that cycle, the songs are conceptually linked, and there is a a sense of journey, with a beginning, middle, and end. But it's also not as specific a journey as something like *Die schöne Müllerin*, so more is left up to the imagination of the audience. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1504205572202/2017-08-31---beckettalbum2.jpg.jpg)
<figcaption>Justin Ralph and Beckett.</figcaption>
</figure>

## How universal do you think the art of writing songs is, across musical genres?

I think its completely universal. It's amazing to compare a true, hillbilly country singer like Hank Williams to a 19th-century urbanite composer like Schubert, and find that in their songwriting they were exploring the exact same ideas and concepts. I think if they had sat down in a parlour in Vienna or a saloon in Alabama they would have found a lot to talk about. 

>By the Old Railroad is available for download - and just $5! - at [Ralph's website](https://www.justinralph.com/music).
