+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = "2018-03-26T21:38:00-04:00"
lastmod = "2018-03-27T09:29:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522114263696/sq---PBO-Figaro-1.jpg.jpg"
primary_image_credit = "David Adam Moore as The Count; Janai Brugger as Susanna; Irene Roberts as Cherubino in Le nozze di Figaro, Palm Beach Opera, 2018. Photo: Bruce Bennett"
publishDate = "2018-03-26T21:38:00-04:00"
related_articles = ["articles/too-many-jewels-the-search-for-meaning-pbos-candide.md","articles/steps-forward-for-operas-women-tosca-at-pbo.md"]
related_companies = ["scene/companies/palm-beach-opera.md"]
short_description = "Palm Beach Opera put on a great show, but it&#039;s worth noting that the aspects that made it so great – a stellar cast, thoughtful design, skillful interpretation – can be applied to any opera, regardless of inclusion in the Greatness canon."
slug = "just-plain-great-pbos-le-nozze-di-figaro"
title = "Just plain great: PBO&#039;s Le nozze di Figaro"
+++

Whenever a Mozart opera crops up in a company's season brochure, vocabularies tend to drift toward eager superlatives. In his program note for Palm Beach Opera's production of [*Le Nozze di Figaro*](https://pbopera.org/event/le-nozze-di-figaro/), director Stephen Lawless touted the work as "undoubtedly the greatest operatic comedy, and arguably the greatest opera ever written."

Though any assertion proclaiming a single work of art to be The Greatest begs interrogation, Lawless and [Palm Beach Opera](https://pbopera.org/event/le-nozze-di-figaro/) invited the audience gathered at the Kravis Center on March 25 into a production that was clever, charming, and not afraid to get political. Co-produced alongside Opera Philadelphia, Lyric Opera of Kansas City, and San Diego Opera, the pairing of Lawless' stage direction with thoughtful scenic and costume design by Leslie Travers culminated in a visually rich canvas upon which a strong cast delivered outstanding musical performances.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522114349234/PBO-Figaro-2.jpg.jpg)
<figcaption>David Adam Moore as The Count; Caitlin Lynch as The Countess in *Le nozze di Figaro*, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

In his U.S. debut, Croatian bass-baritone Marko Mimica as the title groom won over the audience with a resonant voice and rakish comic delivery, even flipping off the Count during a defiant "Se vuol ballare." Opposite Mimica, soprano Janai Brugger shone as a sharp and confident Susanna. Brugger's charisma commanded the spotlight, and she sang the role with a clear, sweet timbre that harmonized deftly in the opera’s famously intricate ensemble numbers.

Bass-baritone Valeriano Lanchas as Doctor Bartolo and mezzo-soprano Elizabeth Bishop as Marcellina caught big laughs, as did bass-baritone Andrew Simpson's bumbling gardener Antonio. Soprano Chelsea Bonagura's saucy Barbarina was strongly sung, and tenor Matthew DiBattista aced the dual roles of Don Basilio and Don Curzio with an excellent voice and witty presence.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522114364286/PBO-Figaro-3.jpg.jpg)
<figcaption>David Adam Moore as The Count in *Le nozze di Figaro*, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

As the pubescent pageboy Cherubino, mezzo-soprano Irene Roberts was a definite highlight, her colourful voice channelling a cheeky overconfidence and lending genuine passion to Cherubino's multiple yet earnest crushes. Cherubino's antics were well timed for maximum laughter – concealing his crotch with his tricorne hat upon mention of his beloved Rosina, and scurrying skittishly in a skillfully choreographed scene that had Roberts' Cherubino and David Adam Moore's Count Almaviva scrambling to hide in, under, and around Susanna's bed.

Baritone Moore sang an impressive Count, stentorian and scheming, with an apt air of arrogance accompanying his decisive musicality. As the opera unfolded, Travers' costume designs echoed the Count’s fall from grace: first, his grand, red-and-gold overcoat disappeared; by the final scene, he could be found half undressed, preparing for his rendezvous with "Susanna" in the garden.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522114379312/PBO-Figaro-4.jpg.jpg)
<figcaption>Irene Roberts as Cherubino; Chelsea Bonagura as Barbarina in *Le nozze di Figaro*, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

The Countess, meanwhile, inhabited an opposite trajectory. Introduced to the audience in a white nightgown and fretting over her husband's infidelities, she commanded the final scene in a sparkling red dress and, with almost smug satisfaction, accepted the Count's pleas for forgiveness. As the Countess Almaviva, soprano Caitlin Lynch was radiant, singing a regal "Dove sono" and capturing the Countess' strength with a glowing voice and a glimmer of humour. 

Conductor Antonino Fogliani led the Palm Beach Opera Orchestra from the fiery overture through the triumphant finale, in what may have been the orchestra's best performance of the season. Woodwind solos especially shone, and captured a playful, Classical style.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522114395449/PBO-Figaro-7.jpg.jpg)
<figcaption>Janai Brugger as Susanna; Irene Roberts as Cherubino in *Le nozze di Figaro*, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

The set comprised a pair of grey walls – decorated with intricate plaster detailing, not to mention doors and windows aplenty – which revolved and shifted to construct what Travers referred to in his program note as "an interesting geography." The result was almost Escheresque, with corners and hallways appearing and disappearing at unexpected moments. As the set pieces moved and the plot advanced, the atmosphere took a darker turn, with the Count's estate seeming to crumble, much like the aristocracy Mozart sought to mock.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522114408697/PBO-Figaro-6.jpg.jpg)
<figcaption>Irene Roberts as Cherubino in *Le nozze di Figaro*, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

This scenic storytelling was aided by clever lighting design from Thomas C. Hase, who captured sharp silhouettes and exciting glimpses of colour. During Mimica's audience-favourite "Aprite un po' quegli occhi," Hase brightened the house lights, welcoming the audience into Figaro's fourth wall–breaking rant.

As for Lawless' claim that Figaro may be "the greatest opera ever written"? Greatness is a precarious label, bestowed upon white men by other white men, leaving little room for anyone else to be heard, let alone considered for induction into the catalogue of Greats. But where *Le Nozze di Figaro* may be deemed Great – a member of this towering, exclusionary club of arbitrary membership – Palm Beach Opera's performance was just plain great. Not because it was superior to any other opera, not because it possessed qualities like "tunefulness" or "mastery" as boasted by the PBO marketing department – but simply because, even after the curtain fell and the mass exodus to the parking garage began, it left the audience smiling.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522114422897/PBO-Figaro-5.jpg.jpg)
<figcaption>Valeriano Lanchas as Dr. Bartolo; Elizabeth Bishop as Marcellina; Marko Mimica as Figaro in *Le nozze di Figaro*, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

[Palm Beach Opera](https://pbopera.org/event/le-nozze-di-figaro/) put on a great show, but it's worth noting that the aspects that made it so great – a stellar cast, thoughtful design, skillful interpretation – can be applied to any opera, regardless of inclusion in the Greatness canon. As PBO – along with much of the opera world – looks toward a 2018-19 season of so-called Greats, we as audiences could stand to do some homework: listen to works and composers from the margins of our music history books, and keep in mind that for every *Le Nozze di Figaro* to take the stage, another exciting gem awaits discovery.
