+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2023-10-01T00:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1696185591/sqJuliaBullock.jpg"
primary_image_credit = "Pianist John Arida and soprano Julia Bullock in the Board of Officers Room at the Park Avenue Armory. Photo: Maria Baranova, courtesy of Park Avenue Armory."
related_articles = ["articles/talking-with-conductors-enrique-mazzola.md", "articles/vancouver-opera-sails-away-in-the-flying-dutchman.md"]
related_companies = []
related_people = ["/scene/people/julia-bullock.md"]
short_description = "Eschewing any trace of strained posturing or winking high-art condescension she embellished each group of songs with a musical aura; a subtle shift in posture, a theatrical gaze reflecting her oneness with the music and a spot-on sense of purpose."
slug = "julia-bullock-a-miraculous-evening-from-schubert-to-nina-simone"
title = "Julia Bullock: A miraculous evening from Schubert to Nina Simone"
youtube_url = ""

+++
Julia Bullock made her entrance into the Board of Officer's Room at New York's Park Avenue Armory as if surprised but genuinely delighted to see us. The soprano's warm and embracing manner permeated a recital encompassing a dazzling array of songs and styles spanning two centuries. That the program moved so seamlessly and with an exquisite and ever-changing naturalness was nothing sort of miraculous.

Upon entering this intimate space an usher informed us that Bullock was indisposed. Perhaps it was Bullock's initial effervesce that banished any thought of vocal limitations, and for the first half of the recital such banishment was wholly warranted. Bullock produced a lustrous sound replete with gleaming high notes and a smokey yet commanding lower register. But clearly the soprano was not basing her performance on vocal agility alone. Her intelligence and genuine feeling for the music was abundant throughout, producing thoughtful and often revelatory interpretations.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1696185592/JuliaBullock_1.jpg){{% /md %}}
<figcaption>Soprano Julia Bullock in the Board of Officers Room at the Park Avenue Armory. Photo: Maria Baranova, courtesy of Park Avenue Armory.</figcaption>
</figure>

Let's say at the outset that this Munich-based American soprano from St. Louis, MO, is without question a seasoned and sensitive actor. Eschewing any trace of strained posturing or winking high-art condescension she embellished each group of songs with a musical aura; a subtle shift in posture, a theatrical gaze reflecting her oneness with the music and a spot-on sense of purpose. The program ranged from Schubert and Wolf lieder to the powerful messaging of vocalist, pianist and activist Nina Simone with stops for composers and lyricists including Kurt Weill and Alberta Hunter.

Bullock's rendition of the Schubert's "Rastlose Liebe" was indeed restless and freshly so. With sumptuous and emotive singing she expressed the underlying humor of Wolf's "In dem Schatten meiner Locken." Bullock treated "There Is a Vine" and "One by One," two songs by Connie (Elizabeth Eaton) Converse, born in 1924 and listed as disappeared, 1974, with intriguing simplicity, their elegant lyrics and rhythms reflecting love's uneven terrain and the human need for connection. Here Bullock offered evidence of neglected woman composers, a case she would make with ample evidence throughout the evening.

But first came Kurt Weill, that Berlin to Broadway composer who Bullock told us she loves because he makes the personal universal. She captured the existential longing in the title song from _Lost in the Stars_ and the edgy irony present in "Because How You Put Yourself to Bed is How You Lie" from _The Rise and Fall of the City of Mahagonny_, with texts respectively by Maxwell Anderson and Bertolt Brecht. And how she reveled in author, poet and self-proclaimed anarchist Walter Mehring's confounding text for "How much longer?" and Ira Gershwin's snappy lyrics for "The Princess of Pure Delight" from _Lady in the Dark_.

Rossini and Berio, two Italian composers born over 130 years apart, were another story altogether. Not content with merely singing Rossini's "Stabat Mater" and "Sorzico" in a beautiful Italianate manner, Bullock imbued each with an incisive if fleeting point of view. Berlio's tongue-twisting songs were handled with brio, especially "Ballo," with its syllabic repetition of "la ra" in which she created a context, a technique she employed to spectacular effect in John Cage's "Duet" after the intermission.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1696185592/JuliaBullock_headshot.jpg){{% /md %}}
<figcaption>Soprano Julia Bullock. Photo: Allison Michael Orenstein.</figcaption>
</figure>

Formally known as _She is Asleep_ no. 2 "Duet," Cage's wordless song accompanied by piano with altered pitch, might not have seemed an obvious crowd-pleaser but it was exactly that. Bullock explained that Cage left the selection of syllables to be sung and piano pitch up to the musicians, a much-appreciated granting of agency to the performing artists.

Cage proved a fitting segue into the the mournfully romantic "Driftin' Tide" by Pat Castleton and the Cora Austin/Alberta Hunter "Downhearted Blues," numbers about unrequited love and a woman's promise to seek equality in her next relationship. Here Bullock became a natural born blues singer and when she finished "Downhearted Blues" she offered a cheer for lyricist Hunter, whose rendition remains definitive, prompting the audience to cheer right back.

Bullock withdrew from singing the Billie Holiday/Sonny White ballad "Our Love is Different," reminding us that indisposition, however distant, had been hovering and asked her intrepid accompanist John Arida to play it. All evening Arida supported the singer with authenticity equal to hers, a testimony to his superlative talent and finesse. Here was the silver lining we weren't necessarily looking for; his playing of this tender, especially by Holiday standards, song of mutual devotion for as long as it lasts.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1696185591/JuliaBullock_JohnArida.jpg){{% /md %}}
<figcaption>Pianist John Arida.</figcaption>
</figure>

Having emoted on stage to Arida's solo and in a register more accommodating than the Holiday ballad would have called for, Bullock marched with appropriately hardened tone into Nina Simone's swinging but pointed anthem "Revolution" and an intensely dramatic "Four Women," two Simone compositions that make fierce statements about race and the stereotypes with which African American women must contend.

We would not hear Billy Taylor's "I Wish I Knew How it Would Feel to be Free" but Bullock entreated us to give it a listen on our own. I did, straight away, first in a jazzy and spiritual rendition by the Billy Taylor Trio and then Simone's vocal that  builds with inexorable force. I was left with a vivid picture of how Bullock might have approached the song and the feeling that this extraordinary recital was complete.