+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = "2019-10-20T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Edmonton Opera’s production of Verdi's [Rigoletto](https://www.edmontonopera.com/2019-20/rigoletto) runs October 19, 22 and 25 at the Northern Alberta Jubilee Auditorium."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1571583046/media/2019/10/sqRigolettoGildaJamesWestmanSharleenJoynt_mg7khm.jpg"
primary_image_credit = "James Westman and Sharleen Joynt in Rigoletto, Edmonton Opera, 2019. Photo: Madison Kerr."
related_articles = ["articles/cleanedup-callas-the-remastered-live-recordings.md", "articles/aria-guides-parmi-veder-le-lagrime.md", "articles/great-music-distracting-sexuality-rigoletto.md"]
related_companies = ["scene/companies/edmonton-opera.md"]
related_people = ["scene/people/matthew-white.md", "scene/people/james-westman.md", "scene/people/sharleen-joynt.md"]
short_description = "With Rigoletto, Edmonton Opera connects with a wide spectrum of themes that most people will identify: the danger of power that goes unchecked, the fear when those closest to you are threatened, and the purity of love and being loved. If you've never seen an opera before, this is a production that will definitely get you hooked."
slug = "joynt-angelic-in-canadian-debut-as-gilda-in-edmonton-operas-rigoletto"
title = "Joynt angelic in Canadian debut as Gilda in Edmonton Opera's Rigoletto"
youtube_url = ""

+++
Not all "first times" can be memorable.

For [Edmonton Opera](/scene/companies/edmonton-opera/) audiences, however, the performance of [Sharleen Joynt](/scene/people/sharleen-joynt/) as a mainstage coloratura soprano will be one to remember for a long time. As Gilda in Edmonton Opera's production of Verdi's _Rigoletto_, Joynt shimmers with an angelic quality that is simply heavenly. Navigating Verdi's writing with ease, Joynt simply captivated the audience, portraying Gilda with purity and innocence. Her performance of the aria "Caro nome" was particularly exquisite; her expressiveness made Gilda a shining light amid the darker themes of lust, betrayal, and vengeance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571583376/media/2019/10/EORigoletto3_czy5s3.jpg){{% /md %}}

<figcaption>Matthew White (Duke of Mantua) in Rigoletto, Edmonton Opera, 2019. Photo: Madison Kerr.</figcaption>

</figure>

[Matthew White](/scene/people/matthew-white/) is the perfect foil for Joynt, wowing the audience with his lyric tenor as the Duke of Mantua. Ruthless, manipulative and lustful, White complements his portrayal of a man drunk with power with tremendous vocals. While his performance of "La donna è mobile" was a crowdpleaser, it was his ["Parmi veder"](/aria-guides-parmi-veder-le-lagrime/) at the beginning of Act II, where he laments the disappearance of his "beloved" Gilda, that elicited the strongest response. The fickleness of his feelings for Gilda, however, are underpinned by how "Parmi veder" is staged: he sings it half-naked after a tryst with another "beloved."

> His singing remains silky smooth through all its ranges, particularly in the higher parts of his voice.

As the titular character, baritone [James Westman](/scene/people/james-westman/) once again underscores his place as one of Canada’s best interpreters of Verdi's music. Renowned by critics and audiences alike for his portrayal of Giorgio Germont in Verdi's _La traviata_, Westman's interpretation of Rigoletto is expressive, nuanced and multi-dimensional; he transitions like a chameleon from court jester to loving father to scheming murderer. And all the while, his singing remains silky smooth through all its ranges, particularly in the higher parts of his voice.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571583359/media/2019/10/EORigoletto2_gcb3dh.jpg){{% /md %}}

<figcaption>James Westman (Rigoletto, background), Matthew White (Duke), and Sharleen Joynt (Gilda) in Rigoletto, Edmonton Opera, 2019. Photo: Madison Kerr.</figcaption>

</figure>

The performances by these three core principal characters was enhanced by the relatively simple set design. The audience focuses more on the tremendous interpretations by Joynt, White and Westman. But while the set design was relatively simple, the lighting cues effectively used shadows to accentuate darker themes within the opera such as the abduction of Gilda and the betrayal of Rigoletto. In the aria "Cortigiani, vil razza dannata," as Rigoletto pleads desperately for the return of his abducted daughter, the courtiers/abuctors are cast in shadow, backs turned to the jester, as Rigoletto's pleas go ignored.

> If you've never seen an opera before, this is a production that will definitely get you hooked.

The supporting cast should also be acknowledged for their limited time on stage. Baritone Aaron Dimoff offered strong portrayals as both the exiled courtier Monterone and the hitman Sparafucile. Krista da Silva is sultry as Maddalena. And as the henchmen Borsa and Marullo, tenor Matthew Dalen (in his Edmonton Opera debut) and baritone Tyler Fitzgerald are convincing in their loyalty to the duke and their coldness toward the court jester. Rounding out the strong vocal performances was the male chorus, prepared by chorusmaster Peter Dala, who sang confidently and clearly throughout the opening-night performance - especially the tenors.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571583384/media/2019/10/EORigoletto4_t7urpv.jpg){{% /md %}}

<figcaption>James Westman in the title role of Rigoletto, Edmonton Opera, 2019. Photo: Madison Kerr.</figcaption>

</figure>

With _Rigoletto_, Edmonton Opera connects with a wide spectrum of themes that most people will understand: the danger of power that goes unchecked, the fear when those closest to you are threatened, and the purity of love and being loved. If you've never seen an opera before, this is a production that will definitely get you hooked.