+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = 2019-11-29T05:00:00Z
discipline = ""
disclaimer = ""
image_gallery = []
postamble = "English National Opera's production of [_Orphée_](https://www.eno.org/whats-on/orphee/) is onstage through 29 November."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1574965073/media/2019/11/sq2876ashm_0804_ngp2z0.jpg"
primary_image_credit = "Jennifer France in ENO's production of Orphée, 2019. Photo: Catherine Ashmore."
related_articles = ["articles/orpheus-eurydice-opera-atelier.md", "articles/futuristic-baroque-burlesque-orphe.md"]
related_companies = ["scene/companies/english-national-opera.md"]
related_people = ["scene/people/jennifer-france.md"]
short_description = "Much like past productions I've seen at ENO, the singing was a bit of a mixed bag. Many of the characters were played by young singers at the beginning of their careers. Naturally, some flourished while others struggled to keep up."
slug = "jones-reflects-glass-in-enos-orphee"
social_media = []
title = "Jones reflects Glass in ENO's Orphée"
website = ""
youtube_url = ""

+++
English National Opera presents a new production of Philip Glass' _Orphée_, a modern reimagining of the Orpheus myth inspired by the 1950 Jean Cocteau film of the same name.

Director/designer Netia Jonas borrowed heavily from the film in the design of the production and overall visual presentation. The characters directly mirrored those in the film in dress and mannerism. Video projections designed by Jones feature key moments from the film, intermingled with abstract scenes that add depth and texture to the production. The piece called for a few instances of clever problem solving which the production delivered on. Crucial to the story telling were the moments when characters would step through mirrors into the other world. To achieve this, they made use of a camera pointed at the mirror and a screen facing the audience so that the audience could see what the characters were seeing when looking into the mirror. This gifted the mirrors with an almost sentient quality as though the other world that lay just on the other side of the glass, was looking into us, just as we were looking into it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574965117/media/2019/11/2876ashm_0821_lv4f97.jpg){{% /md %}}

<figcaption>Nicholas Lester in ENO's production of Orphée, 2019. Photo: Catherine Ashmore.</figcaption>  
</figure>

Musically, this work pales in comparison to Glass' earlier operatic efforts, in particular his trio of biographical operas composed between 1975-1983. I think I can pin this down to the fact that _Orphée_, along with its counterparts _La Belle et la Bête_ (1994) and _Les Enfants Terribles_ (1996), are driven by narrative and feature librettos taken from the Cocteau films while the earlier operas have little in the way of narrative structure and virtually no libretto to speak of. Personally, I think that the nebulous plot is better suited to Glass' style of writing which often features meditative repeated patterns that play with rhythm and are based on a simple harmonic structure. The ceaselessness of this kind of music does not particularly lend itself to a standout aria, or a dialogue heavy scene. The vocal lines did not always land, particularly in some of the more humorous scenes, because they were so athletic and unrelenting and tended to disregard natural speech patterns.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574965081/media/2019/11/2876ashm_0129_gpno3o.jpg){{% /md %}}

<figcaption>Jennifer France and Nicholas Lester in ENO's production of Orphée, 2019. Photo: Catherine Ashmore.</figcaption>  
</figure>

Much like past productions I've seen at ENO, the singing was a bit of a mixed bag. Many of the characters were played by young singers at the beginning of their careers. Naturally, some flourished while others struggled to keep up. In the role of The Princess, soprano Jennifer France gave a committed and practised performance in an extremely challenging role, yet she lacked the authority to command the stage as a character who is meant to be the physical manifestation of death itself. Nevertheless, I admire ENO's commitment to celebrating young talent and I am eager to see where her career takes her.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574965098/media/2019/11/2876ashm_0371_or59zc.jpg){{% /md %}}

<figcaption>Nicholas Lester, Sarah Tynan, and Nicky Spence in ENO's production of Orphée, 2019. Photo: Catherine Ashmore.</figcaption>  
</figure>

Baritone Nicholas Lester and tenor Nicky Spence in the roles of Orphée and Heurtebise respectively were both standouts for me. Lester has a noble, high baritone colour that was very pleasing to listen to and gave his character an air of importance. In the role of Orphée, he was initially rather unlikeable; obsessive and cold, he had a horrible habit of ignoring his attention-starved pregnant wife. But as the piece wore on, he grew on me. He was the source most of the sardonic humour featured in the piece and I eventually began to feel for his character who was obviously just a restless artist battling with the concept of celebrity and his own demise.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574965129/media/2019/11/2876ashm_0632_ooc5kr.jpg){{% /md %}}

<figcaption>Jennifer France and Nicholas Lester in ENO's production of Orphée, 2019. Photo: Catherine Ashmore.</figcaption>  
</figure>

Nicky Spence's Heurtebise, on the other hand was immediately likeable. He is a friendly, generous, and sensitive character that Spence played with grace. All of his physical choices on stage were directly connected to the text and to the character. He gave an engaged performance which was truly a joy to watch.

Overall, I felt this was an inventive reimagining of an age-old story that has seen countless permutations through the ages. Jones' production was an honest reflection of Glass' music and a beautiful homage to Cocteau's film. Praise is due to the English National Opera for continuously programming thought-provoking productions and for committing to establishing a platform for the visions of female creatives in the industry.