+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-11-03T14:55:00+00:00"
lastmod = "2016-11-05T15:04:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478261356742/2016-11-04---Ivany.jpg.jpg"
primary_image_credit = "Photo by Nicola Novak."
publishDate = "2016-11-05T14:43:00+00:00"
related_articles = ["articles/in-review-puss-in-boots-berios-folk-songs.md","articles/in-review-albert-herring-at-uoft-opera.md","articles/in-review-death-desire.md"]
related_companies = ["scene/companies/royal-conservatory-of-music.md"]
related_people = ["scene/people/joel-ivany.md"]
short_description = "&quot;You&#039;re going to be mingling in the lobby and in the auditorium, and you&#039;re going to be meeting these people from the salon, which are the students from the school.&quot; It&#039;s a &quot;play-within-a-play&quot; idea, where the Cendrillon audiences live in the same world as the singers who perform the opera. The members of the cast each have two roles to play: their part in Viardot&#039;s opera, and the &quot;character&quot; who exists offstage during the salon evening."
slug = "joel-ivany-were-throwing-a-salon"
title = "Joel Ivany: &quot;We&#039;re throwing a salon.&quot;"
+++

For most opera lovers, the Cinderella story conjures up the blazing coloratura in Rossini's *La Cenerentola* and the shimmering sounds of Massenet's *Cendrillon*. Pauline Viardot - whose name does not quickly come to mind as an opera composer - wrote her *Cendrillon* alongside contemporaries like Meyerbeer, Debussy, and Gounod.

"She was right in the middle of all the greats," says Joel Ivany, who will direct Viardot's [*Cendrillon*, presented on November 18 and 19](http://performance.rcmusic.ca/event/ggs-fall-opera-1) by the Glenn Gould School Opera program. Viardot enjoyed a career as a [singer](https://en.wikipedia.org/wiki/Pauline_Viardot#Career); she was the dedicatee of Saint-Saëns' *Samson et Dalila*, and she created roles for Gounod and Meyerbeer; she even studied piano with Frédéric Chopin. "I think she was known within the right realms," says Ivany, "but just not as a serious, legitimate opera composer."

First performed in 1904, *Cendrillon* is one of six operas by Viardot, written for performances in her salon series, and in her lifetime, never performed in a traditional opera house. Women held a level of status and power in world of salon performances; they chose the guests and programmed the evenings. "Outside of the salons, it was a man's world," admits Ivany. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478258900828/2016-11-04---Cendrillon-Sketch-1.jpg.jpg)
<figcaption>Sketch for *Cendrillon* at The Royal Conservatory of Music, by designer Anna Treusch.</figcaption>
</figure>

Viardot was never commissioned by a house to compose an opera; Ivany is confident that she had the skills to do so, with her legacy of writing art song, and her own proficiency as a singer. Yet, she remained on the outskirts of the mainstream opera scene of her time. "Why didn't Giacomo Meyerbeer say, 'you know who'd write a good opera, is Pauline Viardot,'" muses Ivany. "I don't know if they had the power to champion or programme them outside of these salons."

Luckily for Ivany, the intimacy of a salon opera is right up his alley. The Artistic Director of [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/) has made a name for himself by transforming performance spaces and drawing his audiences into the experience as much as possible.

"We're throwing a salon," he explains simply. "You're going to be mingling in the lobby and in the auditorium, and you're going to be meeting these people from the salon, which are the students from the school." It's a "play-within-a-play" idea, where the *Cendrillon* audiences live in the same world as the singers who perform the opera. The members of the cast each have two roles to play: their part in Viardot's opera, and the "character" who exists offstage during the salon evening. "They'll all be talking about fun facts from the 1900s," Ivany laughs.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478258936765/2016-11-04---Cendrillon-Sketch-2.jpg.jpg)
<figcaption>Sketch for *Cendrillon* at The Royal Conservatory of Music, by designer Anna Treusch.</figcaption>
</figure>

The new treatment of Mazzoleni Hall pairs well with the story of Cinderella, a folk tale which has roots as old and distant as 9th-century China. In addition to the notable Rossini and Massenet adaptations, operas about Cinderella have been written by Sergei Prokofiev, Gustav Holst, Ermanno Wolf-Ferrari, and Peter Maxwell Davies.

For Ivany, the folk tale is about "someone who doesn't have as much as maybe she would like, who learns that good things can happen if you're kind and you're nice - even when things aren't going well." He notes that Viardot's *Cendrillon* is only an hour long, and the action moves along at a relatively quick pace. "She finds the prince and they fall in love and then she runs away," laughs Ivany. "The next day she tries on the shoe, and it fits. Happy ending."

The students of Glenn Gould School Opera have also been involved in the creative process. The English translation of the original French libretto comes from the dramatic work done by the singers, discovering their characters and how they speak. It was an exercise given by Peter Tiefenbach, GGS faculty and Music Director for *Cendrillon*. "He got them to rewrite the text of their music," Ivany explains. "It's kind of like the whole cast took it upon themselves to play with rhyming, to play with what their character is saying." 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478258946455/2016-11-04---Cendrillon-Sketch-3.jpg.jpg)
<figcaption>Sketch for *Cendrillon* at The Royal Conservatory of Music, by designer Anna Treusch.</figcaption>
</figure>

It's a concept that seems perfect for Ivany, who has earned praise for his award-winning "transladaptations" for Against the Grain Theatre, including *La bohème*, *Figaro's Wedding*, and *A Little Too Cozy*. Still, sharing the task is new. "I've never done that, in terms of giving full liberty to a group of writers," says Ivany. "If I were to teach a course in 'transladaptations,' it would probably involve something like what they're doing."

>*Cendrillon* plays November 18 and 19 in Mazzoleni Hall, at the Royal Conservatory of Music. For details, [click here](http://performance.rcmusic.ca/event/ggs-fall-opera-1) or call the box office at 416-408-0208.
