+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-06-23T22:00:00-06:00"
lastmod = "2015-06-25T08:03:00-06:00"
preamble = "Here at The Banff Centre, we're working on *Crush*, a new opera by composer [James Rolfe](/scene/people/james-rolfe/) and librettist [Anna Chatterton](/scene/people/anna-chatterton/). It's a fascinating piece, based on Mozart's *Don Giovanni*, this time featuring a female protagonist named Donna. I was thrilled when Anna and James offered to talks about the process of creating *Crush*. They both write eloquently about how they've collaborated on the piece; I've learned that whatever amount of work I sense has been put into writing an opera, doubling that amount is probably more accurate. "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1435240241950/IMG_20150622_095822.jpg.jpg"
publishDate = "2015-06-25T08:00:00-06:00"
related_articles = ["articles/more-atg-in-banff-2015.md","articles/banff-diaries-a-postlude.md","articles/breathe-the-latest-recordings-from-james-rolfe.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/canadian-opera-company.md","scene/companies/the-banff-centre.md"]
related_people = ["scene/people/james-rolfe.md","scene/people/anna-chatterton.md","scene/people/amiel-gladstone.md"]
short_description = "Here at The Banff Centre, we&#039;re working on Crush, a new opera by composer James Rolfe and librettist Anna Chatterton. It&#039;s a fascinating piece, based on Mozart&#039;s Don Giovanni, this time featuring a female protagonist named Donna. I was thrilled when Anna and James offered to talks about the process of creating Crush. "
slug = "james-rolfe-anna-chatterton-on-creating-crush"
title = "James Rolfe &amp; Anna Chatterton, on creating Crush"
+++

### How did you imagine this take on the Don Juan story, and why did you choose a female protagonist (Donna)?

**Anna Chatterton**:  It was 2007. James and I had just finished the production of *Swoon*, our first opera together, which was loosely inspired by *The Marriage of Figaro*, adapted into modern day times. When the Canadian Opera Company asked us to propose a full-length opera, we decided to look again to be inspired by a classic story or opera. As a female writer, I felt strongly that I wanted the protagonist of this opera to be a woman, and James happily agreed. We received some grant money to do research on how a contemporary female romantic heroine behaves, originally inspired by Cyrano de Bergerac. 

We wondered how a woman seduces today, with words, to bridge the gap between movement and utterance. I conducted interviews with women about love and romance. In our following discussions James and I felt that Don Juan would be a more accommodating template for a romantic opera. We also felt that our protagonist Donna, would not limit herself only to men, she would be in love (lust) with everyone. The hurdle was to overcome peoples assumptions that a woman would never behave in such a way…pursing and lusting with a voracious appetite.  Following the *Don Giovanni* libretto closely, I came to various places where I questioned if Donna should allow herself more weakness, more insecurities, more reasons in her past for why she behaved this way. But James felt strongly that Don Giovanni and Donna were mythical characters, and that Donna should be allowed to be brash, single minded, unquestioning, unaccountable and unrepentant about her *raison d’etre*. 

**James Rolfe**:  I like making art which engages people, something which opera can do to perfection: singing and music connect directly to our feelings. The great Mozart/da Ponte comic operas were very contemporary and even controversial in their day, something which has become lost to modern audiences. We were drawn to the challenge of retelling *Don Giovanni* in the 21st century, complete with the protagonist's spurious guise as an aristocratic revolutionary. It seemed the most natural thing to make her a woman, given that one of the most revolutionary changes of our times has been in gender roles. 

It wasn't a straightforward change! It's a great way to get to know the original, with all its dramatic strengths and challenges. For me, the emotional weight is carried by the protagonist's victims, so we strengthened their roles, and downplayed the supernatural justice of the original, which is less credible nowadays. One essential bond is the father-daughter relationship of Matt and Lola, which proves too much even for superhuman Donna.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1435240307379/AnnaChatterton.jpeg)
</figure>

### Can you tell us about your creative process for *Crush*?

**Anna**:  James and I work closely to come up with the story, characters and structure for an opera, and figure out each scene and the action for each scene. I will then sketch out the first draft of the opera, which I then share with James. After copious notes from him and lengthy discussions, I will then write a second draft, repeat, repeat, repeat. Then we will give a draft to our dramaturge (with *Crush* — the thoughtful Guillaume Bernardi) and have a meeting and get notes, discuss, and then I will write the next draft, repeat, repeat, repeat. 

James will begin to write his first draft, stopping along the way to ask for quite specific rewrites or additional text. Once he is done his draft, he invites me to listen to it via Midi sound files and we will discuss. I will offer feedback in terms of my response to the music, though there is much less detailed notes on my part. Usually, I love it, with a few places that I have questions or gut instincts about this or that. Then James writes another draft, repeat, repeat, repeat, repeat. Because this opera was two acts, we wrote the first act first, had a workshop and then wrote the second act, followed by a workshop. 

*Crush* took around two years to write the libretto and around three years to compose the music.

**James**: After a lot of experience, I like to make sure the libretto is in good shape before beginning to compose. The words are like the foundation and skeleton all in one — if they're not true, the building won't stand up. But it's still a lot of drafts and workshops and revising, a process which demands close collaboration with the librettist. Which I enjoy, since she will have a sense for things I'd miss on my own, and vice versa. Anna has a very good sense of the stage, and also for creating emotionally truthful and alive characters, both of which are essential to making an opera which is alive.

Revisions can seem endless, because the devil is in the details. Choosing the right vocal register will make or break a phrase, and a difference as little as a tone or a semitone can make a moment sublime or ridiculous. The same goes for words, pacing, tempi. And as ever, timing is everything. All these must be just so.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1435240350317/JamesRolfe.jpeg)
<figcaption>Composer James Rolfe.</figcaption>
</figure>

### What unknowns still exist for a new opera in this stage of development?

**Anna**: There are many unknowns until *Crush* will be dished out to an audience. How will the audience respond to our Donna? Will they hate her? Will they fall under her spell and be seduced by her? Will the woman wish they were her? Will the men wish they were her? It feels like a bit of a daring piece, even though there is much more daring work out there, but somehow, having a woman act like a Don Juan type man, still somehow feels taboo. It has been eight years since I began writing the libretto for *Crush*. 

I was at a very different place in my life when I wrote *Crush*. I was no Donna, but I was certainly bold and direct in my dating life. While writing the libretto, I borrowed from myself, I borrowed from the women I interviewed, I borrowed from da Ponte (librettist of *Don Giovanni*). But I was not just Donna, I was Lola, Anna, Otto, Sam, Matt...as writers usually are when we write, we become everyone and steal shamelessly from life, fiction, everything, anything. Now, as a mother of a three year old, happily married and settled down, how will I view our Donna? Will I judge her? Will I envy her? Will I remember her in myself? 

**James**: An opera is a complete unknown until it's in front of an audience. The creators have only an approximate idea of what they made; on stage, the piece takes on a life of its own, in spite of our most careful efforts to control our creation. It's both exhilarating and terrifying. I'm happy if the audience cares what happens, if they're drawn in to the story and the characters, whether they agree with them or not, like them or not. It's a sign that the opera is alive and kicking and breathing.
