+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-10-02T20:33:00-04:00"
lastmod = "2017-10-03T20:56:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506991083968/2017-10-02---Robinson%2C-James.jpg.jpg"
publishDate = "2017-10-03T20:43:00-04:00"
related_articles = ["articles/simone-osborne.md","articles/talking-with-singers-andrew-haji.md","articles/tim-albery-flawed-operas-falling-empires.md","articles/he-saidshe-said-a-sweet-elixir-at-the-coc.md","articles/lighter-fare-vancouver-operas-the-elixir-of-love.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/opera-theatre-of-st-louis.md"]
related_people = ["scene/people/simone-osborne.md","scene/people/gordon-bintner.md","scene/people/andrew-haji.md","scene/people/james-robinson.md"]
short_description = "&quot;I&#039;m always the first person to say, &#039;Ok, I had a bad idea, let&#039;s try something else&#039;,&quot; he says, smiling. &quot;When singers feel that they are part of the discovery process, making choices on their own, they memorize it faster, they&#039;re more reliable, they&#039;re more comfortable, and they sing better.&quot;"
slug = "james-robinson-elixir"
title = "James Robinson&#039;s Elixir of Love: &quot;I think it&#039;s one of the best comedies.&quot;"
+++

"You know what I wish I could sing?" poses director James Robinson, responding to my half-serious challenge of "If-You-Were-A-Singer". He prefaces his answer, recalling a particularly memorable performance he saw at The Santa Fe Opera: "Tatiana Troyanos was performing the title role of *Ariodante*. I wish I could sing that." Laughing, he adds one important caveat, "I also wish I could sing it with Troyanos' voice!"

"I do have tremendous respect for singers," says Robinson, whose current production is his [*The Elixir of Love*](http://coc.ca/PerformancesAndTickets/1718Season/ElixirofLove.aspx), set to open at the Canadian Opera Company on **October 11**. "I admire what they do. I'm in awe of them." It's something often said of Verdi's less-funny opera, *Il trovatore*, and Robinson finds too that for Donizetti's *bel canto* comedy, "you really do need four incredible singers."

"It's actually one of my favourite operas. I think it's one of the best comedies," says Robinson of *The Elixir of Love*. His production at the COC features three rising Canadian stars: soprano [Simone Osborne](/simone-osborne/) as Adina, tenor [Andrew Haji](/talking-with-singers-andrew-haji/) as Nemorino, and bass-baritone [Gordon Bintner](/scene/people/gordon-bintner/) as Belcore. Robinson likens the opera to many classic musicals in its "formulaic" use of devices like unrequited love, snake-oil salesmen, and the high stakes of imminent war. "You have all the standard characters in there," he says, yet "there's not one heroic character in it."

"Nemorino is not really what you would consider heroic. He's a nice guy who tries really hard." As for Adina's other suitor, "Belcore is a bit of a vain, glorious military guy." The combination of the simple guy, the admired woman, the blustering show-off, and the con-man make for "an odd group of people," but Robinson's aim is to tell a story that aligns the audience with the good guy. "When the circumstances are right, and you have a really good cast, you're rooting for Nemorino, and you hope it works out for him."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506991077068/2017-10-02---Elixir-of-Love---photo-credit-Ken-Howard---Photo-2.jpg.jpg)
<figcaption>A scene from the Opera Theatre of Saint Louis production of *The Elixir of Love*, 2014. Photo: Ken Howard.</figcaption>
</figure>

## "You may be sitting *right here*, and a singer may be singing *right there*."

Since 2009, Robinson has been Artistic Director of [Opera Theater of St. Louis](/scene/companies/opera-theatre-of-st-louis/), which boasts an impressive combination of compact performance calendars, a mix of established and emerging artists, and a focus on new and English-language productions. "I always love the spirit at that company," Robinson agrees. "There's great community investment in it, and that I find really thrilling. It's one of the very few places I know where there is such wonderful contact between audience and artist."

During his tenure as Artistic Director of OTSL, Robinson has made a point of developing new works. Perhaps more interestingly is his focus on new pieces by "people who had never written operas before," like Terence Blanchard and Michael Cristofer's jazz opera [*Champion*](https://www.operanews.com/Opera_News_Magazine/2016/3/Reviews/SAN_FRANCISCO__Champion.html) and Jack Perla and Rajiv Joseph's [*Shalimar the Clown*](https://www.operanews.com/Opera_News_Magazine/2016/7/In_Review/ST__LOUIS__Shalimar_the_Clown.html), based on the novel by Salman Rushdie. For Robinson, the repertoire suits the community that makes up OTSL's audiences; and perhaps more closely the intimate, informal performance environment.

"You may be sitting *right here*, and a singer may be singing *right there*," he says, gesturing a trivial distance. It's a kind of closeness - both literal and figurative - in which he finds that "so many barriers are broken down." OTSL invites its audiences into open rehearsals before productions open, and opera-goers and artists alike can mingle over post-performance drinks. Though the unique connection between artists and audiences happens, as Robinson puts it, "naturally," it's certainly a conscious decision to create an environment that's conducive for community. "We're very involved in bringing as much information and participation as we can to our audience," he says. "It's really worth it."

## "Opera singers don't like to be vulnerable."

His respect for their work is clear, but Robinson can still be surprised by singers in the rehearsal room. "I like it when singers know their text really well," says Robinson of the rehearsal room dynamic. Not only text, but he likes to get specific about punctuation. "Is it a comma, or a question mark?"

What's less impressive in rehearsal is a tendency to look backward, instead of forward. "What I always hate is when people come in and say, 'well, the last time I did this...'" says Robinson. "There's more than one way of doing anything." He chalks that kind of attitude up to a level of professional insecurity, but adds, "I've been very fortunate over the years to have encountered very few people like that."

"Opera singers don't like to be vulnerable. They're trained to know their stuff, they're told they *have* to know their stuff." Robinson notices a stark difference in the way singers are trained in comparison with actors; the former train in isolation, while the latter work in groups. Opera singers are hesitant to present the results of their training in public until it's at a high level of preparation, and it's easy to understand why. "Opera singers are probably critiqued and nitpicked over anybody else," says Robinson. "I would not want to be a scrutinized, as picked on as they are." 

In contrast, an actor's training is about embracing vulnerability. "I wish there were a way of getting opera singers to do some type of training in groups that uses music," Robinson muses. Even the elements of their craft which may have held a lower priority in past decades - like acting skills - are now an essential part of a singer's craft. Robinson considers opera a genre of "large gestures," demanding a different connection with an audience, particularly when performed in the world's large houses. Still, "I think singers have gotten more savvy these days about what an acting style is on stage."

Robinson finds that singers respond enthusiastically and intelligently to parsing a scene, and it's something he has enjoyed about working with the Toronto cast for his *Elixir of Love*. "Let's talk about what the objectives are in the scene," he says of his preferred method of working. "Let's discover, why are you saying this? Why is this action important?"

"I'm always the first person to say, 'Ok, I had a bad idea, let's try something else'," he says, smiling. "When singers feel that they are part of the discovery process, making choices on their own, they memorize it faster, they're more reliable, they're more comfortable, and they sing better."

>The Canadian Opera Company's production of [The Elixir of Love](http://coc.ca/PerformancesAndTickets/1718Season/ElixirofLove.aspx) runs October 11 to November 4. For details and ticket information, follow our box office links below.
