+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-20T09:55:00-04:00"
lastmod = "2017-07-22T10:37:00-04:00"
preamble = "*Breaking the Waves*, the opera by Missy Mazzoli and Royce Vavrek, has earned itself the [Music Critics Association of North America](http://www.mcana.org/)'s inaugural Best New Opera Award. The chamber opera, based on the 1996 Academy Award-nominated film by Lars von Trier, had its world premiere in 2016 with [Opera Philadelphia](/scene/companies/opera-philadelphia/) in conjunction with [Beth Morrison Projects](/scene/companies/beth-morrison-projects/); it tells the story of Bess and her husband Jan, who when he becomes paralyzed in an accident, encourages Bess to seek out other lovers and for her to tell him of her sexual experiences.\n\nThe Best New Opera award was created as a significant nod to a new fully-staged opera. We spoke with MCANA members **Heidi Waleson**, (*Wall Street Journal*) **Alex Ross** (*The New Yorker*), **Arthur Kaptainis** (*National Post*, *Montreal Gazette*), **John Rockwell** (freelance), and MCANA President **Barbara Jepson** about honouring the work by Vavrek and Mazzoli, and what they deem an award-winning opera."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1500560579680/2017-07-20---RoyceMissy.jpg.jpg"
primary_image_credit = "Royce Vavrek & Missy Mazzoli (photo: Marylene May), creators of the award-winning opera Breaking the Waves."
publishDate = "2017-07-22T10:37:00-04:00"
related_articles = ["articles/seasonal-opera-done-right-at-hgo.md"]
related_companies = ["scene/companies/beth-morrison-projects.md","scene/companies/the-industry.md","scene/companies/minnesota-opera.md","scene/companies/opera-philadelphia.md","scene/companies/prototype-festival.md","scene/companies/spoleto-festival-usa.md","scene/companies/san-francisco-opera.md","scene/companies/opera-theatre-of-st-louis.md","scene/companies/houston-grand-opera.md","scene/companies/fort-worth-opera.md"]
related_people = ["scene/people/missy-mazzoli.md","scene/people/royce-vavrek.md"]
short_description = "&quot;Breaking the Waves was modern, urgent, and heartbreakingly believable in its tragedy and redemption. It was also striking in the way it transformed the Lars von Trier film, which I found misogynistic, into something completely different – a story about female agency.&quot;"
slug = "its-official-breaking-the-waves-wins-best-new-opera"
title = "It&#039;s official: Breaking the Waves wins Best New Opera"
+++

## What stood out about *Breaking the Waves*, in order to earn this inaugural Best New Opera award?

**Barbara Jepson**: MCANA had periodically discussed the possibility of giving some kind of award for several years.  But what made it  happen was a twofold catalyst: First, there has been a proliferation of contemporary operas commissioned in the last several years.  Second, after MCANA founded its website, Classical Voice North America, in 2013, our members began covering many opera premieres in their home cities.
 
Part of MCANA's mission is to foster excellence, which we do both within our organization and by recognizing the achievements of composers, performers and presenting organizations.  With the board's consent, I formed the Awards Committee last summer, and now we are about to present the awards to our first recipients, composer Missy Mazzoli and librettist Royce Vavrek for their musically and theatrically unforgettable opera, *Breaking the Waves*.

**Alex Ross**; The opera created a world: it had a tone, a profile. There was an uncommonly strong relationship between libretto and music: the work felt urgent, driven by conviction, essential.

**Heidi Waleson**: *Breaking the Waves* was modern, urgent, and heartbreakingly believable in its tragedy and redemption.  It was also striking in the way it transformed the Lars von Trier film, which I found misogynistic, into something completely different – a story about female agency.        

**John Rockwell**: *Breaking the Waves* was a real opera, as opposed to a music-theater experiment, with a moving plot and fine libretto (both very faithful to the film), a superior musical cast and a clever production.


## What do you think constitutes an award-worthy new opera?

**Ross**: I can't really isolate a set of characteristics. Opera and music theatre have progressed to the point where one can't impose rules or arrive with definite expectations. But of course you have to be gripped all the way through. There should be a feeling of experiencing something new, something unexpected and perhaps unsettling.

**Waleson**: Compelling theater that is driven by music.  Many new operas get bogged down in text, so the music is secondary; in *Breaking the Waves*, a excellent, very spare text served as inspiration for really original music. 

**Rockwell**: As to what constitutes an award-winning opera, however, I was equally taken by our two runners-up, *Fellow Travelers* and *anatomy theater*. So whatever works on stage counts most of all.

**Arthur Kaptainis**: I believe strongly that the MCANA award should stress music as an organic element of opera. It is possible to create a reasonably effective stage drama with declamatory vocal lines and generic instrumental support. Opera, however, should be more than this.

<figure data-type="image">{{% md %}}<figpcaption></figcaption>
</figure>

## In which cities and companies do you see promising work being done to foster new opera?

**Ross**: New York and Los Angeles seem particularly significant right now for density of activity, but companies and groups all over have made significant contributions: San Francisco/Oakland, Philadelphia, Houston, Dallas/Fort Worth, Cincinnati, St Louis all come to mind. Contemporary opera doesn't require vast resources on the scale of the Met: just a few singers and musicians can suffice to create a world.

**Rockwell**: There are interesting smaller companies in many cities, especially NY, where I live. Some of the big companies ([San Francisco Opera](/scene/companies/san-francisco-opera/), Fort Worth, though they fired their innovator, even the oversized [Met](/scene/companies/the-metropolitan-opera/)) and festivals ([Santa Fe](/scene/companies/the-santa-fe-opera/), Spoleto USA) try, but innovation is easy on a smaller scale (cf. [Beth Morrison Projects](http://www.bethmorrisonprojects.org/), now active in several cities). Which in turn is redefining the operatic experience.

**Waleson**: There has been an explosion of interest in new work in opera companies around the US.  
<ul class="nospace">
<li>[Opera Philadelphia](/scene/companies/opera-philadelphia/), of course – its composer-in-residence program is a model.  I'm certainly looking forward to the O17 Festival in September, which has FOUR new works, three of them world premieres.
<li>[Opera Theatre of Saint Louis](/scene/companies/opera-theatre-of-saint-louis/) has made an ongoing commitment to new operas, both commissioning them, choosing very modern subjects, and presenting revivals of important contemporary scores.  Considering that they do four operas a year, and at least one of them is new, it's a big deal.
<li>In New York, Beth Morrison Projects and the [Prototype Festival](http://prototypefestival.org/) are major creators and presenters of new work, and BMP's collaboration with LA Opera, to bring some of that work to the West Coast, is a great development.
<li>Also in LA is [The Industry](https://theindustryla.org/) – Yuval Sharon's *Hopscotch: An Opera in 24 Cars* was one of the most original things I've seen in years, making the city the theater.
<li>Spoleto Festival USA has brought some wonderful, unconventional things from Europe that we wouldn’t otherwise hear. This year's *Quartett* by Luigi Francesconi, for instance; it also did the world premiere of Huang Ruo's *Paradise Interrupted*.
<li>[Minnesota Opera](/scene/companies/minnesota-opera/) has been very active in commissioning and producing new operas over the last decade, although many of them are quite traditional in their execution and to me, less interesting overall.
<li>Fort Worth Opera was an important player; we’ll see what happens now that Darren Woods is gone.
<li>[Houston Grand Opera](/scene/companies/houston-grand-opera/) was the real pioneer under David Gockley; under Anthony Freud and his successor, the new work focus moved into the HGOCo sphere, which has produced some interesting pieces.
<li>Santa Fe Opera and San Francisco Opera have maintained their commitment to commissioning new works over the years, which has led to some important pieces. 
<li>Companies doing the occasional new work have come up with some great things. I loved *Everest* at [The Dallas Opera](/scene/companies/the-dallas-opera/) a few years ago; last summer's *Fellow Travelers* at the Cincinnati Opera was a revelation.
</ul>




