+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-04-10T22:38:00-04:00"
lastmod = "2015-04-10T22:38:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428719807440/RCM_Fotor.jpg.jpg"
publishDate = "2015-03-12T10:38:00-04:00"
related_articles = ["articles/entire-mfa-class-drops-out-of-usc.md","articles/wells-fargo-isnt-antiarts-everyone.md"]
short_description = "I&#039;m not saying that music degrees are a financial black hole, but they cost either as much or near as much as many science degrees. The disparity begs an unpopular question: is it ethical for universities to charge such similar tuition for a music degree as they do for a science degree?"
slug = "is-the-cost-of-a-music-degree-ethical"
title = "Is the Cost of a Music Degree Ethical?"
+++

<p>
	I loved my time in university. For the first time in my life, I was surrounded with everything I needed to do exactly what I wanted: make music, listen to music, scour libraries for music, nerd out about music. I even found like-minded friends, and our relationships grew out of our mutual love of our work. I still remember those inspiring times, even when I look back with exasperation on the disproportionate amount of training for the amount of payback (financial and otherwise). I've touched before on the topic of outdated curriculum for music students, and how the lack of emphasis on self-management and entrepreneurship puts music grads into trouble in the real world. But consider the savvy music student who really does know how to manage his own business and how to market himself. Consider that this student went to school in the United States, say, where an undergraduate degree can put 20-somethings into 6-figure debt. What are the chances that the student will make enough money to a) pay back their student loans in a reasonable amount of time, and b) have a comfortable life, family included, on top of that?
</p>
<p>
	<span class="s1">I'm not saying that music degrees are a financial black hole, but they cost either as much or near as much as many science degrees. The disparity begs an unpopular question: is it ethical for universities to charge such similar tuition for a music degree as they do for a science degree?</span>
</p>
<p>
	It's not difficult to collect information that proves that most <a href="http://work.chron.com/average-salary-musical-education-degree-20711.html" target="_blank">musicians</a> in <a href="http://www.canadianbusiness.com/companies-and-industries/canadas-best-jobs-2013-ranking/" target="_blank">Canada</a> and in the<a href="http://www.payscale.com/college-salary-report-2014/majors-that-pay-you-back" target="_blank">United States</a> are on the low end of the income scale, according to profession. Post-secondary education is expensive across the board, but with an entire generation under the weight of huge student loans, shouldn't there be some consideration of the graduate's income potential when calculating tuition fees? Tuition for the <a href="http://www.msmnyc.edu/Admissions/Tuition-Fees" target="_blank">Manhattan School of Music</a>and <a href="http://www.juilliard.edu/apply-audition/tuition-fees-and-expenses" target="_blank">The Juilliard School</a> are similar, just under $40,000 a year, similar to tuition at <a href="http://students.rice.edu/students/Tuition_Fees.asp" target="_blank">Rice University</a>. <a href="http://new.oberlin.edu/conservatory/admissions/finances/usa-students.dot" target="_blank">Oberlin College Conservatory</a> sits at ~$48,000 for most degrees. In Canada, it's a bit better (including significantly lower tuition in general); the tuition costs for music degrees are about 40% less than engineering at the <a href="http://www.provost.utoronto.ca/link/students/fees15/dom_music.htm" target="_blank">University of Toronto</a> and <a href="http://www.registrar.uwo.ca/student_finances/fees_refunds/pdfs%20fee%20schedule%20/Fall%20Winter%202014-2015%20UGRD%20fee%20schedule%20CDN.pdf" target="_blank">Western University</a>, but a music undergrad will still pay about the same as most science undergrads.
</p>
<figure data-type="quote" class="wy-figure-left">
<blockquote>
	<span rel="line-height: 24px;" style="line-height: 24px;">When there's job insecurity for nurses, teachers, and government works, taking on the added insecurity of a career in the arts could seem a bit masochistic.</span><br>
	
</blockquote>
</figure>
<p>
	I also know that it comes down to the business of universities. An academic institution has a right to charge their tuition costs, especially if they're privately run. I'm not equipped to argue how these universities use the tuition fees they get from students, and I'm sure that no matter what the cost of education is, we'd all find something to raise an eyebrow at in the universities' financial reports. Neither am I hoping to deter young musicians from pursuing post-secondary education, because these institutions really are where we can find the best education. Likely, there are a few exceptions, some hidden gem-type teachers who work privately. But through a conservatory or a university, students can work with people like Martin Katz, Cesar Ulloa, Warren Jones, Marlena Malas, Michael McMahon, and Marilyn Horne. People of this calibre are objectively great teachers, and they also expose students to their professional circle; this is the golden combination for a student who wants to become a pro.
</p>
<p>
	It's also true that musicians aren't the only kind of young professionals hurt by tuition costs (student loans, really). I think young people are aware and outraged about it, and pursuing higher education in music may fall farther down on the list of practical options. When there's job insecurity for nurses, teachers, and government works, taking on the added insecurity of a career in the arts could seem a bit masochistic.
</p>
<p>
	For all I know, these tuition costs are flat-out, no-questions-asked, the real number of dollars it costs to give a student an education; that cost is one of the reasons that artists are always, rightly, pushing for better government funding for the arts. If the price of an education simply can't be lowered, that I think there's at least a responsibility on the administration to create courses for music students that are highly practical and connected with professional circles that matter. Without these things, it's not going to help young people start small businesses (themselves) and start contributing to the real workforce. That, I think, would be unethical.
</p>
