+++
author = ["authors/jenna.md"]
date = "2015-10-19T12:54:00-04:00"
lastmod = "2015-10-25T10:31:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445562263013/RobotSinging.jpg.jpg"
publishDate = "2015-10-25T10:31:00-04:00"
related_articles = ["articles/online-music-is-obscuring-opera.md","articles/netflix-why-not-opera.md","articles/tapestry-operas-selfie-talks-online-bullying.md","articles/childfree-opera-singers-happiness.md"]
short_description = "As technology develops and more and more of our problems are solved, creators of opera will be charged with finding truer and truer ways of getting to emotional heights. The challenge comes in the form of a question: now that you have the Internet in your pocket, what&#039;s left to sing about?"
slug = "is-technology-making-it-harder-to-tell-stories"
title = "Is technology making it harder to tell stories?"
+++

I was listening to a filmmaker, Harmony Korine (*Spring Breakers*, *Kids*) talk about coming up with original stories, and he made one interesting point about why it seems more and more difficult: technology is taking away the opportunity for drama.

That's a biggie for opera, where every emotional state and difficult decision is heightened by the music. Think about the best scenes in opera: they all have to do with love, which is predictable and timeless enough - the technology problem lies not in these grand emotional states, but in these love-struck characters' actions. Someone is always singing about missing a loved one, worrying about a loved one, writing a letter to a loved one, being reunited with their love, and so on *ad nauseam*. Timeless as these feelings may be, if these stories take place in the age of smartphones, a lot of this action becomes redundant and unrealistic. There's a saying, about how opera tells the story of a person on either the best or worst day of his or her life; as technology develops, more and more of our problems are solved, and it can dilute a story's affect.

Take *Il barbiere di Siviglia*: if it took place in Seville, 2015, there would be no window serenades, no breaking-and-entering or pretending to be singing teachers. Almaviva would be texting Rosina, we wouldn't see the drunk-soldier scene *or* the "Don Alonso" scene, and the only real need for Figaro would be to get the keys and help them all escape Bartolo. *Falstaff* would be all texting, too, Alice and the women exchanging screenshots of Falstaff's ridiculous booty call messages. Any time a character is in disguise (*Le nozze di Figaro*, for example), the contemporary equivalent is texting from someone else's phone, or from some fake account they set up for their web of lies. Arias about being far away from loved ones might be a little dampened in a world where it's easy to communicate; in *Carmen*, perhaps things between Don José and Micaëla would be different.

Even *L'elisir d'amore* would be cut short if it were set today; small town or not, someone would have the sense to Google Dulcamara, or see if there are any product reviews for his "elixir". And in *Don Pasquale*, Malatesta could just search Facebook for someone that looks *sort of* like Norina, and show it to Pasquale; no need for a whole descriptive aria when a photo will do.

The ritualistic act of writing a letter, like in *Eugene Onegin* or *Werther*, would be different, too; the sentiments may still be there, as someone writes a difficult email (who hasn't been there?), but it's a different thing to write knowing it will get read really quickly, and that person can write you back knowing *you'll* read it, and so on. Complicated, but then again, so are opera plots. The problem is that these neuroses about online communication are very internal, and and an internal kind of drama that's hard to tell in a theatrical setting. I'm imagining a Verdian *scena* about a woman who has laid her heart out to someone in a Facebook message, and although she is sure that someone has "seen" her confessions of love, she awaits reply; that sort of scene isn't quite the same as the opening of Act II of *Madama Butterfly* (but, I would love to see it). That scene, played out in reality, would be a woman going about her usual business, stealthily checking her phone at regular intervals. 

The whole thing raises an interesting question. Is it opera's responsibility to depict the "realistic"? Historically, that's never really happened anyway, since opera depends on a fair amount of suspended disbelief. Opera expands on our emotional states, and those are slower to wash away than our dependence on pen and parchment. I do think that the problems solved by smartphones are something to think about when updating productions. It's an argument for a "traditional" telling of operas, since keeping the story in a world without technology (long ago, magical, eg.) is an easy way to avoid getting caught in awkward corners ("why didn't he just text her?").

I think it will push us to create better stories, frankly. The real stuff of opera, the human highs and lows and the slowing down to savour what those extremes feel like, is what remains constant in all of our stories. Feeling rejection, loss, lust, joy, these things of course still happen to us. As technology develops and more and more of our problems are solved, creators of opera will be charged with finding truer and truer ways of getting to emotional heights. 

The challenge comes in the form of a question: now that you have the Internet in your pocket, what's left to sing about?
