+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-04-22T09:55:00-04:00"
lastmod = "2015-04-25T15:12:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429716532027/Opera_Copenhagen_02.jpg.jpg"
primary_image_credit = "Photo: henninglarsen.com"
publishDate = "2015-04-22T11:00:00-04:00"
related_articles = []
related_companies = ["scene/companies/opera-philadelphia.md"]
related_people = ["scene/people/eric-owens.md"]
short_description = "You might have read the recent interview in *The Courrier-Journal* with Eric Owens and Morris Robinson, who sing King Philip II and the Grand Inquisitor in Opera Philadelphia&#039;s upcoming Don Carlo. Mike Silverman asks them about the &quot;challenges of being a black opera singer.&quot; It struck me, though, that while barriers like race have dissipated quickly, an opera career can still be contingent on a few factors, many of which fall under &quot;luck of the draw.&quot;"
slug = "is-opera-really-for-everyone"
title = "Is opera really for everyone?"
+++

You might have read the recent [interview](http://www.courier-journal.com/story/entertainment/arts/music/2015/04/20/challenges-black-opera-singers/26096103/) in *The Courrier-Journal* with Eric Owens and Morris Robinson, who sing King Philip II and the Grand Inquisitor in Opera Philadelphia's upcoming [*Don Carlo*](https://www.operaphila.org/whats-on/on-stage-2014-2015/don-carlo/). Mike Silverman asks them about the "challenges of being a black opera singer."

Times are admittedly changing within the opera world, and it's not difficult to find successful black opera singers, at least in North America. When asked about their being role models for aspiring black singers, Robinson responded, "I think we give hope to a lot of cats who are in school studying, who look like us and pursue this career and don't see very many examples."

I think it's fair to say that with all the white Aidas who have ever graced the opera stage, it's not a relevant conversation to discuss the "accuracy" of having a black singer portray a character like King Philip II. I think having a cast of singers that mirrors our diverse population is one of the ways that opera will maintain its spot among the living arts.

It struck me, though, that while barriers like race have dissipated quickly, an opera career can still be contingent on a few factors, many of which fall under "luck of the draw."

Take Robinson's answer about being role models; he's completely right, but there's a catch. Those aspiring singers have to see him and Eric Owens in action in order to be inspired.

Exposing people to opera has everything to do with getting them when they're young. I've done several school tours with the Canadian Opera Company, and we visit over 30 schools to present what's often the first opera these kids have seen. I love how young audiences react to live music and theatre, but their singular experience with opera isn't enough for kids to form a connection with the art form.

After each show on our school tours, we answer questions from the kids in the audiences. A common question is some variance of, "How can I do what you guys do?" We answer truthfully, but incompletely. We tell them that learning to sing or play the piano is like training for a marathon; small distances eventually lead to long distances, and you slowly push the limits of your body.

All this is true, but I doubt I'm the only one among my colleagues who knows that mastering vocal technique is only applicable if a few other important steps are in place, too.

I wasn't one of those kids who saw That One Concert, the one that instantly solidified in me a love of music. That love was slowly fostered over almost two decades, by going to hear show after show and being involved in everything from choirs to piano lessons to clarinet quartets. My parents were models of perseverance; they continued taking me to my lessons without hesitation, often simply because I didn't ask them to stop. My mother was smart. She figured, since I wasn't complaining, that I may as well take auxiliary courses like theory and history, along with my piano and clarinet lessons.

So, take the child living in a low-income family, in a place far away from major cultural centres. What if his parents don't have a connection to music or theatre? What if they have no way of seeing the benefit of music lessons in their child's development? What if they do, but can't afford to buy them an instrument, let alone send them for lessons? What if there aren't any music teachers where they live?

If at school one day that child sees an opera, or something similar, what can come of his excitement?

I say all this to make the point that inspiration is a vital, yet small piece of the puzzle. At the early stages of music development, quantity of exposure and opportunities is where it's at. There are a few hurdles along the path to an operatic career, and one of them used to be race. The money hurdle is still there, constantly in the way.

In the mid-20th century, The Metropolitan Opera was a place where black opera singers had the chance to show that they were not only onstage, but they deserved to be up there in the spotlight. It was a step that led to Eric Owens and Morris Robinson sharing a stage in *Don Carlo*. What can be done about the problem of income and class? I won't look first to the Met to start that ball rolling...

Kids recognize this in the athletes they idolize; they're familiar with the system of training (and money) that goes into being a runner or tennis player. I suppose the difference between athletes and opera singers is that kids have probably seen less of the latter.

I think it's another argument for nomadic opera companies, for touring shows and pared down productions in venues that don't come with associations of the ultra-wealthy. Quantity, like I said, is the best approach for young people, and not only because they'll hear more music. They'll see more performers, too. They'll see them as a population of people, like an slice of society, and perhaps more kids will recognize that these singers and players are not superhuman.

When it comes to showing young music-lovers that their passion can become their paycheque, I think it's important to prove that the role models they meet are not exceptions to the rule. 


