+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-05-11T19:34:00+01:00"
lastmod = "2016-05-12T12:37:00+01:00"
preamble = "Photo: [Nicholas Huk](https://www.flickr.com/photos/128359034@N07/17233058042) on [Flickr](https://creativecommons.org/licenses/by/2.0/)"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463052389558/2016-05-12---Moving.jpg.jpg"
publishDate = "2016-05-12T12:35:00+01:00"
related_articles = ["articles/the-case-for-nomadic-opera.md","articles/the-future-of-opera-is-indie.md","articles/yannick-nezet-seguin-musicals-and-great-timing.md","articles/new-opera-honest-marketing.md","articles/teddy-roosevelt-the-chicago-cubs-operas-by-women-at-the-met.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/indie-opera-to.md"]
short_description = "It would be decidedly difficult for the Met as a company to wriggle free from the Met as a building. They&#039;re absolutely one and the same, especially for the new audiences, who are being courted while loyal subscribers grow older, and single-ticket buyers become more important sales targets. For these new people that the Met wants in their seats, the experience of going to that building is as much a part of the evening as the show itself."
slug = "is-it-time-for-the-met-to-move"
title = "Is it time for the Met to move?"
+++

The recent news of [The Metropolitan Opera's low box office sales](http://www.nytimes.com/2016/05/07/arts/music/metropolitan-opera-faces-a-slide-in-box-office-revenues.html) is equal parts surprising, and not surprising. This season, the Met's potential ticket revenues are projected to be at 66%, the lowest rate yet. Season subscription purchases are down, but general manager Peter Gelb told the *New York Times* that the Met did sell tickets to 74,000 new buyers. 

Zachary Woolfe, Anthony Tommasini, Michael Cooper, Corrina da Foncesa-Wollheim, and David Allen all offered up some [possible solutions](http://www.nytimes.com/2016/05/08/arts/music/the-met-opera-is-struggling-how-can-it-fill-those-empty-seats.html) to the Met's dwindling ticket sales: putting up more diverse repertoire, courting young audiences, holding black-tie nights, employing artists-in-residence, cutting down longer operas, and having shows on Sundays are all good ideas (that last one especially - we still can't believe that Sundays are dark at the Met).

But one paragraph stood out from the *New York Times*' article:

"Even in a rough season the Met will have sold about 660,500 opera tickets, more than almost any of its peers globally. Met sales averaged 2,869 seats per performance, which would have overflowed the Royal Opera House in London (2,256 seats), or the Vienna State Opera, (2,284 seats). Last season, the nearly-sold-out Vienna company had sales of 462,901 opera tickets; 421,100 people attended operas in 2014 at the Paris Opera."

The Met has a capacity of 3800, and it puts on over 200 performances of about 25 operas per season. So, we have to ask: is it that ridiculous to suggest that the Met's supply and demand balance is simply out of whack? We're not talking about the demand specifically for the Met; it's now the norm for companies to deal with industry-wide belt-tightening, as they recognize that opera in its traditional form no longer "sells itself". 

The Met is one of those Big American Things, boasting size alongside its decidedly top-notch roster of artists. So, we were certainly surprised to see 26 operas on the calendar for 2016/17. Twenty-six! Plus, special events like the 50th Anniversary Gala, the National Council Auditions, and Kathleen Battle's anticipated recital-as-homecoming. This, after a year of financial struggles, messy union negotiations, and the need for those aforementioned tightened belts.

One can only give the benefit of the doubt to the Met, and assume that the math doesn't allow for simply decreasing the number of productions and performances. It's likely that this "25-ish shows, 200+ performances" is the sweet spot between costs and potential ticket revenue. But when the average ticket price is around $160, and selling an average of almost 2900 seats per show only fills the house by two-thirds, perhaps we should start talking seriously about how the opera house *itself* is the problem.

[We've written before](/the-case-for-nomadic-opera/) about opera companies and their real estate. For companies in their infancy, permanent performance venues are a laughable luxury that no one expects to afford within their first decade of existence. These young companies are working *with* their limitations, using the novelty of new and unorthodox performance venues as part of the appeal of their productions.

It would be decidedly difficult for the Met as a company to wriggle free from the Met as a building. They're absolutely one and the same, especially for the new audiences, who are being courted while loyal subscribers grow older, and single-ticket buyers become more important sales targets. For these new people that the Met wants in their seats, the experience of going to that building is as much a part of the evening as the show itself. For some, it's impressive and exciting and fancy; for others, it's a complete turn-off that means something like, "go sit in the dark and watch something unfamiliar." 

That latter group shouldn't be a problem for a company like the Met; Peter Gelb wants the work onstage to be what's impressive, and he's not relying on the grandeur of the historical opera house to lure audiences back. We're not naïve enough to suggest that ego is the only thing standing in the way of the Met's transferring a number of its productions elsewhere in New York, placing its world-class artists in museums, bars, black-box theatres, basically anywhere that's cheaper than their current home. If the Met is about the art it creates, a change of scenery shouldn't be out of the question. But perhaps it's an embarrassing possibility to entertain.

It's also important to know *why* younger audiences aren't buying subscriptions. Firstly and obviously, it's too expensive. The North American 20- and 30-somethings of 2016 are not enjoying the same financial flexibility as those one or two generations ago. It's true that audiences can save money by buying a subscription, but here comes the bigger problem: these potential young audiences aren't sure that they'll like opera enough to go more than once. Why? Because they didn't grow up with Marilyn Horne on *Sesame Street*, or Plácido Domingo on Johnny Carson, or Bugs Bunny's operatic adventures, or even the *Lawrence Welk Show*. The arts struggle for a place in public schools, and young people weren't soaking up the sound of classical music passively from TV and radio.

And while a generation of potential opera lovers (and ticket buyers) missed the boat, ticket sales went up like the cost of everything else. Basically, the Met is now faced with teaching 30-year old dogs new tricks in the form of opera, and they need them to pay for a season's worth of said education.

Today, grandeur and fanciness are easier to find; there are stricter dress codes at New York nightclubs than at the Met, and pop concerts come with more exciting special effects and design than much of what opera can offer. The Met's real estate is beautiful and impressive, but so are museums, train stations, and even the offices of major tech companies. Everything that happens at the Met outside of the stage - the fountains, the red carpets, the chandeliers - is easy to find elsewhere, and for cheaper. What can't be replaced is the thrill of the human voice and live theatre. The Met has no shortage of excellent voices and thoughtful, exciting productions, and now it can look to other companies for assurance that these elements can and do trump luxury, especially for young people.

It's easy to suggest that the Met should close its Lincoln Center doors a few times a season, and once again go on tour, taking to smaller venues not only to cut costs, but to extend themselves outside of a single building and bring the excellent opera to the people who can't be lured downtown. But the cost of the building would still stand. Could it be rented out for more mainstream events, keeping the unions employed and the bills paid, while the Met puts up opera elsewhere? If the answer is yes, perhaps it's time for an experiment. If the answer is no, then the Met may pay the price, proportional to its size and influence, of society's letting more than one generation grow up without enough exposure to what opera has to offer.

>Thoughts, readers? Leave yours in the comments below!
