+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2020-08-18T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "This production of _La voix humaine_ will be available on [Helios Opera’s website](https://heliosopera.com/mop/lvh/) through September 25th. The initiative will also need help for funding: please consider giving a donation to [Helios Opera](https://heliosopera.com/mop/lvh/) to help this initiative thrive."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1597785858/media/2020/08/sqHO-Voixhumaine_hpieya.png"
primary_image_credit = "Théodora Cottarel as Elle in Adrienne Boris' production of Poulenc's La voix humaine by Modular Opera Project. Photo: Julien Rohel. "
related_articles = ["articles/voix-humaine.md"]
related_companies = ["scene/companies/helios-opera.md"]
related_people = ["scene/people/theodora-cottarel.md"]
short_description = "How do you stage something that is so static in tableau and also has so few characters? And more to the point, how does a company stage it in a time when theaters are closed due to the COVID-19 pandemic?"
slug = "intimate-voix-humaine-provides-a-way-forward"
title = "Intimate Voix humaine provides a way forward"
youtube_url = ""

+++
Francis Poulenc's _La voix humaine_ provides a very interesting artistic challenge for anyone that decides to stage it: it is written for only a single character, a character from whom we only ever get to hear one side of her conversations. How do you stage something that is so static in tableau and also has so few characters? And more to the point, how does a company stage it in a time when theaters are closed due to the COVID-19 pandemic?

You bring it home and film it, of course. At least, that is the solution that [Helios Opera](/scene/companies/helios-opera/) has taken, in the first of what will hopefully become a series in its Modular Opera Project initiative. It is no doubt a massive logistical nightmare to attempt staging an entire full length opera where all of its moving parts cannot even rehearse in person, and no doubt it is a difficult enterprise. The fact that this production came off with almost no seams to show for it is a testament to the strength of what Helios Opera has learned in the process, and it provides a window into a thrilling way to deliver new opera productions in these times.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1597785871/media/2020/08/HO-Voixhumaine-1_t74a8m.png){{% /md %}}

</figure>

For one, it is quite well shot, and its choices of shot did a wonderful job of highlighting soprano [Théodora Cottarel](/scene/people/theodora-cottarel/)'s electrifying performance as Elle, the sole character we see throughout the show. Cottarel acted her part gloriously well, conveying so much information about the way her moods swung throughout the performance with even just the slightest twitch of her brow that it really only amplified the moods Poulenc conjured in his score. Her singing voice, too, was absolutely perfect for _Voix humaine_, and the way she maintained a beauty of tone through much of Poulenc's heavily recitative-like writing for the character while also finding great ways to color the characters' neuroses was masterful. But the closeness the camera brought to the whole enterprise brought an almost intimate air to the performance, and the emotions were as grand as they were immediate, something I have no doubt would be lost on the opera stage.

> I have to admit that I saw much almost too much of my own mental health during quarantine in Elle's frequent, sudden, and often titanic mood swings.

For another thing, it pretty much kept Poulenc's score intact, albeit in piano reduction form owing to the difficulty of putting together a whole orchestra in these circumstances. This admittedly was something that made me nervous going into the broadcast, but Poulenc's score lost none of what makes it great even in this format. I admit to not being familiar with _Voix humaine_ before this performance, but if anything, having it pared down to just the piano highlighted how adeptly Poulenc paints his character's mood swings throughout the opera's 55-minute runtime. It was also synced and edited together so smoothly that I completely forgot that collaborative pianist Celeste Marie Johnson had not even rehearsed the piece with Cottarel in the room, and there was surprisingly little sound quality lost in the edit to bring it to this format.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1597785890/media/2020/08/HO-Voixhumaine-3_vzpxxp.png){{% /md %}}

</figure>

And finally, I cannot think of a more thematically fitting opera to kickstart such a project than _Voix humaine_, in which Elle slowly breaks down across the entire runtime while leaning into a phone. It acts as a haunting microcosm of quarantine life throughout the pandemic, with the smartphone being a scarcely suitable substitute for in-person interaction that Elle--and the world, during quarantine--nevertheless clings to as if it’s the only thing keeping her afloat while her world is crumbling around her. The prescience here is absolutely uncanny, and I have to admit that I saw much almost too much of my own mental health during quarantine in Elle's frequent, sudden, and often titanic mood swings.

Poulenc most likely did not have a global pandemic in mind when he and Jean Cocteau created _La voix humaine_, but presenting it in this format brings to the fore just how relevant the opera is, even if a few lines of libretto had to be edited somewhat to update the story for modern technology.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1597785904/media/2020/08/HO-Voixhumaine-4_oocgzc.png){{% /md %}}

</figure>

In short, this "pilot" is a slice of what director Adrienne Boris hopes will become a series of home-brewed productions filmed at home. If this production is an indication of what's to come, then I can't wait to see what comes next from this little series that could. If nothing else, it provides a solution to the issue of how people would perform opera in a time where it may not necessarily be safe to perform opera live in a theater, and it is a solution that  I can't wait to see applied to more operas.