+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2018-04-13T15:27:00-04:00"
lastmod = "2018-04-14T16:29:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523647099530/sq---BosOpColBoheme041018-0168.jpg.jpg"
primary_image_credit = "Francis Rogers and Celeste Godin in La bohème, Boston Opera Collaborative, 2018. Photo courtesy of Boston Opera Collaborative."
publishDate = "2018-04-14T16:29:00-04:00"
short_description = "But actually, this is the big revelation of the production: the show works better when the cast is allowed to treat the show&#039;s lighter moments like a comedy, because it only highlights how truly tragic their situation is when reality comes crashing back in. "
slug = "intimate-brewery-room-la-bohme-a-revelatory-triumph"
title = "Intimate Brewery Room La Bohème A Revelatory Triumph"
+++

One of the great challenges of the opera world is constantly finding new ways to stage classics of the repertory. Poor Giacomo Puccini has been one of the greatest victims of this tendency of the opera world, and *La Bohème* perhaps has it the hardest of all his works: there's hardly anyone you can talk to in the world who isn't familiar with *La Bohème* or its modern-day recasting in *Rent*, and because of this staging the work in a new way is almost impossible. It is perhaps to the opera-lover's great relief, then, that the Boston Opera Collaborative has found a new way to stage the work by demolishing the distance between the audience and the action that breathes new life into the opera.

BOC staged [their take on *La Bohème*](https://www.bostonoperacollaborative.org/la-boheme) inside the brewery room of Turtle Swamp Brewing in Jamaica Plain, which also provided free beers to the opera patrons. (Full disclosure: I did not partake in these beers.) At first, one would think that the choice of a brewing company is an odd one in which to stage an opera. However, as I was walking to the performance venue from the Green Street T stop, it sort of hit me that it's almost the perfect space to perform a work about artists living in poverty: TSB is nestled in a not particularly well-kept part of town, and this fit right in with the production's updating to Jamaica Plain.

It also makes sense from the standpoint of bringing the audience almost painfully close to the action. The fact that all of the seating was done on foldable chairs allowed the production to experiment with seating arrangements, which changed throughout the production. Act II was probably the best, if most obvious, example of this: the performance area was arranged so that the audience was seated at a bunch of café tables (complete with bowls of pretzels for the audience to munch on), and the fourth wall break was delightful to witness as Musetta flirted with audience members throughout the Waltz. But even in the only slightly more conventional square-in-the-square seating the rest of the acts employed, it essentially eliminated any place for the singers — and the production — to hide.

The effect was to increase the importance of the performances and of the details in the production. Here, stage director Greg Smucker delivered in spades, peppering his production with lots of clever details that informed character in really interesting ways. For instance, Rodolfo kept his poetry in an old Amazon box that he left by his bed. This led to a wonderful moment of characterization after he took this box out to show Mimi his poetry partway through "Che gelida manina": Mimì picked up one of the books, and the way she looked through it as Rodolfo told her about himself was a nice, subtle way to increase the chemistry between them. 

The entire production is full of brilliant little touches like this, from Marcello's angry munching on chicken wings throughout Musetta's Waltz to the way the lights flickered off during the landlord Benoit's short scene. The attention to the chemistry between the characters was also wonderful to watch. Here, there's no shortage of examples to pick from: the flat mates' banter throughout the opera felt real and funny, Musetta and Marcello's connection was fun and tempestuous in the right ways, and there was a magic to Mimì and Rodolfo falling in love that transcended the playful flirtation surrounding the key she loses in Rodolfo's flat.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523647508513/BosOpColBoheme041018-0108.jpg.jpg)
<figcaption>(l-r) Francis Rogers, Mitch FitzDaniel, Andrew Miller, Scott Ballantine, and Seth Grondin in *La bohème*, Boston Opera Collaborative, 2018. Photo courtesy of Boston Opera Collaborative.</figcaption>
</figure>

The production was also incredibly light on its feet, and there was no shortage of laughs, many of which came from the flat mates’ banter and from Musetta's flirtations. In fact, as the show wore on, I admittedly started to worry that the humor that Smucker had wrangled out of *La Bohème*'s lighter material would dilute the tragedy that practically everyone who knows this opera knows is coming. But actually, this is the big revelation of the production: the show works better when the cast is allowed to treat the show's lighter moments like a comedy, because it only highlights how truly tragic their situation is when reality comes crashing back in. 

Nowhere was this more apparent than when Musetta came onstage in Act IV to tell the bohemians that Mimì was dying. In this production, she interrupts what is essentially a mock lightsaber battle, and while it was admittedly helped by the set design (which kept her completely out of the audience's sight until she parted the curtain that served as the doorway to the flat) her arrival sucked the air out of the room, and the resulting events were almost made more tragic because of how much joy we had seen these characters inhabit all throughout the rest of the opera. 

Ultimately, I doubt the effect would have been as strong had we not seen these characters in their more joyful, exuberant moments, and the fact they were allowed to wrangle laughs from the audience only helped increase the story's stakes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523647500845/BosOpColBoheme041018-0182.jpg.jpg)
<figcaption>Scott Ballantine and Carina DiGianfilippo in *La bohème*, Boston Opera Collaborative, 2018. Photo courtesy of Boston Opera Collaborative.</figcaption>
</figure>

It also has the strange side effect of highlighting the score. Here, the production was admittedly helped by an extreme reduction by Mathieu D'Ordine that takes the lush original orchestration and whittles it down to seven players, but the attention to detail in the performances also helped remove a lot of the frills and excesses that singers sometimes indulge in performing Puccini. The result was that the show's already luscious and irresistible music gained a dramatic urgency that most productions lose. This clarification of the musical materials only added a laser-sharp focus that the rest of the production already had, and it was very interesting to hear Puccini's music performed this well.

It should be apparent that the young, up-and-coming singer-actors who ran around Turtle Swamp Brewing were all outstanding, or else none of the above points about the production could have been made in as glowing a light as I have noted here. However, it is difficult to adequately state just how good the entire cast worked as a whole, where no one person from the six lead characters managed to overshadow the others in terms of singing skill and acting chops. 

Francis Rogers made for a warm, soulful Rodolfo, whose acting chops were on par with a luscious tenor voice that stole the show every time he opened his mouth. Celeste Godin was every bit his match as Mimì, providing a dynamic but appropriately frail voice to her portrayal as the meek, well-natured heroine of the story. Andrew Miller made for a robust Marcello whose warm voice complemented the cast quite well, and Carina DiGianfilippo's Musetta traversed the stage with a voice as playful and sharp as her mannerisms. Rounding out this excellent cast was Mitch FitzDaniel's wonderfully pathetic Schaunard, and Seth Grondin's stoic Colline was a good counterpoint to his roommates backed by a lovely voice.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523647485807/BosOpColBoheme041018-0324.jpg.jpg)
<figcaption>Francis Rogers and Celeste Godin in *La bohème*, Boston Opera Collaborative, 2018. Photo courtesy of Boston Opera Collaborative.</figcaption>
</figure>

Any issues with the performance essentially came down to nitpicking. The placement of the orchestra above the action did not cover the singers as I feared they would, but they did lead to a few coordination issues between the orchestra and the singers. Even those are not a huge deal, however, as the small ensemble showed excellent ability to get back on track. I also felt that the staging of Act II, while effective, was almost too chaotic for some audience members to successfully keep track of the action, and I have a feeling that it's unfortunately all too endemic to how the seating worked.

Greg Smucker mentions in his notes in the program that he did not truly fall in love with opera as an art form until he was a graduate student studying with Wesley Balk: he stated that this production was one way to share how he felt when he worked with singer-actors up close. His staging of this opera in Turtle Swamp Brewing is a testament to that credo, as the intimacy really went a long way in emphasizing the performances of the singer-actors, and also the drama of the score. 

It should say something about how powerful the production was that the boisterous laughter of a few rowdy patrons in the bar area outside of the performance space could not break the spell that the production cast after the show's devastating dénouement had run its course: this is a *La Bohème* for the ages, and I think other production companies will be hard-pressed to match the Boston Opera Collaborative when it comes to staging Puccini's classic.
***
NOTE: This production of [*La Bohème*](https://www.bostonoperacollaborative.org/la-boheme) is double-cast. This review reflects the cast that sang on April 12th, which will sing again on the 14th, 18th, 20th, and 22nd.

