+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-11-27T21:30:00-05:00"
lastmod = "2015-11-27T23:00:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448681587859/2015-11-28---Instrumentalists.jpg.jpg"
publishDate = "2015-11-28T09:00:00-05:00"
related_articles = ["articles/putting-on-show-instrumentalists.md","articles/6-animals-who-love-opera-more-than-penguins.md","articles/great-love-affairs-singers-and-pianists.md","articles/artists-to-watch-teng-li.md"]
short_description = "Something that young instrumentalists hear for much of their training is that they&#039;re not &quot;singing&quot; enough. It can be confusing, because no, they&#039;re not singing at all. They&#039;re dragging bow hairs across strings, plunking keys downwards, maybe even using their own air supply to make sound; but they&#039;re not quite singing."
slug = "instruments-can-sing-too"
title = "Instruments can sing, too"
+++

Something that young instrumentalists hear for much of their training is that they're not "singing" enough. It can be confusing, because no, they're not singing at all. They're dragging bow hairs across strings, plunking down keys, maybe even using their own air supply to make sound; but they're not quite singing. 

It's one of those vague, metaphorical directions that sounds pointless until it clicks. Instruments really are trying to imitate a voice, and it's not because singers are at the top of some musical sound pyramid. It's because our throats are our most natural musical instrument, and we've evolved to respond to the idiosyncrasies of the human voice. Today, instrumentalists make their own vibrato to imitate that which comes naturally to singers; even pianists learn to recreate a legato touch, despite the fact that the piano can't actually connect two notes together.

The great violinists, pianists, cellists, accordionists, they all know that to really play their instruments is to sing with them. But here are a few examples of singing with a bow, or with a keyboard; it's pretty thrilling to hear.

## Chanting cello

Perhaps it's almost too obvious, but Yo-Yo Ma is a perfect example. The old saying is that the cello is the closest in sound to the human voice. Have a listen to this performance of him playing Saint-Saëns' *The Swan* (*Carnaval of the Animals*), and you tell us:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/zNbXuFBjncw" frameborder="0" allowfullscreen></iframe>
</figure>

## Vocal violin

Considering he never wrote an opera (I suppose the closest he came was his *Ein deutsches Requiem*), Brahms writes some of the most beautiful, singable melodies in chamber music. Here's Itzhak Perlman and Daniel Barenboim playing the second movement from Brahms' D Minor Violin Sonata. Without fail, it grabs me by the second bar - and talk about singing with your instruments:

<figure data-type="video"><iframe width="854" height="480" src="https://www.youtube.com/embed/-L5nSwAND3Y" frameborder="0" allowfullscreen></iframe>
</figure>

## Crooning keyboard

Leave it to Barenboim to sing at the piano, even in that singer's beloved nemesis, J.S. Bach. This his him playing the Aria from Bach's *Goldberg Variations*; listen how he tapers away at the ends of phrases, like a singer would do. It takes a lot of care, and a bit of smoke and mirrors. (The basic concept: play a note, listen to how fast the sound is decaying, and then play the next note at a volume that matches that of the decaying note. Done right, it sounds like there's no attack on the second note, creating a diminuendo.) Listen:

<figure data-type="video"><iframe width="854" height="480" src="https://www.youtube.com/embed/AcXXkcZ2jWM" frameborder="0" allowfullscreen></iframe>
</figure>

## Belting bonus

Now, an obvious parting choice would be a Chopin Nocturne (like [Ashkenazy's playing of Op. 9 no. 2](https://www.youtube.com/watch?v=AG-OQNXQxYg)). But I'm a lover of the underdog, so here's some more Brahms. Emil Gilels plays the second movement of his First Piano Concerto; I think it's one of the most stunning piano entrances in the rep, and there's some serious singing to be heard (start at ~1:30 if you're impatient).

<figure data-type="video"><iframe width="854" height="480" src="https://www.youtube.com/embed/L5XtH3gq1a4" frameborder="0" allowfullscreen></iframe>
</figure>

>Who are your favourite non-singing singers? Let us know in the comments below!
