+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2021-10-24T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1635099637/media/2021/10/sqMassOpera_Traviata_Fourth_159_rey5fy.jpg"
primary_image_credit = "David Bozón as Alfredo Germont in La traviata, MassOpera, 2021. Photo: Nile Scott Studios."
related_articles = ["articles/in-review-la-traviata-at-the-coc.md", "articles/a-parisian-traviata-spectacle.md"]
related_companies = ["scene/companies/massopera.md"]
related_people = []
short_description = "La traviata hosts what is probably opera's most well-beloved idiot plot: all of the characters make some fairly idiotic choices for the plot to progress as it does, and some characters can really come off as extremely unlikable as a result."
slug = "installation-la-traviata-intimate-and-effective-production"
title = "Installation La traviata intimate and effective production"
youtube_url = ""

+++
_La traviata_ is often hailed as a classic of the operatic repertory, but I personally have always had a rather distant relationship with it. A part of that is the fact that it is very much from Verdi's early bel canto phase, and while it does leave those stylings behind in some ways as the opera progresses the tropes of the genre do still trap the opera, as they do in so much of Verdi's earlier work.

But the bigger part for me is that _La traviata_ hosts what is probably opera's most well-beloved idiot plot: all of the characters make some fairly idiotic choices for the plot to progress as it does, and some characters can really come off as extremely unlikable as a result. Thus, for a production of _Traviata_ to grab me, the production has to pull some major gymnastics in order for me to get past both of these things.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1635099814/media/2021/10/MassOpera_Traviata_Fourth_024_fg4p2h.jpg){{% /md %}}

<figcaption>Alisa Cassola as Violetta Valéry and David Bozón as Alfredo Germont in La traviata, MassOpera, 2021. Photo: Nile Scott Studios.</figcaption>

</figure>

Enter [MassOpera](/scene/companies/massopera/), which has been mulling over this opera for about two years in large part due to the COVID-19 pandemic. [This production](https://massopera.org/events/la-traviata/) went through a few iterations, and finally, the version they have settled on involved massively reworking the opera from top to bottom: they cut an hour of material, they reduced the orchestration to a form playable by no more than four instrumentalists at a time, the chorus was reduced to a small ensemble that also doubled a few of the smaller roles throughout the opera, and the audience was restricted to just twenty-five people.

But perhaps the main draw of this production was the choice of venue: this production was staged on the grounds of the Eustis Estate just outside the city limits of Boston, and it took a few cues from the well-known theater production _Sleep No More_ in that it asked the audience to move throughout the house as the show progressed. I was quite looking forward to seeing what _La traviata_ would look like in such a format, and I am pleased to say the results, while leaving some relatively minor things to be desired, ultimately worked quite well, and helped paper over a majority of the issues I have with the opera's plot.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1635099850/media/2021/10/MassOpera_Traviata_Fourth_032_wedwa1.jpg){{% /md %}}

<figcaption>Alisa Cassola as Violetta Valéry and David Bozón as Alfredo Germont in La traviata, MassOpera, 2021. Photo: Nile Scott Studios.</figcaption>

</figure>

Part of me wishes that there had been a more inventive way of facilitating travel through the rooms of the house than having members of the choral ensemble ask the audience to move, and while I do understand why it was done this way I will admit it took me out of the experience a little between the first two acts of the show.

However, what the motion between rooms did do was provide a sense of changed location. After all, _La Traviata_ does not take place in one single house, but different places: the motion through the various rooms conveyed this quite excellently, in that not only did the audience placement in each room rather ingeniously keep the audience from looking at previously-occupied spots with too discerning an eye, but they were also dressed differently enough from previous rooms that each locale felt like a different place.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1635099869/media/2021/10/MassOpera_Traviata_Fourth_070_rmw3hr.jpg){{% /md %}}

<figcaption> in La traviata, MassOpera, 2021. Photo: Nile Scott Studios.</figcaption>

</figure>

This is due to a combination of factors, from how the house was furnished in each room to the way each area was lit and even the form of ensemble that accompanied the singers in each act (yes, the instrumental ensembles changed between acts: it started with a string quartet for the first two acts, then changed to a clarinet-drum kit-piano trio for the Act III party scene, then changed to just a single violinist for Act IV).

However, these changes of location also followed the opera's arc from bright, bubbly party opera to the dark, brooding tragedy that it becomes by the time Act IV rolls around, and it set the tone for each scene in how it was dressed. The party scene in Act III was a notable example in how the tense atmosphere of the scene was underscored by harsh red lighting that came from behind the audience where they sat on the porch, but for my money the true testament for why this works so well is actually the entrance foyer, which in this production stood for Violetta's house.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1635099885/media/2021/10/MassOpera_Traviata_Fourth_080_j7bszz.jpg){{% /md %}}

<figcaption>Alisa Cassola as Violetta Valéry and David Bozón as Alfredo Germont in La traviata, MassOpera, 2021. Photo: Nile Scott Studios.</figcaption>

</figure>

The opera opens in this space, with warm brown lighting and champagne bottles that were visible all over the performance area: there was a splendor to the scene we walked into, and this played well with the merriment the ensemble and the leads exhibited. We looped back to this location for Act IV, but when we did, the room looked completely different: the room was very dimly lit, there was a makeshift bed in the center of the performance area, some of the furniture was covered in white sheets, and in place of the champagne bottles was an old-style radio, from which blared an archive broadcast that gave information about tuberculosis.

The mere act of walking back into the room and finding such destitution in a space that I remembered for being so opulent just over an hour before took my breath away, and this feeling of complete desolation was only amplified when the solo violin that provided the only accompaniment in the last act of the opera came down the grand staircase that led up to the house's second floor. The house, in a way, became a character in Verdi's drama, and it thus dictated the tone of the work in a way that I have never seen a set dictate the mood, and I am all there for it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1635099911/media/2021/10/MassOpera_Traviata_Fourth_090_otmjdj.jpg){{% /md %}}

<figcaption>Alisa Cassola as Violetta Valéry and David Bozón as Alfredo Germont in La traviata, MassOpera, 2021. Photo: Nile Scott Studios.</figcaption>

</figure>

Of course, all this would only work with a gifted cast of singers, and on the performance I had I certainly got lucky in this regard. Practically everyone in the cast acted their parts very well, something that was of especially high importance both because of the decreased audience distance and because the acting was all we had to figure out what was going on considering there was not a single subtitle to be seen anywhere throughout the performance.

The cast was admittedly helped quite a bit by how the score was truncated to just 90 minutes: this helped the show feel rather brisk in its pacing, and cutting a lot of the fat involved actually really helped the believability of a lot of the characters' actions. However, most of the responsibility falls to the leads, and they all exhibited this quite brilliantly: Ron Williams' Germont was allowed to exhibit a warmth that is usually absent from the character, and while I do feel his voice was perhaps a touch too heavy for the role's rapid runs it allowed the natural warmth of his tone to work with most of its performance, with the menace really only coming out in isolated patches where it made sense.

I felt that Alisa Cassola's Violetta could perhaps have done a little more more to portray the frailty of her character during the middle two acts, but she really hit Violetta out of the park in every other way that matters to her character, from how she expresses her devotion to Alfredo to Germont in Act I to her "Sempre libera", which was really the only way to end the first act.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1635099921/media/2021/10/MassOpera_Traviata_Fourth_105_bx15b9.jpg){{% /md %}}

<figcaption>Alisa Cassola as Violetta Valéry in La traviata, MassOpera, 2021. Photo: Nile Scott Studios.</figcaption>

</figure>

But perhaps the stand-out for me was David Rivera Bozón as Alfredo, and this is quite a feat since I typically find Alfredo to be the biggest tool of _La traviata_'s cast. He found a sense of earnestness to the character's intentions that just made him a much better character for me, but perhaps more than anyone he acted the heck out of it.

For me, the stand-out moment was when his father came into the Act III party scene and called him out just after he slut-shamed Violetta: for this moment, Alfredo had to sit on a stool on the corner of the couch. I happened to choose to sit at a seat right next to this stool, and I got a literal front-row view of how strongly his regret showed on his face, even behind the cover of his hand. It really pulled into focus just how committed this production was to portraying these characters well.

To be certain, there were a few snags throughout. The string quartet that accompanied the first two acts sounded noticeably under-rehearsed to my ear, and their iffy intonation and noticeably messed up runs were admittedly very distracting through the first two acts. There is, also, the aforementioned issue of the transition between rooms.

But this is a _Traviata_ that I was genuinely invested in by the time Violetta was cajoled up the stairs to her more figuratively-staged death by violin soloist Anna Harris, and if there is one thing I like more than listening to an opera I love it is being pleasantly surprised by a production of an opera I am not as big a fan of, and I hope this inspires similar types of productions going forward.