+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-05-09T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Boston Lyric Opera's production of [_The Handmaid's Tale_](https://blo.org/handmaids/) runs through May 12. "
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1557423805/media/2019/05/sqBLO2019-HMT-9445.jpg"
primary_image_credit = "Jennifer Johnson Cado (Offred) in The Handmaid's Tale, Boston Lyric Opera, 2019. Photo: Liza Voll."
related_articles = ["articles/blo-s-electrifying-rape-of-lucretia-a-revelation.md"]
related_companies = ["scene/companies/boston-lyric-opera.md"]
related_people = ["scene/people/jennifer-johnson-cano.md"]
short_description = "There is so much to like musically because Ruders stays true to Atwood's novel while finding time to let the music tell the drama on its own that it is indeed a good thing that it has finally found its cultural moment."
slug = "installation-handmaids-tale-a-dramatic-chilling-staging"
title = "Installation Handmaid's Tale a dramatic, chilling staging"
youtube_url = ""

+++
Whenever an opera is presented outside of the typical proscenium format, I think it is often required to ask oneself the effect this would have on the performance. Even if the work does not specifically address the audience, any production presented with decreased distance from the audience will beg for a different kind of engagement from its audience. Sometimes, this can work to an opera's disadvantage, for it leaves the singers very few places to hide and can expose holes in a not-so-worthy piece. But sometimes, this works beautifully, and nowhere have I seen such a great example of this than Boston Lyric Opera's production of Poul Ruder's opera [_The Handmaid's Tale_](https://blo.org/handmaids/).

This production of _Handmaid's Tale_ was staged in a basketball court, stylized with an arena-style seating arrangement which stared on the action from three different angles. (The only remaining angle was where the rather large orchestra was situated.) The effect, as with BLO's recent production of _Rape of Lucretia_, was to focus the action on everything happening in the center of the whole affair.

>All of this pizzazz in the production could have gone to waste on substandard material: however, this was decidedly not the case here.

However, unlike _Lucretia_, this production of _Handmaid's Tale_ had no height above the audience, and all of the action played out in a rather small rectangle in the center of the venue which was surrounded on all four sides by chest-high walls. This kind of tight, arena-style staging amplified the themes present in Margaret Atwood's dystopian novel to a new, incredibly visceral level: the arena seating brought a voyeuristic feel to the whole affair, and the result made the action in the center of the arena claustrophobic and stifling in a way that would have been lost in a traditional proscenium staging.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557424522/media/2019/05/BLO2019-HMT-9199.jpg){{% /md %}}

<figcaption>Jennifer Johnson Cano (Offred) in The Handmaid's Tale, Boston Lyric Opera, 2019. Photo: Liza Voll.</figcaption>

</figure>

This only amplified the theme of oppression that runs in every aspect of Gilead's world-building, from the way the audience's complicity in their observation mirrors the actions of the Aunts who effectively brainwash the Handmaids and the discomforting feeling of Offred and the Commander doing the nasty in front of the Commander's wife Serena Joy to contributing to the feeling that Offred can never be allowed to speak her mind even among people she trusts. It is rare that the choice of venue and how one dresses it can amplify themes present in the source so beautifully, but BLO chose the perfect venue and the perfect way to dress it, and the results are chilling.

Of course, they could have stopped there, but stage director Anne Bogart's attention to detail was staggering in every aspect of the production. The costumes' colors remained rather drab throughout: this allowed the handmaids' signature red garments to pop visually, and it only added to the feeling that these women were being targeted by Gilead's society to a very specific end. The use of lighting also contributed to the oppressive atmosphere: the only natural light in the installation set with the sun outside of the venue, and the rest was harsh LED lighting, with effective splashes of color that always seemed to match the action, whether the performance area was washed in blue, red, or purple.

The attention to detail even extends to how the show's few set pieces were moved into the rectangle by the show's cast. It is not lost on me that Bogart chose a very gendered way of bringing set pieces in, where the handmaids often wheeled in set pieces associated with Offred and/or Serena Joy and armed military guards wheeled in set pieces associated with masculine power structures: this played perfectly into the text's overtly patriarchal society, and thus it pulled the audience into Gilead in a way that I don't know any other production could have.

>I cannot imagine that preparing for a role such as Offred is particularly easy by any stretch of the imagination.

All of this pizzazz in the production could have gone to waste on substandard material: however, this was decidedly not the case here. Music director David Angus called _Handmaid's Tale_ one of the finest operas in the last thirty years, and I would be inclined to agree with this assessment. In the first place, the atonal musical language always feels like it's a split second away from exploding in a flurry of violence, whether it be a "wrong" note in the chordal material or something that doesn't sound quite right in the orchestration.

Ruders' choice of musical identity for each part of the story also adds to the world-building of Gilead: he makes frequent use of all kinds of liturgical music ranging from Gregorian-style chant to directly quoting _Amazing Grace_ to highlight just how trapped the handmaids are in this theocratic dystopia, and his use of other genres from jazz to minimalism similarly amplifies the setting and timeline of the story's events as they happen. He has a motif on the recurring phrase "under the Eye" which is sung by two singers where one singer always drops a minor second so that it feels like they are under watch by forces beyond their control.

Even the way Ruders sets the text honors Atwood's themes: the singers often fly right up to their highest registers with a nervous energy no doubt borne out of their circumstances, and lest you think it is a weird idiosyncrasy of Ruders' style it is worth pointing out how fitting it is that Commander Fred, the character with the most power and thus the most leeway to do whatever he wants, is both a bass and the character whose vocal writing flies into the stratosphere the least out of everyone else in the opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557424540/media/2019/05/BLO2019-HMT-9258.jpg){{% /md %}}

<figcaption>Caroline Worra (Aunt Lydia) in The Handmaid's Tale, Boston Lyric Opera, 2019. Photo: Liza Voll.</figcaption>

</figure>

And then, it chooses just the right moments moments to musicalize Offred's voice to emphasize the fact that, ultimately, it is her story. There are two moments in the show where the music slows down and allows Offred to sing about her pain, and each time was affecting and rather tragic. In particular, the second-act duet between Offred and her younger pre-Gilead self proved incredibly heartbreaking, with the way Ruders links Offred's pain at having been separated from her daughter by having the two singers sing almost entirely in unison and then having the two Offreds trade syllables at certain points.

>This was Offred's story, and Jennifer Johnson Cano never let you forget this fact.

Overall, there is so much to like musically because Ruders stays true to Atwood's novel while finding time to let the music tell the drama on its own that it is indeed a good thing that it has finally found its cultural moment.

And of course, tying this all together is Offred herself. I cannot imagine that preparing for a role such as Offred is particularly easy by any stretch of the imagination: in this production, the only time she ever left the stage was to facilitate a quick change after Commander Fred takes her to an illicit sex party, and she spends a good chunk of this time absolutely singing her face off. It is a role that easily rivals roles like Elektra and Brünnhilde in terms of the demands on the singer's voice, but it also adds the challenge of having to embody a character who spends the entire work dealing with trauma while also living under patriarchal oppression, a characterization demand which would no doubt wear at the nerves of even the most steel-hearted woman.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557424556/media/2019/05/BLO2019-HMT-9388.jpg){{% /md %}}

<figcaption>Michelle Trainor (Ofglen) and Jennifer Johnson Cano (Offred) in The Handmaid's Tale, Boston Lyric Opera, 2019. Photo: Liza Voll.</figcaption>

</figure>

And here, mezzo-soprano [Jennifer Johnson Cano](/scene/people/jennifer-johnson-cano/) absolutely delivered. Her vocal stamina was something to be marvelled at considered that her voice never lost the beauty of its tone across the opera's three-hour runtime, but more than this she dove straight into Offred as a character and physically embodied her with a brave vulnerability that cannot be underestimated. The rest of the cast amply delivered in their characterizations, but this was Offred's story, and Jennifer Johnson Cano never let you forget this fact.

>This was a powerful gut punch of a production.

Any faults with a production like this essentially came down to nitpicks. Perhaps the staging of the climactic final quartet between Offred, the Commander, Serena Joy, and the household's Martha could have been done in a way that gave all four voices a chance to balance more evenly to the sides of the house as well as the front. Perhaps Ruders should have started a scene where Offred and the Commander play a game of Scrabble at a slower tempo and sped up into Offred's victory. Perhaps the projections on the walls should have taken a touch more attention to not look rather Photoshopped when it came to displaying images of hanged people that are left as visible reminders of what could happen to the characters should they choose to step outside of Gilead's societal norms. But when you have to nitpick to find fault with a production like this, it only stands as a testament to its quality.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557424583/media/2019/05/BLO2019-HMT-9539.jpg){{% /md %}}

<figcaption>Jennifer Johnson Cano (Offred) and David Cushing (Commander) in The Handmaid's Tale, Boston Lyric Opera, 2019. Photo: Liza Voll.</figcaption>

</figure>

It is the mark of any truly great production of an opera that it leaves you asking yourself how other productions could tackle this opera differently: whenever I try to think of how anyone could produce this opera in the proscenium and keep everything that made this production so viscerally effective, I find myself drawing a blank. That is a testament to the effect of its somewhat unusual staging: this was a powerful gut punch of a production, and its use of all of the details of the staging tied in with the themes of the work in such a way that an already excellent piece just got pushed that much further into operatic greatness.