+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2018-11-08T12:39:00-05:00"
lastmod = "2018-11-08T20:47:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541725097138/sqBurkhardFritz_SIEGFRIED_LyricOperaofChicago_LYR181030_0656_c.jpg.jpg"
primary_image_credit = "Burkhard Fritz in the title role of Siegfried, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg."
publishDate = "2018-11-08T20:11:00-05:00"
related_articles = ["articles/in-review-siegfried.md","articles/talking-with-singers-christine-goerke.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/christine-goerke.md","scene/people/eric-owens.md"]
short_description = "Pountney&#039;s concept for this Siegfried is rooted in his perception of the eponymous character&#039;s childlike naiveté and exuberance. Much of this production is experienced through the eyes of the young hero, but with some unabashed anachronisms. Siegfried&#039;s scenes were awash with primary colors taken straight out of a Crayola Crayon box."
slug = "inflatable-beasts-vocal-brilliance-locs-siegfried"
title = "Inflatable beasts &amp; vocal brilliance: LOC&#039;s Siegfried"
+++

How to sum up a five-hour night of Wagner at the Lyric Opera of Chicago? I'm tempted to simply leave it at: "Go. It's amazing!" Saturday's opening of [*Siegfried*](https://www.lyricopera.org/concertstickets/calendar/2018-2019/siegfried-opera-tickets), LOC's new production of the penultimate opera in Wagner's *Ring Cycle*, was overwhelming, invigorating, and awe-inspiring.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541698534928/BurkhardFritz_ChristineGoerke_SIEGFRIED_LyricOperaofChicago_LYR181030_1075_c.jpg.jpg)
<figcaption>Burkhard Fritz and Christine Goerke in *Siegfried*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>
 
As in last year's *Die Walküre*, there were elements of director David Pountney's staging that are sure to be divisive or at least raise some eyebrows. But there were also moments of pure stagecraft magic. For starters, there's the dragon – let's be honest: this is the component of *Siegfried* people are most itching to see. Since *Das Rheingold*, Fafner the giant has metamorphosed into a dragon to better guard his gained treasure, which includes the Tarnhelm and almighty Ring itself. Inflatable beasts can be hit-or-miss in the theater, but in this production the device worked brilliantly. Rending the forest greenery, Fafner's massive head appears, billowing smoke and eyes agleam with rage for whomever disturbed his slumber. His claws and tail, controlled by individual actors, writhed and slithered in balletic, if disembodied, fashion, which was at once jarring, mesmerizing, and totally effective. Matching the dragon's imposing maw was American bass Patrick Guetti. The Ryan Center alumnus brought all the bite and ponderousness of voice one wants in a covetous dragon. Although he sings for a comparatively brief time in the show, Guetti was glorious the whole while.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541698550150/PatrickGuetti_SIEGFRIED_LyricOperaofChicago_LYR181030_0709_c.jpg.jpg)
<figcaption>Patrick Guetti in *Siegfried*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>
 
Pountney's concept for this Siegfried is rooted in his perception of the eponymous character's childlike naiveté and exuberance. Much of this production is experienced through the eyes of the young hero, but with some unabashed anachronisms. Siegfried's scenes were awash with primary colors taken straight out of a Crayola Crayon box. The forest in Act II consisted simply of tall vibrant green leaves that unfurled like sails from the stage floor. And Mime's hut in Act I was an outright nursery, littered with stuffed animals and walls covered in Siegfried's finger-paintings. Oversized furniture highlighted the smallness of Mime's size and stature and complemented the *Rugrats*-like aesthetic of the first act.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541698560843/BurkhardFritz_SIEGFRIED_LyricOperaofChicago_LYR181030_0417_c.jpg.jpg)
<figcaption>Burkhard Fritz in *Siegfried*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>
 
Matthias Klink sang the role of Mime, Alberich's brother and the scheming dwarf who took in the orphaned Siegfried for his ultimate plan of winning the ring. Klink was awesome as Mime, singing with incredible nuance and the most articulate German snarls I've ever heard. His acting too was a tour de force. Donning a raggedy white sundress (Mime is "both father and mother" to Siegfried), rubber gloves, and workman boots, Klink captured the resentment of an unappreciated foster-parent, the exasperation of a sub-par craftsman, and the knavery of a creepy, conniving dwarf.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541698576901/EricOwens_MatthiasKlink_SIEGFRIED_LyricOperaofChicago_LYR181030_0249_c.jpg.jpg)
<figcaption>Eric Owens and Matthias Klink in *Siegfried*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>   

Siegfried was sung by German tenor Burkhard Fritz, making his American operatic stage debut. No stranger to Wagner's heroic roles, Fritz has sung Tannhäuser, Lohengrin, Parsifal, and Siegmund at many of Europe's major houses, including the Bayreuth Festival no less. In light of this pedigree, I confess I was a bit underwhelmed by the less-than-clarion voice I heard, at least at the beginning of the show. As the opera progressed, though, Fritz seemed to come more into his own vocally, especially as he interacted with his stellar colleagues. There were moments his voice didn't quite fill the immense LOC auditorium, yet those were balanced by the unquestionable polish of his instrument and his consummate musicality in such difficult music. For having scaled this Everest of tenor roles, Fritz deserved every bit of the ovation he received.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541698590599/BurkhardFritz_SIEGFRIED_LyricOperaofChicago_LYR181030_0615_c.jpg.jpg)
<figcaption>Burkhard Fritz in *Siegfried*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Where other directors might over-interpret elements of Wagner's scores either through cheeky cleverness, philosophical allusion, modern re-imagining, or some combination thereof, Pountney seems to make more simple, direct, even on-the-nose choices. But in so doing, certain layers of meaning get tossed by the wayside. For instance, we understand that Siegfried is a petulant youth, yet his is also unequivocally a coming-of-age story. At the start of the opera, we get "Siegfried the child" from his behavior and dress. Sporting a bulky striped t-shirt, cargo shorts, and sneakers all stained with what appeared to be ketchup and mustard, Fritz looked like he stepped off the set of a 90's kids movie (think of "Ham" Porter, Patrick Renna's character in the 1993 comedy *The Sandlot*). Over the course of the opera, as Siegfried slays Fafner, retrieves the Ring and Tarnhelm, awakens the sleeping Brünnhilde, we get no real indication of Siegfried's growth as a character. He's still covered in ketchup stains and his behavior is that of a horny adolescent. Siegfried "the child" becomes, at most, a "man-child," which is a shame because it thwarts the singer as an actor. And I'm sure Fritz has greater acting chops than this production let on. That said, despite these production quirks, Pountney succeeds in injecting some much-needed light and brevity into an operatic niche (i.e., Wagnerian) that can all too easily get crushed by its own gravitas. For this, Pountney deserves applause.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541698619105/ChristineGoerke_SIEGFRIED_LyricOperaofChicago_LYR181025_336_c.jpg.jpg)
<figcaption>Christine Goerke in *Siegfried*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Opposite Fritz and returning to the role of Brünnhilde in LOC's *Ring Cycle* is American soprano [Christine Goerke](/talking-with-singers-christine-goerke/). Radiant in voice and captivating in presence, Goerke was stunning as ever. Whereas in *Die Walküre* Brünnhilde is the fierce warrior daughter of Wotan, ruler of the gods, in Siegfried we witness her humanly vulnerabilities as she meets and falls in love with Siegfried, the one man who, "not knowing fear," was able to wake her from her induced sleep. From her opening jolt to her final passionate surrender, Goerke was remarkable for her emotional sweep as well as her vocal brilliance. You never lose track of the finesse she brings to this demanding vocal writing even when the orchestration is at its most lush. Somehow she's able to make Wagner sound like Mozart. It's a facile phrase for a reviewer to reach for, but I do believe that Goerke is the Brünnhilde of her generation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541698631359/RonnitaMiller_EricOwens_SIEGFRIED_LyricOperaofChicago_LYR181030_0944_c.jpg.jpg)
<figcaption>Ronnita Miller and Eric Owens in *Siegfried*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Bass-baritone [Eric Owens](/scene/people/eric-owens/) reprises the role of Wotan and all I can say is that Owens is a national treasure. I could listen to him sing the alphabet and be totally happy. The remaining cast members delivered standout performances in their own rights: mezzo-soprano Ronnita Miller gave us a ruminative Erda and soprano Diana Newman sparkled as the Forest Bird. South Korean bass-baritone Samuel Youn, returning as Alberich, was especially terrific. There's an intensity to his voice that grips you from the first note to the last.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541698645120/ChristineGoerke_BurkhardFritz_SIEGFRIED_LyricOperaofChicago_LYR181030_1115_c.jpg.jpg)
<figcaption>Christine Goerke and Burkhard Fritz in *Siegfried*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

With music director Sir Andrew Davis at the helm, the Lyric Opera Orchestra is magisterial in this music. Dense textures came through as hues of color supporting the drama on stage. A special shout-out must be given to the horn section and the soloist in Act II, who played Siegfried's horncall with immaculate artistry. I don't think I've heard it better. Davis' pacing throughout was masterful and made four hours of complex music seem inevitable and beautifully coherent.
 
Next season at LOC promises to be truly epic when the company presents Wagner's complete tetralogy. But until then, don't miss only two remaining performances of [*Siegfried*](https://www.lyricopera.org/concertstickets/calendar/2018-2019/siegfried-opera-tickets) on November 11 and 16.
