+++
author = ["authors/jenna.md"]
categories = "Interview"
date = 2021-05-23T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "The Watershed Festival runs online from May 25-28. Check out the [calendar of events](https://www.watershedmusictheatre.com/festivalschedule), and [register](https://events.eply.com/WatershedFestival) to tune in."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1621539835/media/2021/05/sqWatershed_vhcxnx.jpg"
primary_image_credit = ""
related_articles = []
related_companies = ["scene/companies/tapestry-opera.md"]
related_people = ["scene/people/michael-mori.md", "scene/people/marion-newman.md", "scene/people/dean-burry.md"]
short_description = "The virtual start to the Watershed Festival is no compromise, no placeholder for the in-person Festival set for spring 2022. \"Going virtual has a number of silver linings,\" says Burry. \"We've got people joining us from around the world, and I would imagine the best aspects of that kind of reach will always be a part of the festival moving forward.\""
slug = "inaugural-watershed-festival-to-celebrate-opera-musical-theatre-in-kingston"
title = "Inaugural Watershed Festival to celebrate opera & musical theatre in Kingston"
youtube_url = ""

+++
Here in Canada, as the light at the end of a long pandemic tunnel starts to trickle in, the Queen's University Dan School of Drama and Music is wasting no time in celebrating the performing arts.

Running from **May 25-28, 2021**, the inaugural [Watershed Festival](https://www.watershedmusictheatre.com/) is a first-of-its-kind online showcase of opera and musical theatre - two genres that, curiously, have been historically siloed despite their clear common ground. With the recent merging of the Queen's music and drama schools, the fusion of musical theatre and opera became particularly organic in the mid-sized city of Kingston, Ontario.

"As someone who really has worked in both the opera and musical theatre fields, I’m just looking forward to having those two groups in the same room and as a part of the same conversations," says [Dean Burry](/scene/people/dean-burry/), Canadian composer and Watershed Festival Artistic Director. "There are strikingly still so many stereotypes about the two fields held by professionals on both sides, and the reality is that opera and musicals have so much in common, but often do things in slightly different ways.  I think there is a lot to lean from each other."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1621540267/media/2021/05/Watershed-DeanBurryWatershedArtisticDirector_ibqbok.jpg){{% /md %}}

<figcaption>Dean Burry, Artistic Director of the Watershed Festival.</figcaption>

</figure>

The virtual line-up for the Festival features a healthy mix of creativity. Dan School professor Julie Salverson's work kicks things off on May 25, 7pm, with a [gala book launch](https://www.watershedmusictheatre.com/galabooklaunch) of her _When Words Sing: Seven Canadian Libretti_. Salverson is joined by [Tapestry Opera](/scene/companies/tapestry-opera/) Artistic Director Michael Hidetoshi Mori, and acclaimed Canadian librettists George Elliott Clarke (_Beatrice Chauncy_), Ann-Marie MacDonald (_Nigredo Hotel_) and Marie Clements (_Missing_), who will present excerpts of their work.

On May 26, Montreal-based Musique 3 Femmes resents an evening of new operas by women composers and librettists, as part of the Festival's [CREATE series](https://www.watershedmusictheatre.com/musique-3-femmes).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1621540325/media/2021/05/Watershed-Indigenous_Panel_yifu8i.png){{% /md %}}

<figcaption>(l-r) Marion Newman, (Amplified Opera), Julie Lumsden (Shaw Festival), Yvette Nolan (Playwright), and Emily Johnson (Catalyst Dance/Santa Fe Opera), all members of the Watershed Festival's Reimagining Decolonizing Music Theatre panel, May 27 at 11amET.</figcaption>

</figure>

In the [New Works Showcase](https://www.watershedmusictheatre.com/newworksshowcase), audiences can catch three in-progress musical theatre works: Jake Schindler and Sam Boer's _Ursa_, Kevin Skelton's _Pulse_, and Afarin Mansouri's _Zuleyka_. Additionally, [Calgary Opera](/scene/companies/calgary-opera/)'s documentary _Seeds of Namwayut_ will get a screening.

On top of the performances is a series of presentations and conversations by leading figures in music theatre, including Opera Philadelphia General Director [David Devan](https://www.operaphila.org/about/our-people/leadership/david-b-devan/), Amplified Opera co-founder [Marion Newman](https://www.amplifiedopera.com/marion-newman), and renowned music critic [Anne Midgette](https://anchor.fm/tewbop/episodes/Anne-Midgette-Art-Is-Not-the-Institutions-eiur6g).

The best part: the inaugural Watershed Festival is [all free](https://events.eply.com/WatershedFestival)!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1621540473/media/2021/05/Watershed-TimNelsonAnneMidgette_xmqeri.png){{% /md %}}

<figcaption>(l-r) Director Tim Nelson and music critic Anne Midgette, leading the Watershed Festival's Reimagining the Future of Opera panel, May 21, 1pmET.</figcaption>

</figure>

"The Watershed Festival will inaugurate a summer-long chain of festivals, including the Festival of Live Digital Art in June, the Fringe Festival in July, and the Kick and Push Festival in July and August," says Craig Walker, Director of the Dan School of Drama and Music. "Together these really help to underscore what an important cultural hub Kingston has become."

The Festival's final night features a sneak-peek premiere of [_The Lancashire Lass_](https://www.watershedmusictheatre.com/thelancashirelass), the upcoming suffragette-inspired musical, written by Canadian musical theatre creator Leslie Arden and commissioned by the Dan School. "I could not possibly be more excited about showcasing selections from _The Lancashire Lass_," says Brayah Pickard, a Festival participant and creator of the role of Christabel in the new work. "Virtual music theatre is a huge undertaking, and there are so many people working to make this one something truly remarkable."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1621540633/media/2021/05/Watershed-LancashireNewWorks_p1btl2.jpg){{% /md %}}

<figcaption>Top: the Ensemble of The Lancashire Lass, getting sneak peek with the Watershed Festival, May 28, 7pmET. Bottom: Kevin Skelton in the New Works Showcase, Watershed Festival, May 27, 7pmET.</figcaption>

</figure>

The virtual start to the Watershed Festival is no compromise, no placeholder for the in-person Festival set for spring 2022. "Going virtual has a number of silver linings," says Burry. "We've got people joining us from around the world, and I would imagine the best aspects of that kind of reach will always be a part of the festival moving forward."

With its impressive line-up and inspiring plans for a continued place in Kingston's artistic scene, the Watershed Festival is a must-see.

"If I had to put it in one sentence," says Pickard, "I'd say, 'If this is what we can accomplish in a time of global crisis and isolation, just wait until we can all get together again!'"