+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-04-10T22:54:00-04:00"
lastmod = "2015-04-10T22:54:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428720348543/bh-ElmerdeHaas4.jpg.jpg"
primary_image_credit = "Elmer de Haas"
publishDate = "2015-03-08T10:15:00-04:00"
related_articles = ["articles/still-stunning-written-on-skin.md","articles/in-review-hannigan-grazinyte-tyle-BBC-proms.md"]
related_companies = ["scene/companies/toronto-symphony-orchestra.md","scene/companies/royal-opera-house.md"]
related_people = ["scene/people/barbara-hannigan.md","scene/people/krisztina-szab.md","scene/people/isaiah-bell.md"]
short_description = "I didn’t now much about Written on Skin, except that it had its premiere in 2012 at Aix-en-Provence, and the next year it ran at the Royal Opera House. As I sat in Roy Thomson Hall, I was surprised at how immediately I thought, “Oh, I have to see this staged.” It’s a rare thing for an in-concert opera to jump out at me with its visual potential, but something about Written on Skin really stuck in my head. "
slug = "in-review-written-on-skin"
title = "In Review: Written On Skin"
+++

<p>
	As part of the 
	<a href="http://www.tso.ca/" target="_blank">Toronto Symphony Orchestra</a>'s New Creations Festival, I saw a fantastic in-concert performance of <a href="http://www.fabermusic.com/composers/george-benjamin" target="_blank">George Benjamin</a>'s opera <em>Written on Skin</em>. The British composer took the podium for the night, conducting a spectacular cast and the always exciting TSO through this disturbing, otherworldly score. I didn't now much about <em>Written on Skin</em>, except that it had its premiere in 2012 at Aix-en-Provence, and the next year it ran at the Royal Opera House. As I sat in Roy Thomson Hall, I was surprised at how immediately I thought, "Oh, I <em>have</em> to see this staged." It's a rare thing for an in-concert opera to jump out at me with its visual potential, but something about <em>Written on Skin</em> really stuck in my head. The libretto is by British playwright <a href="http://www.faber.co.uk/author/martin-crimp/" target="_blank">Martin Crimp</a>, based on the 800-year old story of the troubadour<a href="http://schmopera.com/wp-admin/post.php?post=3045&amp;action=edit&amp;message=10" target="_blank">Guillem de Cabestany</a> (the story also appears in Boccaccio's <a href="http://en.wikipedia.org/wiki/The_Decameron" target="_blank"><em>The Decameron</em></a>). The Protector is a moral man who wants to immortalize his life's good deeds, and he hires The Boy, an "illuminator of manuscripts" to do so. The Protectors wife, Agnès, has a tryst with The Boy, and when The Protector finds out, he murders The Boy and <em>feeds his heart</em> to Agnès. He tries to kill Agnès too, but she takes her own life instead, jumping from the balcony. It's a dense story, an old story about human beings and their petty emotions, and I loved how Crimp made it unclear who the heroes and villains were. It's not often that I have a full 180-degree spin on my opinion of a protagonist, but it certainly happened with Agnès. There were moments where the characters spoke in the third person, or as a narrator of their own scene; I liked the effect, and I wondered if Crimp was trying to tell us that a tale of infidelity and jealousy is one of the cornerstones of storytelling.
</p>
<p>
	<a href="http://www.barbarahannigan.com/" target="_blank">Barbara Hannigan</a> sang the role of Agnès (also in the Aix-en-Provence and London premieres), and I loved how the lines seemed blurred between what Hannigan sang and what Benjamin wrote. Agnès and Hannigan seemed entirely one person, even without a physical world created by sets and costumes. I was totally drawn in to what I thought was going to be a <em>femme fatale</em>-type of character, manipulating young men into her bed because she's bored. By the end of the opera, I realized how limiting it would be to be a <em>femme fatale</em>in 13th-century, and that Agnès was really just a trapped, under-stimulated woman, perhaps at the end of her rope when it came to bottling up her own needs and desires. I won't say there wasn't something dangerous about Agnès, and Hannigan found all the right moments to remind us that her character wasn't angelic. Vocally, Hannigan was in top form, using an enormous colour palette of sounds. She had some extraordinarily grand moments of singing, but I think some of my favourite moments came in Agnès weaknesses. There's an <em>incredible</em> scene where The Protector reads aloud a letter from The Boy about his sexual encounter with Agnès; Agnès can't read, and the desperation in her voice, the fear of being beholden to someone she distrusts for important information, that was moving for me.
</p>
<figure data-type="image">{{% md %}}<a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428720451645/Christopher_PurvesCliveBarda-683x1024.jpg"><img data-resize-src="http://lh3.googleusercontent.com/lyoGAr0j1LZ8CIhNb3Vkvxo2ORK0v5UnrJeQE6IoqpQbGntK4s22Ec7Hy6gV2rojUN47mEqxXsygnrWbx4J6F-OHjgQ" src="http://lh3.googleusercontent.com/lyoGAr0j1LZ8CIhNb3Vkvxo2ORK0v5UnrJeQE6IoqpQbGntK4s22Ec7Hy6gV2rojUN47mEqxXsygnrWbx4J6F-OHjgQ=s1200"></a>
<figcaption>Baritone Christopher Purves. Photo: Clive Barda</figcaption>
</figure>
<p>
	The Protector was sung by baritone <a href="http://christopherpurves.com/press/" target="_blank">Christopher Purves</a>, who joined Hannigan in the Aix and London casts. He was spectacular as a singer and actor; his voice had a warm, almost friendly baritone sound, which is what kept me on his side for a while. When he showed his colours as a vindictive, morally superior husband who sees his wife as "property," it was akin to finding out a dark secret about someone you've known for a while.
</p>
<p>
	As The Boy, countertenor 
	<a href="http://www.bernhard-landauer.at/" target="_blank">Bernhard Landauer</a> was beautifully passive. The Boy was easily manipulated into bed by Agnès (perhaps there was willingness there, too); when he writes about their affair for The Protector to read, it felt like one of those good deeds done by naïve people who don't know that they're in over their heads. I loved that Benjamin wrote the character of The Boy as a countertenor; the youth and frailty are exaggerated, and the possibility of real, reciprocal sexual energy between he and Agnès are minimized.
</p>
<figure data-type="image">{{% md %}}<a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428720509033/SzaboBoHuang_Fotor-681x1024.jpg"><img data-resize-src="http://lh3.googleusercontent.com/9ugsfo9ss7Y5pOYZWvThWv1ei76j0DYPA4svu_TTQhSoQcp3esbSjYhk5_7P5xEMw0d8qdj-zyRWRQxIuxSgRQAGCEIK8Q" src="http://lh3.googleusercontent.com/9ugsfo9ss7Y5pOYZWvThWv1ei76j0DYPA4svu_TTQhSoQcp3esbSjYhk5_7P5xEMw0d8qdj-zyRWRQxIuxSgRQAGCEIK8Q=s1200"></a>
<figcaption>Mezzo-soprano Krisztina Szabó. Photo: Bo Huang.</figcaption>
</figure>
<p>
	Rounding out the cast were mezzo-soprano 
	<a href="http://www.krisztinaszabo.com/" target="_blank">Krisztina Szabó</a> and tenor <a href="http://schmopera.com/the-business-of-passion-part-the-first/" target="_blank">Isaiah Bell</a>, as the Chorus of Angels, and later as an unhappily married couple, Marie and John. As the Angels who advise The Protector, they had some of the coolest text setting I've heard in a while; Benjamin evokes a feeling of voices in one's head with short, jabbing words. Isaiah had some gorgeous lines to sing and his voice filled Roy Thomson Hall with a clear ring. At one point The Protector questions The Boy about him having slept with Agnès; The Boy lies for Agnès, saying he slept with her sister, Marie. Krisztina's scene as Marie is a very cool moment of an imagined encounter; Benjamin writes the lines of The Boy and Marie almost on top of each other, Marie "finishing" The Boy's made-up details of their tryst. I love Krisztina Szabó.
</p>
<p>
	The TSO, of course, sounded fantastic playing Benjamin's score, under his baton. There were odd instruments (did I see a glass armonica?), and grossly loud moments, and the whole thing felt like a film score and then some. I'm officially eager to see 
	<em>Written on Skin</em> in a staged production, and from the comments I overheard in the Roy Thomson Hall lobby as I was leaving, I'm not the only one
</p>
