+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-01-14T14:53:00+00:00"
lastmod = "2017-01-19T17:49:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484406271712/2017-01-17---6837-CHRISTOPHER-PURVES-AS-THE-PROTECTOR-BARBARA-HANNIGAN-AS-AGNES-ROH-PHOTO-STEPHEN-CUMMISKEY.jpg.jpg"
primary_image_credit = "Barbara Hannigan (Agnès) and Christopher Purves (The Protector) in Written On Skin, ROH, 2016. Photo by Stephen Cummiskey."
publishDate = "2017-01-14T16:17:00+00:00"
related_articles = ["articles/still-stunning-written-on-skin.md","articles/talking-with-singers-christopher-purves.md","articles/in-review-the-exterminating-angel-at-roh.md","articles/discomfort-louis-riel-at-the-coc.md","articles/talking-with-conductors-oliver-zeffman.md","articles/fuelled-by-female-oppression-written-on-skin.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/barbara-hannigan.md","scene/people/christopher-purves.md"]
short_description = "What&#039;s most thrilling about this Written on Skin was how the piece itself shone through Mitchell&#039;s production. Phrases from the libretto - like &quot;blame her for everything&quot; - leapt out as though shouted; Benjamin&#039;s use of the glass armonica - the instrument of &quot;hysteria&quot; - is well-timed and significant. Though it didn&#039;t overshadow the human stories of Agnès and The Protector, there was clear commentary on free will, and the cruelty inherent in God&#039;s creation of man."
slug = "in-review-written-on-skin-at-roh"
title = "In review: Written On Skin at ROH"
+++

It was a noticeably different crowd than usual at the ROH's *Written on Skin*, the dense and evocative 2012 opera by George Benjamin and Martin Crimp. Particularly for an opening night, the demographic was certainly young; with nearly five years between the premiere of Katie Mitchell's production and this season's revival, audiences in London seemed invested in the life of one of the 21st century's most important English-language operas.

We had heard two in-concert readings of *Written on Skin*, first in Toronto with the Toronto Symphony Orchestra, and most recently at London's Barbican Centre with the Mahler Chamber Orchestra. The performance history of this opera has been about presenting it well, in the hands of experts; Benjamin himself is at the podium, with [Barbara Hannigan](/scene/people/barbara-hannigan/) and [Christopher Purves](/talking-with-singers-christopher-purves/) the core of the small, evolving cast of singers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484406582461/2017-01-17---0408-WRITTEN-ON-SKIN-PRODUCTION-IMAGE-ROH-PHOTO-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>*Written On Skin* production image, ROH, 2016. Photo by Stephen Cummiskey.</figcaption>
</figure>

Mitchell's approach to the score is an ingenious complement to Crimp's evocative libretto and Banjamin's musical unease that hangs in the air. The story of Agnès, the young, illiterate woman married to her much-older husband, The Protector, takes place in 13th-century Provence. It's a simple story of an unhappy marriage, an affair, a jealous man, and a curious woman; that simplicity allows *Written on Skin* to become an archetypal story of sorts, one that is timeless, international, and out of the hands of mere men.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484406510389/2017-01-17---6479-BARBARA-HANNIGAN-AS-AGNES-ROH-PHOTO-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Barbara Hannigan as Agnès in *Written On Skin*, ROH, 2016. Photo by Stephen Cummiskey.</figcaption>
</figure>

Vicki Mortimer's set divides the world into two; in the centre is the small, modest home of Agnès and The Protector, one room in a larger building, like the laboratory conditions of an ongoing experiment. The Angels arranged each scene, setting the characters of the story in place, as though to test what would happen to everyday people under circumstances of deceit, confinement, and lust. Crimp creates two characters out of each of the three Angels, and Mitchell allowed them to cross the boundaries of the celestial to the terrestrial, as though they were adding variables to their social experiment.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484406497569/2017-01-14---6280-VICTORIA-SIMMONDS-AS-MARIE%2C-CHRISTOPHER-PURVES-AS-THE-PROTECTOR-MARK-PADMORE-AS-JOHN-ROH-PHOTO-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Victoria Simmonds as Marie, Christopher Purves as The Protector, and Mark Padmore as John in *Written On Skin*, ROH, 2016. Photo by Stephen Cummiskey.</figcaption>
</figure>

Victoria Simmonds and Mark Padmore are a tight pair, both as Angels and as Agnès' sister and brother-in-law, Marie and John. Theirs are some of the most viscious texts of the score, a gross juxtaposition of judgement against the sterile impartiality with which they manipulate each scene. Iestyn Davies set his beautiful instrument against the ugliness in his story as The Boy; though he was the source of all conflict between Agnès and The Protector, The Boy was yet another planted character in this small story. He moved freely in and out of the 13th-century world, each time returning to his place among the Angels with more pity for the two mortals.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484406407904/2017-01-14---6313-BARBARA-HANNIGAN-AS-AGNES-IESTYN-DAVIES-AS-THE-BOY-ROH-PHOTO-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Barbara Hannigan as Agnès and Iestyn Davies as The Boy in *Written On Skin*, ROH, 2016. Photo by Stephen Cummiskey.</figcaption>
</figure>

It's a humbling story about men and women, and their repetitive conflicts. Crimp's libretto highlights the power imbalance within a marriage, exaggerated with Agnès' illiteracy and The Protector's clear need to grasp hold of his "property" as tightly as he can. The stunning final scene narrates Agnès' fatal "fall" from her balcony, and we see in slow motion a very, very old image of an angry, dangerous man chasing after his disobedient wife.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484406385873/2017-01-17---6800-BARBARA-HANNIGAN-AS-AGNES-CHRISTOPHER-PURVES-AS-THE-PROTECTOR-ROH-PHOTO-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Barbara Hannigan as Agnès and Christopher Purves as The Protector in *Written On Skin*, ROH, 2016. Photo by Stephen Cummiskey.</figcaption>
</figure>

What's most thrilling about this *Written on Skin* was how the piece itself shone through Mitchell's production. Phrases from the libretto - like "blame her for everything" - leapt out as though shouted; Benjamin's use of the glass armonica - the instrument of "hysteria" - is well-timed and significant. Though it didn't overshadow the human stories of Agnès and The Protector, there was clear commentary on free will, and the cruelty inherent in God's creation of man. We have a pathetically small amount of control over our own lives; if God's work is indeed real, our joys and tragedies are seemingly at the whim of a switch on a wall.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484406525040/2017-01-17---6642-BARBARA-HANNIGAN-AS-AGNES-ROH-PHOTO-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>in *Written On Skin*, ROH, 2016. Photo by Stephen Cummiskey.</figcaption>
</figure>

Only four performances remain for *Written on Skin* at the Royal Opera House, with American soprano Georgia Jarman singing the role of Agnès on January 18 and 27. For full details and tickets, [click here.](http://www.roh.org.uk/productions/written-on-skin-by-katie-mitchell)
