+++
author = ["authors/john-beckett.md"]
categories = "Review"
date = "2017-09-06T16:10:00-04:00"
lastmod = "2017-09-06T22:14:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1504729028973/2017-09-07---Wigmore.jpg.jpg"
publishDate = "2017-09-06T21:56:00-04:00"
related_articles = ["articles/in-review-sophisticated-precise-fearlessness-at-wigmore-hall.md"]
related_people = ["scene/people/marta-fontanalssimmons.md","scene/people/lana-bode.md","scene/people/harriet-burns.md","scene/people/ian-tindale.md","scene/people/peter-kellner.md","scene/people/pedro-costa.md","scene/people/lauren-lodgecampbell.md","scene/people/michael-sikich.md","scene/people/julien-van-mellaerts.md","scene/people/gamal-khamis.md"]
short_description = "I loved the way all the competitors took care of the transitions between songs, whether waiting to allow a moment to land or to keep the story going as to not drop the ball during a dead silence. It all proves that the silence is just as important as the music."
slug = "in-review-wigmore-hall-song-competition-semifinals"
title = "In review: Wigmore Hall Song Competition semi-finals"
+++

This week in London is the [Wigmore Hall and Kohn Foundation International Song Competition](https://wigmore-hall.org.uk/song-competition/2017-songcompetition). Since this past Sunday, young singer and pianist duos have been performing at London's most famous recital venue while competing for hefty cash prizes.

As far as competitions go, the Wigmore Hall and Kohn Foundation International Song Competition is very specific in terms of repertoire, and possibly in what kind of singer the jury is hoping to hear. In this semi-final round, each competitor performed a twenty minute program that included two songs by Schubert, songs in French, and songs in English by a British-born composer. Yes, this can make for a very homogenized event, but having specific requirements such as these helps level the playing field for the competitors.

What was impressive was the almost lack of any repetition of Schubert songs in this round - only one song was repeated. There were quite a few favorites, [Gemma Summerfield](/scene/people/gemma-summerfield/) and Sebastian Wybrew performed an exciting and expressive "Rastlose Liebe", and [Marta Fontanals-Simmons](/scene/people/marta-fontanals-simmons/) and [Lana Bode](/scene/people/lana-bode/) made "Suleika" seem easy.

I loved [John Brancy](/scene/people/john-brancy/) and [Peter Dugan](/scene/people/peter-dugan/)’s "Erlkönig", with very well developed characters and technical precision this duo wowed us and was a clear audience favorite. The brilliance of Dugan's playing matched the sparkling features of Brancy's baritone, and pure story telling came through the music. After their twenty minutes, we had experienced a spectrum of darkness and light that left listeners stunned in their seats. Their repertoire choice was perfect for showing their strengths, and luckily for them, their strength seemed to be repertoire that pleases an audience during a competition.

After watching a few singers whose message seemed to be, "It's all about me!" it was refreshing to hear [Harriet Burns](/scene/people/harriet-burns/) and [Ian Tindale](/scene/people/ian-tindale/), who clearly were there to show off the beautiful music they were performing and not themselves. Burns’ singing is comforting to listen to, and the communication between the two players was a beautiful thing to watch.

Certainly the most playful duo was Josh Quinn and You Zhao, who seemed to be on the stage just to have fun and enjoy themselves. For me, Quinn won best dressed of the evening, sporting a sparkling silver jacket with flair.

[Peter Kellner](/scene/people/peter-kellner/) and [Pedro Costa](/scene/people/pedro-costa/)’s entire programme felt like one song cycle, one story being told, and they may have taken the most emotional and dramatic risks. [Lauren Lodge-Campbell](/scene/people/lauren-lodge-campbell/) and [Michael Sikich](/scene/people/michael-sikich/) had a real classy program, constantly animated and drawing us in with their elegant performance. [Julien Van Mellaerts](/scene/people/julien-van-mellaerts/) and [Gamal Khamis](/scene/people/gamal-khamis/)' strategy was to deliver the music in a simple, easy way, allowing the songs to speak for themselves.

The biggest trend I saw throughout the round was this very direct way of communicating in song - singers being fixated on one point and seeming to never move their gaze for an entire ten minutes. Fixation can be a powerful tool for a singer, and while it works to connect a performer to an audience, it doesn't always result in honest performing.

I loved the way all the competitors took care of the transitions between songs, whether waiting to allow a moment to land or to keep the story going as to not drop the ball during a dead silence. It all proves that the silence is just as important as the music.

The final round of the Wigmore Hall and Kohn Foundation International Song Competition starts at 6pm GMT on Thursday evening. If, like most of the finalists, you’re not a local, you can catch the performance on a livestream via the Wigmore Hall website.
