+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-10-04T10:21:00+01:00"
lastmod = "2016-10-04T12:36:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475577108623/2016-10-04---square---ENO-Tosca-Keri-Alkema-and-Gwyn-Hughes-Jones-Richard-Hubert-Smith.jpg.jpg"
primary_image_credit = "Keri Alkema (Tosca) and Gwyn Hughes Jones (Cavaradossi) in Tosca, ENO, 2016. Photo by Richard Hubert Smith."
publishDate = "2016-10-04T12:27:00+01:00"
related_articles = ["articles/talking-with-singers-keri-alkema.md","articles/in-review-tristan-and-isolde-at-eno.md","articles/in-review-don-giovanni-at-eno.md","articles/rowley-wins-the-night-in-nashville-operas-tosca.md"]
related_companies = ["scene/companies/english-national-opera.md"]
related_people = ["scene/people/keri-alkema.md","scene/people/craig-colclough.md","scene/people/gwyn-hughes-jones.md"]
short_description = "Performing Tosca in English is about on par with performing Peter Grimes in Italian, when you think about it. Like with all great operas, Puccini&#039;s music leaps from the ebbs and flows of the text; simply put, if the libretto had been different, there would be different tunes for us to hum post-show."
slug = "in-review-tosca-at-eno"
title = "In review: Tosca at ENO"
+++

Catherine Malfitano's production of [*Tosca*](https://www.eno.org/whats-on/tosca/) has returned for its second revival at [English National Opera](/scene/companies/english-national-opera/) (this time directed by Donna Stirrup), and with it come three stellar singers in the leading roles. [Keri Alkema](/talking-with-singers-keri-alkema/) makes her ENO debut as an endearing, kind, even funny Floria Tosca, and she sings with a rich, womanly sound that seems made for the role. [Gwyn Hughes Jones](/scene/people/gwyn-hughes-jones/) is a clear and cutting Mario Cavaradossi, full of strength and heart, and even some Italian suave-ness (impressive for a Welsh tenor singing in English) that speaks to the couple's true chemistry.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475576149017/2016-10-04---ENO-Tosca-Gwyn-Hughes-Jones-and-Keri-Alkema-1-Richard-Hubert-Smith.jpg.jpg)
<figcaption>Gwyn Hughes Jones and Keri Alkema in *Tosca*, ENO, 2016. Photo by Richard Hubert Smith.</figcaption>
</figure>

It was [Craig Colclough](/scene/people/craig-colclough/)'s thrilling Scarpia that seemed to steal the show. His voice was alive with the Baron's shifting moods and tactics, and he impressed with his mix of dangerously soft singing, and enormous, hall-filling booms. Since we first heard him as Kurwenal in [ENO's *Tristan and Isolde*](/in-review-tristan-and-isolde-at-eno/), Colclough's voice has been endlessly interesting; as Scarpia, he has the snarling cut in his sound which soars over the crowd in the *Te Deum*, and places him clearly in the villain camp.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475577146403/2016-10-04---ENO-Tosca-Craig-Colclough-and-Graeme-Danby-Richard-Hubert-Smith.jpg.jpg)
<figcaption>Craig Colclough (Scarpia) and Graeme Danby (Sciarrone) in *Tosca*, ENO, 2016. Photo by Richard Hubert Smith.</figcaption>
</figure>

The bleak production by Malfitano, designed by Frank Philip Schlössmann and lit by David Martin Jacques, trades luxurious spaces for dark, secretive ones. There was an organic quality to the aesthetic, which was full of neutral colours that highlight Gideon Davey's costumes: Scarpia's rich, purple overcoat, Tosca's feminine-yet-demure skirts, and the splashes of red blood on Cavaradossi's face. 

The muted colours seemed unfortunately mirrored in the action onstage; there was tepid tension in the infamous scene of violence in Act II, and little heat between Mario and Floria, even at the highest of stakes in Act III. Given Malfitano's own experience with the story of Tosca, it was surprising to see such little use of Puccini's music. At times, the singers seemed confined, as though their physical instincts went against Malfitano's staging.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475577166806/2016-10-04---ENO-Tosca-Keri-Alkema-and-Craig-Colclough-2-Richard-Hubert-Smith.jpg.jpg)
<figcaption>Keri Alkema and Craig Colclough in *Tosca*, ENO, 2016. Photo by Richard Hubert Smith.</figcaption>
</figure>

As the show continued, it became more clear that the issue lay largely in the text of this *Tosca*. The English translation by Edmund Tracey was certainly hokey at times, yet it's doubtful that any singable English version of the libretto would be able to avoid strange moments like, "Here is the door key." Despite the fact that Malfitano's *Tosca* premiered at ENO (in English) in 2010, it was clear that she staged the Italian libretto (that she knew well), and that not enough work had been done to fit this English translation into her choices.

Performing *Tosca* in English is about on par with performing *Peter Grimes* in Italian, when you think about it. Like with all great operas, Puccini's music leaps from the ebbs and flows of the text; simply put, if the libretto had been different, there would be different tunes for us to hum post-show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475577178518/2016-10-04---ENO-Tosca-Gwyn-Hughes-Jones-Richard-Hubert-Smith.jpg.jpg)
<figcaption>Gwyn Hughes Jones in *Tosca*, ENO, 2016. Photo by Richard Hubert Smith.</figcaption>
</figure>

Of course, it's not a shock or a novelty that an ENO production is sung in English, yet it was disappointing to have to rely so heavily on the surtitles. We craved tons more clarity of text from the singers (with the notable exception of Colclough), especially when the translation meant that words fell in strange beat patterns.

It's something that we noticed in [ENO's *Madam Butterfly*](/in-review-madam-butterfly-at-eno/) from last season. To demand that English Puccini be totally intelligible is a big ask for singers; this cast is full of pros, and perhaps we heard as much clear English as we were going to get, before the singers would have to sacrifice quality of sound. The question arises, then: what's the point of putting up opera in English if audiences still have to read the surtitles?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475577196596/2016-10-04---ENO-Tosca-Keri-Alkema-Richard-Hubert-Smith.jpg.jpg)
<figcaption>Keri Alkema in *Tosca*, ENO, 2016. Photo by Richard Hubert Smith.</figcaption>
</figure>

Linguistic griping aside, this *Tosca* is musically satisfying, led deftly by Italian verismo specialist Oleg Caetani. It's worth hearing the combination of Alkema, Hughes Jones, and Colclough, no doubt.

>Tosca runs at English National Opera until December 3. [Click here](https://www.eno.org/whats-on/tosca/) for details and to book your tickets.
