+++
author = ["authors/jenna.md","authors/collin-shay.md"]
categories = "Review"
date = "2017-04-07T12:27:00+01:00"
lastmod = "2017-04-08T12:38:00+01:00"
preamble = "Contributors [Collin](/authors/collin-shay/) and [Jenna](/authors/jenna-douglas/) both caught Ensemble Prisma Wien and Bernarda Fink at Wigmore Hall. Both brought their notebooks, and enough disagreement arose to warrant this special double review. For more like this, check out [Greg](/authors/greg/) and Jenna's [\"He said/She said\" review of Robert Carsen's *Falstaff*](/falstaff-he-saidshe-said/), & our [season round-up](/greg-jennas-201415-opera-season-roundup/) over wisdom-enhancing wine."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1491567411995/2017-04-07---Bernarda-Fink.jpg.jpg"
publishDate = "2017-04-07T14:34:00+01:00"
related_articles = ["articles/paul-appleby-telling-stories-at-wigmore-hall.md","articles/in-review-peter-deutsch-at-wigmore-hall.md"]
short_description = "Ensemble Prisma Wien&#039;s debut concert at Wigmore Hall was a successful combination of excellent artists, and the kind of music that seems to flow organically from the group&#039;s dynamic. The Ensemble gave us music by Haydn, Schubert and Dvořák, all effortless melodists whose tunes feel as though they&#039;ve always existed."
slug = "in-review-times-two-ensemble-prisma-wien-bernarda-fink"
title = "In review times two: Ensemble Prisma Wien &amp; Bernarda Fink"
+++

**Jenna**: Great chamber groups can remind you of the simple pleasures found in listening to music; the small exchanges between musicians feel as though you're in on a secret, and inevitably you grow to "know" the players and their roles. [Ensemble Prisma Wien](https://ensemble-prisma.jimdo.com/)'s debut concert at Wigmore Hall was a successful combination of excellent artists, and the kind of music that seems to flow organically from the group's dynamic. The Ensemble gave us music by Haydn, Schubert and Dvořák, all effortless melodists whose tunes feel as though they've always existed. 

**Collin**: The evening began with 5 Minuets of Schubert, written while the composer was a teenager. Originally for string quartet, Ensemble Prisma Wien performed an arrangement by the ensemble’s director, Thomas Fheodoroff, adding a double bass part to these light-sounding dances. While the additional bass added depth to the ensemble's sound and certainly brought a darker character to these pieces, we weren't sure of the real reasoning for this choice. 

Perhaps it was because Schubert's early quartet writing relies heavily on the first and second violins doubling in octaves, so doubling an octave below the cello broadened the sound world that could seem too treble-heavy in the printed writing. In Fheodoroff's arrangement of Schubert's Impromptu in C Minor, the ensemble played together as one instrument. In this arrangement, it made perfect sense to have a double bass, as there were moments when the viola, cello and bass sounded like a full orchestra in the tiled-bathroom resonant chamber that is Wigmore Hall. 

**Jenna**: The Ensemble Prisma Wien adapts slightly the traditional string quintet, trading a second viola for a double bass. The acoustic affect worked particularly well with their picks by Schubert and Dvořák, where the delicious open intervals and folk-like harmonic motion was amplified by the extra sound down low; perhaps most interesting was the relationship between the double bass and the cello, which sometimes duetted, and sometimes acted as a miniature melody-accompaniment element within the quintet. The 5 Minuets that Schubert wrote as a young composer had the broad rhythmic spaciousness that keeps chamber music feeling improvisatory; the quintet shared large, spinning beats and traded smaller moments of flexibility that speak to an impressive level of communication and collective "feeling it".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1491568109964/2017-04-07---Prisma-Wien.jpg.jpg)
<figcaption>Ensemble Prisma Wien. Photo via [Facebook.](https://www.facebook.com/Ensemble-Prisma-Wien-276229798478/)</figcaption>
</figure>

**Collin**: As Bernarda Fink joined the ensemble for Haydn's *Arianna a Naxos*, her voice melted into the texture beautifully and like an instrument herself. While never sacrificing any drama that came in the recitative, she bowed her larynx like a string and was always a fixture of the harmony, rather than a string of independent notes that one sometimes hears in recitative. Fink's voice was rich in texture and seems to have layers of overtones packed into the sound. Here is an example of someone who has total control over her voice, using her deep chest voice to show Arianna’s yearning for Teseo and lyric legato as she laments her fate.

**Jenna**: Prisma also shared the stage with mezzo-soprano Bernarda Fink, for Dvořák's *Biblical Songs*, and Haydn's dramatic *scena*, *Arianna a Naxos*. With an easy, honest mezzo sound, Fink got right to the storytelling. She handled well the large-scale, tricky pacing of the Haydn; the piece doesn't necessarily follow the commonly known "stages of grief", but Fink showed the clear steps between longing, discovery, denial, hopelessness, and anger. 

The *scena* certainly gathers steam as the story progresses in real-time, particularly when Arianna actually sees Theseus leaving Naxos without her, and its *presto* finale grows out of the emotional peak of the story. Still, for such an iconic story of abandonment and women-done-wrong, Haydn seems to write too many major chords, too many consonant tunes. We couldn't help but compare it to Monteverdi's setting of a similar text, and notice that Haydn's telling is relatively conflict-free.

**Collin**: During Dvořák's *Biblical Songs*, Fink also acted as an instrument, but in this case sometimes slipped into the texture, and we forgot that the voice was meant to be a feature of this work. Is it possible for a singer to be too musical, or to be such a good colleague that you end up passing up opportunities to really shine as a soloist? Ensemble Prisma Wien describes their group as having the flexibility to present a wide spectrum of repertoire from their unique instrumentation - in the case of the *Biblical Songs*, string quintet and oboe. So, is their function here to accompany, or to envelop each other into their own unique sound world regardless of playing with a mezzo-soprano, as they did while playing Schubert?

**Jenna**: Dvořák's *Biblical Songs* were new to us, and a beautiful picture of the role religion played in the composer's life. The songs were written in the weeks leading up to Dvořák's father's death in 1894; when some composers would take the opportunity to vent their anger or despair, Dvořák takes poetic Czech translations of the Book of Psalms, and sets them in very personal way. Clearly, the composer's faith was not the all-encompassing element in his life as it was for people like Olivier Messaien or J.S. Bach; Dvořák seems content with reminding himself of these texts, and trusting life's inevitable unfolding. Fink's singing of the songs felt right in line with Dvořák's music; there was no hint of accusation, aggressive piety, or preaching. Instead, she seemed humble and optimistic, and it was really touching.

**Collin**: Bernarda Fink proved to be quite the generous performer, giving a dramatic and emotional context to these songs written by a composer whose is not necessarily known for his sacred music. With texts that seem to be saying the same thing over and over again in a different wording (the psalms used as the text are mostly all about finding strength in the Lord) it's possible to imagine a singer facing a similar issue in Handel arias, breathing new meaning to aggressively repetitive text. Fink and Ensemble Prima Wien made specific choices in bringing out colors to help us understand the Czech - from the soft silver dove to the waters of Babylon, we heard music that served the psalms well.

**Jenna**: The whole ensemble offered an encore, an arrangement of Schubert's song *Die junge Nonne* by Fheodoroff. Organic seems to be the best descriptor for Prisma's first Wigmore Hall concert, and it's no small thing that the arrangements and adaptations of works for their instrumentation felt fitting and never disruptive. To stay up-to-date with Prisma's upcoming concerts, follow them on [Facebook](https://www.facebook.com/Ensemble-Prisma-Wien-276229798478/), or visit their [website.](https://ensemble-prisma.jimdo.com/) Bernarda Fink returns to Wigmore Hall in September, as a juror for the [2017 International Song Competition](https://wigmore-hall.org.uk/song-competition/2017-songcompetition).

