+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-11-06T09:42:00-05:00"
lastmod = "2015-11-06T12:17:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446820696277/11353496_736533219785982_1553908783_n.jpg.jpg"
publishDate = "2015-11-06T10:43:00-05:00"
related_articles = ["articles/in-review-albert-herring-at-uoft-opera.md","articles/anna-theodosakis-directing-the-rape-of-lucretia.md"]
related_companies = ["scene/companies/university-of-toronto-opera.md"]
related_people = ["scene/people/patrick-duwors.md","scene/people/danika-lorn.md"]
short_description = "The University of Toronto Opera opened a double bill last night, pairing together two of Menotti&#039;s most well-loved works, The Telephone (1946) and The Medium (1945). I saw the first of two casts in what I thought was a beautifully detailed production by director Michael Albano."
slug = "in-review-the-telephone-the-medium"
title = "In review: The Telephone &amp; The Medium"
+++

The [University of Toronto Opera](http://uoftopera.ca/) opened a double bill last night, pairing together two of Menotti's  most well-loved works, *The Telephone* (1946) and *The Medium* (1945). I saw the first of two casts in what I thought was a beautifully detailed productions Michael Albano (*The Telephone*) and rising director [Anna Theodosakis](http://www.news.utoronto.ca/anna-theodosakis-first-student-direct-major-u-t-opera-production) (*The Medium*). The UofT Opera Orchestra took on these two tricky scores under maestra Sandra Horst, Chorus Master of the [Canadian Opera Company](/scene/companies/canadian-opera-company/); she was a great sight to see on the podium.

[Opera and technology](/is-technology-making-it-harder-to-tell-stories/) have been on my mind lately, so it was timely to see a 2015 production of *The Telephone*. The home phone of the 1940s was replaced with the smartphone of today, and translating one piece of technology for another can offer plenty of traps in the libretto. Instead, Albano and his team opted to focus on what was still true about this story; today, a story about a woman addicted to her phone is more wildly relevant than Menotti could have ever imagined.

The surtitles at the top of the show read fun and voyeuristic text conversations of characters we would see in the background of the cafe (a beautiful asymmetrical set design by [Patrick Du Wors](/scene/people/patrick-duwors/) and complementary costumes by Lisa Magill), setting up a clear picture of where and when we were. There was at least one instance of changing a word in the libretto (to "Skype"), and I'm glad they opted for small, simple changes, rather than pushing up against specific dated idioms, like the word "phone" as a verb. 

There was a hilarious moment where Lucy (the phone addict, sung impressively by soprano Caitlin McCaughey) is excited to be able to use her phone to find out the time for Ben (her frustrated would-be fiancé, well-cast in baritone Max van Wyck); there used to be a ["time of day" service](https://en.wikipedia.org/wiki/Speaking_clock#United_States), where you could dial a number and it would read you the time. Fumbling for several bars to find the time on a smartphone reads more like laughable technological illiteracy. Still funny.

The two-singer cast was strong. As Lucy, McCaughey had a bright, healthy sound capable of a lot of colour, and van Wyck's friendly-sounding baritone was perfect for the doormat-like, never-gets-a-word-in Ben. Both of them had fantastic text that was easy to absorb, not always an easy task (a nod goes to diction coach Jason Nedecki). This show was all about attention to detail, from Lucy's bouncy, bouncy hair, to the GO Train sign, to all the background interactions Ben has with various other coffee-drinkers at the cafe. One of those exchanges was with a fortune-teller of sorts, a cute and subtle nod to the second half of the evening.

*The Medium* started with another beautiful set by Du Wors, all patterned wallpaper and dim floor lamps to go with Magill's striking and organic costumes. The house was shown as a cross-section, letting us see the front entrance, the main room, and the hidden closet where Toby creates the special effects for Baba's "séances". *The Medium* is a piece that says a lot about heavy things like losing a child and domestic violence; to me, the action always felt crowded. Nevertheless, I thought the cast did a great job of unpacking complicated characters in a short amount of time. Bravo to director Anna Theodosakis on a great accomplishment with this production.

Megan Quick was unpredictable as Madame Flora (Baba), looming large around her clients and her children. At times I heard the difficulty of the score coming out in her rhythmic lines, but I liked her mix of power and weakness as she unraveled in front of us. Camille Rogers, Adam Harris and Kristina Agur were a sad trio of séance participants, standing for all the people who hold tightly to beliefs that comfort them. They have some tricky harmonies to sing, but they all kept it conversational and improvisatory.

Within the story of *The Medium* is the story of Monica, Flora's daughter, and Toby a "rescued" mute boy. Danika Lorèn was lovely as Monica, singing with a gorgeous sound and an easy, clean approach to the text. Daniel Robinson was heartbreaking as Toby; he had constant submissive body language, almost like physical mirrors to his fear of Baba, or his love for Monica. I have a real soft spot for mute characters, and Daniel's performance was one of my favourites.

>*The Telephone* and *The Medium* features one more cast of singers, playing for three more shows until November 8th at the MacMillan Theatre in UofT's Edward Johnson Building. For details and tickets, follow the box office links below.
