+++
author = ["authors/greg.md"]
categories = "Review"
date = "2016-07-24T10:10:00-04:00"
lastmod = "2016-07-25T09:34:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1469370769220/2016-07-24---Lucretia-TSFM-Square.jpg.jpg"
primary_image_credit = "Emma Char as Lucretia in Against the Grain Theatre's The Rape of Lucretia, TSMF, 2016. Photo by Jorge Chaves."
publishDate = "2016-07-24T10:45:00-04:00"
related_articles = ["articles/anna-theodosakis-directing-the-rape-of-lucretia.md","articles/banff-diaries-the-midway-report.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/the-banff-centre.md"]
related_people = ["scene/people/emma-char.md","scene/people/owen-mccausland.md","scene/people/chelsea-rus.md","scene/people/christopher-mokrzewski.md","scene/people/joel-ivany.md","scene/people/anna-theodosakis.md","scene/people/beste-kalender.md","scene/people/ellen-mcateer.md","scene/people/peter-rolfe-dauz.md","scene/people/iain-macneil.md"]
short_description = "In the title role, mezzo-soprano Emma Char, was every bit of the descriptions we hear of Lucretia at the beginning of the show. Delicate, pure, and lovely on stage, she had a groundedness that I really enjoyed. The whole space seemed to calm down when she stepped on stage - which was made all the more thrilling when her character shifts to a darker place after the events of Act II. "
slug = "in-review-the-rape-of-lucretia-at-tsmf"
title = "In review: The Rape of Lucretia at TSMF"
+++

Friday, July 22nd, 2016: the day Toronto almost melted. 

It was also the day I went to see the cast of [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/)'s *Rape of Lucretia* as part of the Toronto Summer Music Festival.

In what was billed as a semi-staged concert production of the Britten masterpiece, we found the Winter Garden Theatre rather exposed compared to what we're used to from our Opera Atelier experiences. No set, and the cyclorama upstage was opened completely to reveal anexposed brick wall. The orchestra occupied the upstage right area, exposed in a way that reminds you that this orchestra is also a very important part of the show. 

This cast was directed in Banff by Scottish director [Paul Curran](/talking-with-directors-paul-curran/) as part of the Open Space: Opera in the 21st Century program that sees the Banff Centre for the Arts teaming with Against the Grain Theatre and the [Canadian Opera Company](/scene/companies/canadian-opera-company/) to look at new ways of producing classic operas and how to push the boundaries of the art form in today's world. They've brought us such amazing works as *#UncleJohn* (a transladaptation of Mozart's *Don Giovanni*) and *A Little Too Cozy* (completing the Da Ponte trilogy with *Così fan tutte*). It was a treat to have this company brought forth by Toronto Summer Music Festival as part of their "London Calling" theme for this season. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1469370983775/2016-07-24---Lucretia-TSMF-Tarq-Luc.jpg.jpg)
<figcaption>Iain MacNeil (Tarquinius) and Emma Char (Lucretia) in *The Rape of Lucretia*, Toronto Summer Music Festival, 2016. Photo by Jorge Chaves.</figcaption>
</figure>

Conducted by AtG Music Director [Topher Mokrezewski](/scene/people/christopher-mokrzewski/), the 12-piece orchestra (plus Mokrzewski on piano) played Britten's score exquisitely. The tempi were a little more on the driven side, something that I really appreciated; it added an extra sense of drama and urgency to this very tense story line. I found it also helped inform the delivery of the Male and Female Chorus (sung by tenor [Owen McCausland](/scene/people/owen-mccausland/) and soprano [Chelsea Rus](/scene/people/chelsea-rus/)). Mokrzewski's handling of dynamic shifts were exciting, particularly when the music would change from Britten's washy soundscape into it's more martial/militaristic themes. Bravi, tutti! 

McCausland (who was under the weather) still sounded fantastic. I really like hearing him sing Britten. His easy diction and ability to flourish through all parts of his register were perfect for the difficult music written for the Male Chorus. Not to be outdone, Rus had a very sincere, almost musical theatre like delivery as well, with a spinto-like bloom over the top of her register. There was the occasional balance issue when she got into her lower range, but I attribute that more the the space than the musicality of those onstage. Their portrayal as "the conscience" of the characters in the drama was clear and concise; it was a very effective tool to help drive the choices of some of the characters on stage. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1469371060374/2016-07-24---Lucretia-TSMF-Coll-Luc-2.jpg.jpg)
<figcaption>Jasper Leever (Collatinus) and Emma Char (Lucretia) in *The Rape of Lucretia*, Toronto Summer Music Festival, 2016. Photo by Jorge Chaves.</figcaption>
</figure>

In the title role, mezzo-soprano [Emma Char](/scene/people/emma-char/), was every bit of the descriptions we hear of Lucretia at the beginning of the show. Delicate, pure, and lovely on stage, she had a groundedness that I really enjoyed. The whole space seemed to calm down when she stepped on stage - which was made all the more thrilling when her character shifts to a darker place after the events of Act II. Her fairly bright mezzo tone was never overdone and matched the delicateness of Britten's scoring in her music perfectly. Char has a beautiful sound that doesn't become aggressive as she goes over the top of her range. 

As Tarquinius, bass-baritone [Iain MacNeil](/scene/people/iain-macneil/) was perfectly cast. He communicated his princely upbringing with ease and made it easy for the audience to understand the life of privelege he's led up to this point. He was very good at playing the fine line between a man of importance (or future importance as the crown prince) and someone who's easily swayed by the council of others. His full rich tone mixed very well not only with Lucretia but also with the other men in his military company. It was a dark portrayal, and one I really enjoyed. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1469371019205/2016-07-24---Lucretia-TSMF-Men.jpg.jpg)
<figcaption>l-r: Iain MacNeil (Tarquinius), Jasper Leever (Collatinus), and Peter Rolfe Dauz (Junius) in *The Rape of Lucretia*, Toronto Summer Music Festival, 2016. Photo by Jorge Chaves.</figcaption>
</figure>

Bass-baritone [Jasper Leever](http://www.jasperleever.com/) and baritone [Peter Rolfe Dauz](/scene/people/peter-rolfe-dauz/) sang the roles of Collatinus (Lucretia's husband) and Junius respectively. Leever's Collatinus sounded glorious in the Winter Garden Theatre and Dauz's voice had a wonderful cut that carried his brighter sound all the way to the back of the hall - and maybe into the street. The dynamic forged between the three soldiers, and how that can quickly and easily turn when mixed with a little too much liquor, was handled very well. They managed to go as far as they needed in the ugliness of it all without being gratuitous. I really enjoyed the scene between Duaz and MacNeil where Junius goads Tarquinius, along with the help of the Male Chorus, to follow his nefarious urges and go to Lucretia in the town while the men sleep. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1469371083625/2016-07-24---Lucretia-TSMF-Ladies.jpg.jpg)
<figcaption>Clockwise from top: Ellen McAteer (Lucia), Emma Char (Lucretia), and Beste Kalender (Bianca) in *The Rape of Lucretia*, Toronto Summer Music Festival, 2016. Photo by Jorge Chaves.</figcaption>
</figure>

As Lucretia's nurse, Bianca, and her maid Lucia, mezzo-soprano [Beste Kalender](/scene/people/beste-kalender/) and soprano [Ellen McAteer](/scene/people/ellen-mcateer/) (respectively) gave probably my favourite singing of the night. As a comprimario performer, I'm a sucker for great ensemble singing, and these two sounded like they've been making music together their whole life. Kalender's rich, active, smooth mezzo and McAteer's twinkling soprano were a match made in heaven. I particularly enjoyed the way McAteer was able to finesse the musical lines to bring out more of the comedy inherent in the maid's character - something that this piece really needs to let the audience breathe for a moment during all the stress. 

Although this production was originally directed by Paul Curran, it was staged here by [Anna Theodosakis](/scene/people/anna-theodosakis/), who assisted Curran in Banff, and recently staged this same piece for [MyOpera](/scene/companies/myopera/). I felt it was essentially the same production we saw in the spring only with different singers. I feel like the Winter Garden may have been a little too big for Theodosakis's intimate interpretation of the piece, and the logistics of this classic proscenium environment occasionally found the singers in a difficult spot to engage with the audience and their fellow players. That being said, she did tap into the chemistry of Char's Lucretia and MacNeil's Tarquinius very well, and her use of the Male and Female Chorus not just as an omniscient narrator but as actual forces that drive some of their choices was very successful. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1469371218202/2016-07-24---Lucretia-TSMF-Coll-Luc.jpg.jpg)
<figcaption>Jasper Leever (Collatinus) and Emma Char (Lucretia) in *The Rape of Lucretia*, Toronto Summer Music Festival, 2016. Photo by Jorge Chaves.</figcaption>
</figure>

It was great so seeoOpera back on stage at the Toronto Summer Music Festival, and I hope that it can continue. Last night's packed house seems to show that it can! As our host for the evening, TSMF Spokesperson (and Canadian opera superstar) [Ben Heppner](/scene/people/ben-heppner/) intimated, opera is BACK! 

I couldn't agree more. 
