+++
author = ["authors/john-beckett.md"]
categories = "Review"
date = "2017-07-21T08:50:00-04:00"
lastmod = "2017-07-27T10:06:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501122583742/2017-07-26---Venice.jpg.jpg"
publishDate = "2017-07-26T23:04:00-04:00"
related_articles = ["articles/in-review-hamlet-at-glyndebourne.md","articles/jawdropping-the-nose-at-roh.md"]
related_companies = ["scene/companies/royal-opera-house.md","scene/companies/welsh-national-opera.md"]
related_people = ["scene/people/lester-lynch.md","scene/people/lauren-michelle.md","scene/people/sarah-castle.md","scene/people/martin-wolfel.md","scene/people/mark-le-brocq.md"]
short_description = "At the end, we were left feeling like this was too big a piece for Welsh National Opera to chew on. With most of the cast underwhelming and the orchestra&#039;s lack of musical interpretation, it wasn&#039;t easy to sit through. We&#039;re glad to feel uncomfortable in an opera because of sensitive issues is might broach, or because of a controversy it might cause. But in this case, we were just wondering if they would make it to the end."
slug = "in-review-the-merchant-of-venice"
title = "In review: The Merchant of Venice"
+++

[Welsh National Opera](/scene/companies/welsh-national-opera/) came to Covent Garden in a very short run of André Tchaikowsky's *The Merchant of Venice*. First performed in 2013 at the Bregenz Festival, Tchaikowsky's work was first written between 1968 and 1982. *The Merchant of Venice* was under consideration to be performed by English National Opera, but was not performed, and Tchaikowsky died shortly after in 1982. 

As with any operatic adaptation of a Shakespeare play, the libretto has been shaped to show the creators' take on the original script. Here we have Tchaikowsky, who lived in Nazi-occupied Poland, was severly depressive, and a gay man, the most striking themes in *The Merchant of Venice* have to do with the persecution of Shylock, with Antonio's mental state being a unifier throughout the piece.

As far as Shakespearean plays go, to say that *The Merchant of Venice* is pretty anti-semitic would be an understatement. And it is because of this fact that it is so interesting to see Tchaikowsky's setting of the piece. Throughout the opera we see the belittlement and discrimination against Shylock, a wealthy Jewish man living in the overwhelmingly Christian city of Venice. Shylock and his daughter Jessica are the only Jewish characters in the opera, and in this production that fact was starkened by casting these two characters as black singers in an otherwise white cast.

The pictures on stage, courtesy of designer Ashley Martin-Davis, were sleek and aesthetically pleasing. Tall panels represented the world of Venice, dark and imposing, encapsulating the money-lenders and court officials of the city in a bleak darkness. Belmont was opened up by a hedge-maze, the pattern of which was cleverly projected onto the back wall of the stage.

Musically, the experience seemed to be bombarded by countless fortissimo passages, with the same intervals repeated and eventually losing dramatic meaning. Nearly all of the singers sang with such a wide vibrato - one that some might consider to be a wobble - thus making the text difficult to make sense of. The exception to this came in the father-daughter pairing of Shylock and Jessica, sung by the powerful [Lester Lynch](/scene/people/lester-lynch/) and wonderfully expressive [Lauren Michelle](/scene/people/lauren-michelle/). Lynch's speech in Act III had everyone gasping, filled with sympathy for the discrimination that this Jewish man is made to face throughout the opera and in his entire life.

[Martin Wölfel](/scene/people/martin-wolfel/) didn't seem up for the role of Antonio - his singing was incomprehensible and his presence on stage was awkward. While Lynch showed the torture of his race, Wölfel didn't inhabit the characterization of a depressive and closeted gay man that Tchaikowsky's adaptation needs. [Sarah Castle](/scene/people/sarah-castle/)'s Portia was confident and sure, although at times a bit scary to listen to vocally. Bassanio, played by [Mark Le Brocq](/scene/people/mark-le-brocq/), seems to be a monster of a role, and while Le Brocq had a ringy voice, his change of register for the highest notes in the score was distracting.

At the end, it was hard to shake the feeling like this was too big a piece for Welsh National Opera to chew on. With most of the cast underwhelming and the orchestra's lack of musical interpretation, it wasn't easy to sit through. It's a good thing to feel uncomfortable in an opera because of sensitive issues is might broach, or because of a controversy it might cause. But this was a case of just wondering if they would make it to the end.
