+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-11-13T12:08:00+00:00"
lastmod = "2016-11-14T12:14:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479120396655/2016-11-15---Square-161107_0964-oreste-adj-ANGELA-SIMKIN-AS-ORESTE-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg"
primary_image_credit = "Angela Simkin as Oreste, (c) ROH, 2016. Photo by Clive Barda."
publishDate = "2016-11-14T12:13:00+00:00"
related_articles = ["articles/dynamic-and-physical-rinaldo-at-oper-frankfurt.md","articles/akhmetshinas-devastating-carmen-at-wiltons-music-hall.md","articles/a-product-of-great-artistry-the-return-of-ulysses-at-the-roundhouse.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/vlada-borovko.md","scene/people/angela-simkin.md","scene/people/thomas-atkins.md","scene/people/jennifer-davis.md","scene/people/simon-shibambu.md","scene/people/nick-fletcher.md","scene/people/emily-edmonds.md"]
short_description = "The action unfolds in the graffiti-covered, industrial corners of what could be any contemporary city. During the overture, we were treated with a picture of the goings-on under Toante: a ruthless leader, his witless captain of the guard, and a near-mad Ifigenia, who through rogue mascara, bludgeons to death one unlucky visitor with a hammer. Narrative hook, indeed."
slug = "in-review-the-jette-parker-young-artists-present-oreste-"
title = "In review: the Jette Parker Young Artists present Oreste "
+++

Two hundred and eighty-two years after its first performance as part of the 1734/35 Covent Garden season, members of the Royal Opera's Jette Parker Young Artists Programme have put up *Oreste* at Wilton's Music Hall. *Oreste* is one of three *pasticcio* operas by Handel; set to an anonymous libretto after Euripides' *Iphigenia in Tauris* and Barlocci's *L'Oreste*, it is essentially a collection of previously-written music. The *pasticcio* caught on in the 18th century, in part because the genre allowed for audiences to hear popular arias again.

Director [Gerard Jones](http://www.roh.org.uk/people/gerard-jones) took literally the crumbling world of Toante's island, where foreigners are brutally sacrificed; the action unfolds in the graffiti-covered, industrial corners of what could be any contemporary city. During the overture, we were treated with a picture of the goings-on under Toante: a ruthless leader, his witless captain of the guard, and a near-mad Ifigenia, who through rogue mascara, bludgeons to death one unlucky visitor with a hammer. Narrative hook, indeed.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479120734471/2016-11-15---161107_0773-oreste-adj-JENNIFER-DAVIS-AS-IFIGENIA-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)<figcaption>Jennifer Davis as Ifigenia in *Oreste*, (c) ROH, 2016. Photo by Clive Barda.</figcaption>
</figure>

Thus begins a story of familiarities: adults who had been abandoned earlier in life, leaders who rely on blunt force to compensate for their nonsensical claim to power, love unrequited, and mental illness. Jones made the impressive decision to get specific about the world he imagines for these characters. Their reality is tangible, with its kitschy "home decor" and familiar-looking clothes; the gruesome exists, too, including the brutal miming of body dismemberment, limbs sloppily stuffed into garbage bags, and the eerie timing of smoke escaping from a chimney shortly after the latest human sacrifice.

Yet the specificity of Jones' world, at times, seemed almost restrictive. Oreste struggles to maintain his sanity, and he demonstrates that blurred line with physical tics, and private conversations with the graffiti on the walls. The vocal demands of the role seemed to interrupt this picture of mental illness; while Oreste was silent, he was a muttering hand-wringer, and while he sang, he was - necessarily - a poised singer. Filotete, hopelessly in love/lust with Ifigenia, becomes a dangerous picture of a teased, manipulated man; as a Christopher Alden-esque piture of not-quite-right-in-the-head, he earned more nervous laughter than fear. These images, though inspired by the story and score, seemed a sane man's vision of insanity, and a removed stereotype of a friend-zoned blue-collar-type.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479120551784/2016-11-15---161107_1115-oreste-adj-JENNIFER-DAVIS-AS-IFIGENIA-ANGELA-SIMKIN-AS-ORESTE-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>(c) ROH, 2016. Photo by Clive Barda.</figcaption>
</figure>

Amid the squalid, heartless world came smart singing from across the cast of six singers. In the title role, [Angela Simkin](/scene/people/angela-simkim/) drew us in with her rich, clear mezzo; she, along with [Jennifer Davis](/scene/people/jennifer-davis/) as Ifigenia, had subtlety in her sound, layers of humanity that set the long-lost siblings apart as (ironically) the sanest characters of the story. Simkin's Oreste sang with plaintive wails and fiery coloratura, and Davis' control over her instrument showed us a three-dimensional Ifigenia, resisting her horrific circstances.

As Oreste's imprisoned friend, Pilade, [Thomas Atkins](/scene/people/thomas-atkins/) sang with what felt like a hit of Verdi. Though robust, he boasted agility and clean singing, making us eager to hear him in more Handel. His Act II aria, full of vocal fireworks, kept us rapt with his eyes. It was Pilade who seemed to be the foil to Toante, sung by [Simon Shibambu](/scene/people/simon-shibambu/) with a powerful ring in his sound. Shibambu was certainly dangerous and menacing; yet the demonstrative staging, roughly reminiscent of Baroque gesture, seemed to keep him on the outskirts of the "real".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479120621556/2016-11-15---161107_1082-oreste-adj-SIMON-SHIBAMBU-AS-TOANTE-VLADA-BOROVKO-AS-ERMIONE-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>(c) ROH, 2016. Photo by Clive Barda.</figcaption>
</figure>

Soprano [Vlada Borovko](/scene/people/vlada-borovko/) looked like Park Avenue had stumbled into Brooklyn as Oreste's wife, Ermione. She sang with a bird-like, clear-as-a-bell soprano that seemed perfectly naïve; her arias - excellently sung - spanned everything from understated and prayer-like to pyrotechnic and wild. The stakes didn't quite seem high enough for her character arc, however; the threat of rape by Toante felt luke-warm, and Ermione's turn on the violent leader felt less like a woman taking power, and more like the leadership's growing slack. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479120982273/2016-11-15---161107_0903-oreste-adj-PRODUCTION-IMAGE-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>(c) ROH, 2016. Photo by Clive Barda.</figcaption>
</figure>

As Filotete, [Gyula Nagy](/talking-with-singers-gyula-nagy/) was rough around the edges, and even moreso than Oreste, seemed to flirt with insanity. Nagy best maintained consistency of character throughout the pieces, uninterrupted by his arias; his love for Ifigenia was made crystal clear, yet his moments of exaggeration seemed to dampen the real threat of danger, and make him more pitiable than fearsome.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479121018351/2016-11-15---161104_0013-oreste-adj-ROH-Photo-by-Clive-Bardajpg)
<figcaption>(c) ROH, 2016. Photo by Clive Barda.</figcaption>
</figure>

[James Hendry](https://twitter.com/jameshconductor) led a sparkling Southbank Sinfonia, and [Nick Fletcher](/nick-fletcher-reps-at-the-roh/) was a sympathetic storyteller at the harpsichord. There was listening on both sides of the orchestra, Hendry leaving room for the singers, while maintaining a distinct pace for the show. Between numbers, we craved less empty space; it seemed that the orchestra was waiting for applause after arias, yet Jones' staging propelled the action forward.

This *Oreste* is an impressive showcase of the high standards among the Jette Parker Young Artists; their musicianship is smart, and Jones' production is a feast for the eyes. The [near-sold-out run](http://www.roh.org.uk/productions/oreste-by-richard-gerard-jones) continues until November 19 at Wilton's Music Hall. For full details and ticket information, [click here.](http://www.roh.org.uk/productions/oreste-by-richard-gerard-jones)
