+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-03-22T10:16:00+00:00"
lastmod = "2017-03-22T13:39:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490180524663/2017-03-22---CO---Square---Alessandro-Fisher.jpg.jpg"
primary_image_credit = "Alessandro Fisher in The First Commandment, March 2017. Photo by Sebastiano Ragusa."
publishDate = "2017-03-22T12:28:00+00:00"
related_articles = ["articles/la-finta-giardiniera-coming-to-a-garden-near-you.md"]
related_companies = ["scene/companies/classical-opera.md"]
related_people = ["scene/people/alessandro-fisher.md","scene/people/gemma-summerfield.md"]
short_description = "&quot;Flaws&quot; like an overly thick orchestration, or a vocal tessitura that is relentless and awkward, are what thrill the lovers of music history; it&#039;s indicative of just how much of a genius Mozart was, that moments of orchestra imbalance or slightly less organic melodies - largely harmless in the big picture - seem the &quot;rudimentary&quot; product of 11 year-old Wolfgang."
slug = "in-review-the-first-commandment"
title = "In review: The First Commandment"
+++

Continuing its fascinating MOZART 250 project, which chronologically presents the works of W.A. Mozart in the 250th year of their composition, [Classical Opera](/ian-page-mozart-imagination/) presents the little-known *Die Schuldigkeit des ersten Gebots*, K. 35, or *The First Commandment* (though the original German title better translates to, "The obligation of the first commandment"). Written in 1767 when Mozart was just 11 years old, the work marks the composer's first extended dramatic work. His *The First Commandment* is the first of three parts, the latter two written by Michael Haydn and Anton Adlgasser, respectively; it was first presented over three consecutive Thursdays during Lent in 1767, and Mozart's portion even received an encore performance.

The libretto speaks to the small-town nature of Mozart's native Salzburg. It was written by Ignaz Anton Weiser, who would become one of the town's mayors, and who had also written texts for works by Mozart's father, Leopold; interestingly enough, Weiser was the half-brother of Maria Theresia Hagenauer, the Mozarts' landlady in Salzburg, and his granddaughter was Josefa Dušek, the famed soprano for whom Mozart would write two of his concert arias.

Even if you're not a history fan, there's plenty that's fascinating about *The First Commandment*. Even at 11 years old, Mozart had a clear instinct for writing for the voice; Mozart writes with all the stubborn imagination one would expect of a child, complete with enormous leaps, juicy chromatic surprises, vocal gestures of sighing and laughing, and accompanied recitatives to rival the drama of Handel or even Weber. 

These are the inherent qualities that we love and admire about "perfect" operas like *Le nozze di Figaro* or *Don Giovanni*, and it's an incredible thing to hear some of his best ideas, preceded by two decades. The large interval leaps he gives to the characters in *The First Commandment*, he used later with characters like Fiordiligi in *Così fan tutte*; he proves an early knack for dramatic timing with Compassion's aria, which leads purposefully into the next recitative with no place for applause, a trick that always gives us chills at the end of Vitellia's final aria in *La clemenza di Tito*.

"Flaws" like an overly thick orchestration, or a vocal tessitura that is relentless and awkward, are what thrill the lovers of music history; it's indicative of just how much of a genius Mozart was, that moments of orchestra imbalance or slightly less organic melodies - largely harmless in the big picture - seem the "rudimentary" product of 11 year-old Wolfgang.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490184322733/2017-03-22---CO---Sam-Furness-Gemma-Summerfield.jpg.jpg)
<figcaption>Sam Furness and Gemma Summerfield in Classical Opera's *The First Commandment*, 2017. Photo by Sebastiano Ragusa.</figcaption>
</figure>

Under conductor and Artistic Director [Ian Page](/ian-page-mozart-imagination/), the Classical Opera orchestra plays with a palpable thrill that no doubt would have pleased Mozart. There's something entirely ego-free about Classical Opera's mission, a true love of the music placed in the forefront. A strong cast of five singers bring to life *The First Commandment*, which tells the slightly irreverent tale of a Christian who succumbs to the earthly pleasures of drink and sex, and the spirits of Christianity, Justice, Compassion, and Worldliness, who each make their case for being the fallen man's wisest path.

Though he suffered from bronchitis, [Alessandro Fisher](/talking-with-singers-alessandro-fisher/) showed off a clear, friendly tenor that seemed undeniably human. [Gemma Summerfield](/scene/people/gemma-summerfield/) and [Helen Sherman](/scene/people/helen-sherman/) were equal parts preachy and wise as Compassion and Justice, each impressive in their demanding arias. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490184372222/2017-03-22---CO---Helen-Sherman-Alessandro-Fisher.jpg.jpg)
<figcaption>Helen Sherman in Classical Opera's *The First Commandment*, 2017. Photo by Sebastiano Ragusa.</figcaption>
</figure>

Tenor [Sam Furness](/scene/people/sam-furness/) paired virile strength with admirable agility as the Christian Spirit; he found the humour - and the obvious psychological projection - in his second aria, singing, "Too much pleasure causes pain". Soprano [Rebecca Bottone](/scene/people/rebecca-bottone/) sang with thrilling personality - and a few hints of [Audrey Luna](/talking-with-singers-audrey-luna/) - as Worldly Spirit, proving that Mozart always did love to pair a coloratura soprano with the characters who have a so-bad-it's-a-good-influence on the hero of the story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490184395135/2017-03-22---CO---Rebecca-Bottone.jpg.jpg)
<figcaption>Rebecca Bottone in Classical Opera's *The First Commandment*, 2017. Photo by Sebastiano Ragusa.</figcaption>
</figure>

*The First Commandment* plays again tonight, **7:30pm at St. John's Smith Square**. It's a compact, delightful time, and worth hearing some serious talent. For more details and ticket information, [click here.](http://www.classicalopera.co.uk/performances/mozart-first-commandment/) If you miss the live show, you can hear [Classical Opera's recording of *The First Commandment*](http://www.classicalopera.co.uk/recordings/die-schuldigkeit/?content=intro), featuring [Allan Clayton](/scene/people/allan-clayton/) as Christian.
