+++
author = ["authors/john-beckett.md"]
categories = "Review"
date = "2017-04-25T08:46:00-04:00"
lastmod = "2017-04-25T09:37:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493125431453/2017-04-25---Square-IESTYN-DAVIES-SALLY-MATTHEWS-C-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg"
publishDate = "2017-04-25T09:21:00-04:00"
related_articles = ["articles/in-review-written-on-skin-at-roh.md","articles/in-review-lucia-di-lammermoor-at-roh.md","articles/discomfort-louis-riel-at-the-coc.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/audrey-luna.md","scene/people/sir-john-tomlinson.md","scene/people/christine-rice.md","scene/people/sophie-bevan.md"]
short_description = "The guests arrive on stage, dressed in retro evening wear that reminded us of Jonathan Lynn’s Clue. We are prepared for a drawing room comedy to start, but are immediately informed that something is not right by the servants&#039; departure from the grand mansion. We also know something&#039;s up when, in a genius expository tool, the guests arrive together a second time: they repeat the formal introductions from character to character, as if they are all trapped in a loop."
slug = "in-review-the-exterminating-angel-at-roh"
title = "In review: The Exterminating Angel at ROH"
+++

Around 7:15 in the evening while standing in the foyer of the Royal Opera House, we realized the presence of bells ringing all throughout the building. We are herded into our seats only to be greeted by three of London’s most infamous performers at the moment: a small flock of live sheep. It is the evening that we have been eagerly awaiting - the UK premiere of Thomas Adès and Tom Cairns’ new opera, [*The Exterminating Angel*](http://www.roh.org.uk/productions/the-exterminating-angel-by-tom-cairns).

The guests arrive on stage, dressed in retro evening wear that reminded us of Jonathan Lynn’s *Clue*. We are prepared for a drawing room comedy to start, but are immediately informed that something is not right by the servants' departure from the grand mansion. We also know something's up when, in a genius expository tool, the guests arrive together a second time: they repeat the formal introductions from character to character, as if they are all trapped in a loop.

Dinner is served, and the central problem of the story becomes increasingly clear: none of the guests are able to exit past the threshold of the dining room - made explicit by the giant proscenium arch that frames the living room. As characters approach the arch or make attempts to leave, we hear the ominous, otherworldly sound of the ondes martenot, meant to represent the exterminating angel itself.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493125668491/2017-04-25--JOHN-TOMLINSON-CENTRE-EXTERMINATING-ANGEL-PRODUCTION-IMAGE-C-ROH.-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>John Tomlinson (centre) in *The Exterminating Angel*, ROH, 2017. Photo by Clive Barda.</figcaption>
</figure>

*The Exterminating Angel* works so well as an opera for this reason. Buñuel’s film leaves the audience questioning, "Why don't they all just leave?" The force of the exterminating angel is invisible and symbolic in the black and white film. In the opera, the force is characterized into music - what better way than to characterize this fleeting and foreboding symbol than into the indescribable and immeasurable art of electronic music? The exterminating angel is of course a character as it is central to the plot, but it is of course not a character as it is just made up of sounds.

Here lies the genius of Thomas Adès - he has the ability to write accessible music while keeping integrity in the surrealist nature of Buñuel's work and in his own musical style, his language being made up of elements from deformed Viennese Waltz to drumming from Buñuel's hometown of Calanda.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493125691343/2017-04-25--EXTERMINATING-ANGEL-PRODUCTION-IMAGE-2-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>Production image from *The Exterminating Angel*, ROH, 2017. Photo by Clive Barda.</figcaption>
</figure>

As is the case in his other two operas, there is no possible way this opera could not be performed without a stellar cast of singers. The ensemble of dinner guests is written for such a high caliber group of artists, and it was the distinction of these characters that made for such an incredible ensemble.

Adès is constantly pushing singers to technical limits in his vocal writing. Our hostess, Lucìa, sings in a high and sustained tessitura that has to sing over orchestral texture as thick as Tosca’s. Leticia, the opera singer, is charged with constant singing above the staff while making the English text comprehensible - it's the range of Queen of the Night with the added struggle of consonants. Raùl must squeal high notes out of long lines, think "Ah, mes amis" without the preparatory beats of rest before the high C's.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493125734793/2017-04-25--AUDREY-LUNA-CENTRE-EXTERMINATING-ANGEL-PRODUCTION-IMAGE-C-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>Audrey Luna (centre) in *The Exterminating Angel*, ROH, 2017. Photo by Clive Barda.</figcaption>
</figure>

Cairns gives some of the most fabulously ridiculous text to Francisco de Àvila - the countertenor role. Trapped in a similar situation, some of us might be worried about food and water - Francisco is more concerned with the horror of stirring his coffee with a teaspoon, with Blanca's miserable attempt at combing only half of her hair, and with his slaughtered lamb being cooked à point over their makeshift fire.

While certainly the most faffy of the characters, Francisco and his sister Silvia, with whom he is in an incestuous relationship, represent the upper class and their resentment for those like Blanca and Leticia, who, although dinner guests, are not members of the aristocracy. 

In the beginning of the opera the difference between these two classes is astoundingly marked: we get a monologue from Silvia, recounting her experience on a train that was derailed in the south of France. As she describes the tragedy, she remarks that she feels no remorse for the lower class people who were killed on the train. Silvia also exclaims that in this instance she was running from one end of the train to the other like a madwoman, foreshadowing the collapse of the Nobiles' sanity while trapped in the mansion.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493125761182/2017-04-25--THOMAS-ALLEN-AMANDA-ECHALAZ-DAVID-ADAM-MOORE-JOHN-TOMLINSON-C-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>Thomas Allen, Amanda Echalaz, David Adam Moore, and John Tomlinson in *The Exterminating Angel*, ROH, 2017. Photo by Clive Barda.</figcaption>
</figure>

As the situation becomes more dire and the guests realize how trapped they are becoming, we see Blanca terrified for what will happen to her children. Silvia, the regular high-society woman that she is, seems perfectly fine to leave her son, Yoli, with his private tutor for a few days. Some humanity returns to Silvia, when during act three she cradles the corpse of a dead lamb believing it to be Yoli - it was a stunning moment of love and humility amidst chaos.

Adès and Cairns show the darkness and light that exists within all of the characters. As we fell in love with the engaged couple Eduardo and Beatriz, we were heart broken during their love duet that doubled as a suicide pact. The the moment we find ourselves rooting for the guests to survive, they suddenly turn on each other and propose to murder their host.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493125835259/2017-04-25--SOPHIE-BEVAN-ED-LYON-ROH-PHOTO-BY-CLIVE-BARDA.jpg.jpg)
<figcaption>Sophie Bevan and Ed Lyon in *The Exterminating Angel*, ROH, 2017. Photo by Clive Barda.</figcaption>
</figure>

Looking back on the three acts of *The Exterminating Angel*, it is with confidence that we say that every single moment was needed - there was a purpose for every note, every word, every breath taken throughout the night. How fitting it is to the surrealist story that the purpose for all of this was to serve the point that there is no purpose.

Get your tickets for this immediately - we can't wait to see it again. [*The Exterminating Angel*](http://www.roh.org.uk/productions/the-exterminating-angel-by-tom-cairns) plays at the Royal Opera House through **May 8th** before it is taken to New York this fall.

