+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-04-20T10:03:00-04:00"
lastmod = "2015-04-22T13:17:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429538555915/Barber-MC-1761.jpg.jpg"
primary_image_credit = "Renato Girolami as Doctor Bartolo & Joshua Hopkins as Figaro in the COC's The Barber of Seville, 2015. Photo: Michael Cooper"
publishDate = "2015-04-20T11:57:00-04:00"
related_articles = ["articles/in-review-the-marriage-of-figaro.md","articles/calgary-opera-delivers-comedy-gold-with-wellcast-barber.md"]
related_companies = ["scene/companies/canadian-opera-company-ensemble-studio.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/alek-shrader.md","scene/people/joshua-hopkins.md","scene/people/serena-malfi.md","scene/people/robert-gleadow.md","scene/people/aviva-fortunata.md","scene/people/ferruccio-furlanetto.md"]
short_description = "I went yesterday afternoon to see The Barber of Seville at the Four Seasons Centre. The anticipation was serious, especially since I was able to see the director&#039;s concept discussion, and I interviewed three singers from the cast, Joshua Hopkins, Alek Shrader, and Serena Malfi."
slug = "in-review-the-barber-of-seville-at-the-coc"
title = "In review: The Barber of Seville at the COC"
+++

I went yesterday afternoon to see [*The Barber of Seville*](http://www.coc.ca/PerformancesAndTickets/1415Season/BarberofSeville.aspx) at the Four Seasons Centre. The anticipation was serious, especially since I was able to see the director's concept discussion, and I interviewed three singers from the cast ([Joshua Hopkins](/talking-figaro-with-joshua-hopkins/), [Alek Shrader](/talking-with-counts-alek-shrader/), and [Serena Malfi](/serena-malfi-on-singing-rosina/)). So, I was fairly hyped up for this production, and full of curiosity.

Director Joan Font creates an exaggerated world of characters, which I think works beautifully with the cartoon-like pacing in Rossini's score. Font started with the *Commedia dell'arte*, connecting Figaro with Harlequin, Rosina with Colombina, and Dottor Bartolo with Pantalone. Font writes, "they are prototypes of humanity played in a symbolic manner and able to create absurd, delirious, surreal, comical and ironic situations and actions."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429540782546/Barber-MC-0370.jpg.jpg)
<figcaption>
l-r: Alek Shrader (Almaviva) and Joshua Hopkins (Figaro). Photo by Michael Cooper. </figcaption>
</figure>

Tenor [Alek Shrader](https://twitter.com/alekshrader) kicked off this surreal world with an impressive "Ecco ridente." Shrader mentioned to me that this was his 11th run as Count Almaviva, and I thought it showed in a great way. Alek spent the entire role prioritizing the story and humour over everything else. He took huge risks in "Ecco," moving in and out of his full, balanced tenor sound, and using moments of *sotto voce* and extra-flowery *fioratura*. There was no doubt that we were allowed to laugh at the Count's overdone serenade to Rosina, and I loved that Shrader hammed it up. He showed us that he was a serious singer more than once during the show, and I loved that he had nothing to prove; I found myself sympathizing with Almaviva more than I usually do in *Barber*. Also, Alek's air piano was some of the best I've ever seen. See, this is the fun part of hearing a singer in a role they know so well.

As Figaro, Canadian baritone [Joshua Hopkins](http://joshuahopkins.com/) was, well, perfect. He didn't break a sweat in "Largo al factotum," and he found ease in the rest of the demanding role. He too put storytelling in front of everything else, yet he never lacked for a gorgeous sound. For me, Joshua found the best connection between his voice and body. The production's large gestures fell often on Figaro, and he found musical moments for all the right movements. The proof was in the audience's laughter. Together, Joshua and Alek had fantastic comic chemistry, and their Act I duet had me grinning from ear to ear.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429540929977/Barber-MC-1230.jpg.jpg)
<figcaption>
l-r: Joshua Hopkins (Figaro), Alek Shrader (Almaviva), Serena Malfi (Rosina), Robert Gleadow (Basilio), Aviva Fortunata (Berta), Renato Girolami (Bartolo). Photo by Michael Cooper </figcaption>
</figure>

[Serena Malfi](http://www.serenamalfi.com/) sang with a really rich, beautiful mezzo sound, and showed off her impressive high register. I didn't get the sense of fun in her Rosina, though. Her coloratura was clean and clear, but it didn't quite sound free, or have that feeling of improvisation. She had more fun in the second act, yet I still found her subdued, perhaps in comparison to some of her castmates.

[Renato Girolami](http://www.renatogirolami.com/mobile/index.php) as Dr. Bartolo was a study in buffo characters. He was a blustering tryant with anger issues, who seemed like he may actually give Figaro and Almaviva a run for their money. Girolami is a veteran with Rossini buffo roles, and it completely showed. I loved him.

Robert Gleadow was similar as Basilio; he's a tall guy, but the prosthetic nose, semi-bald cap, and exaggerated movements made his chracterization super-sized, so it could be super-funny. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429542314601/Barber-MC-0473.jpg.jpg)
<figcaption>
l-r: Renato Girolami (Bartolo) and Robert Gleadow (Basilio). Photo by Michael Cooper.
</figcaption>
</figure>

As Berta, Rosina's governess, Aviva Fortunata was hilarious. She had all that "listening action" that can be so full of comic moments; I want to see it again, and sit a bit closer, because I have a feeling Aviva had some priceless facial expressions. I was glad they kept Berta's aria for her, too. 

COC Ensemble members Iain MacNeil (Fiorello) and Clarence Frazer (Officer) showed off solid singing and great comic stage presence. I'm really excited to see them in their roles for the Ensemble Studio Performance of *Barber* on May 15th. Frazer will take the role of Figaro, and MacNeil will become Dr. Bartolo. For full details and tickets to the show, [click here](http://www.coc.ca/PerformancesAndTickets/1415Season/BarberofSeville/EnsembleStudioPerformance.aspx). 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429543509861/Barber-MC-1483.jpg.jpg)
<figcaption> Alek Shrader (Almaviva/Basilio), and Serena Malfi (Rosina). Photo by Michael Cooper. </figcaption>
</figure>

The orchestra sounded shiny and spectacular in that really famous overture, under the baton of Rory Macdonald. I thought a few of his tempi were a little heavy, and there were moments where I thought he could have gone more with the singers. I wondered how much license he gave to the cast in terms of ornamentation and cadenzas. A few numbers felt like the ended a little flat, and I wondered if we could have done with a couple more cheesy high notes on fermatas.

The production was endlessly interesting to watch. Eleven actors shared the stage with the cast and chorus, physicalizing important moments in the story. They had great mini-scenes during Basilio's "La calunnia" and Berta's "Il vecchiotto cerca moglie." Figaro had five actor doppelgängers during "Largo al factotum," demonstrating Figaro's true Renaissance-manness. I thought they were brilliant, moving so uniquely and specifically that they had developed their own silent characters. Many of the actors were hanging around Bartolo's place; I figure they're some of his longer-term patients. The old woman seated downstage for large portions of the opera had her own secret stories going on, and they kept me curious and laughing.

There were a few stilted moments in the show, as if the elements onstage weren't organically connected to each other. Despite the exaggerated production, some of the comic moments weren't quite big enough. Some of these moments I think could have been solved by having less good taste in the orchestra pit (over-the-top music to go with the over-the-top everything else). I'll see it again on May 15th, for the Ensemble Studio performance, and I'm curious to see how the show settles between now and then, and what happens with a brand new cast.

In short, I highly recommend *The Barber of Seville*. Totally entertaining, great singing, and that's sort of all you need. For more information about this production, check out the box office link below.

