+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-09-13T23:43:00+01:00"
lastmod = "2016-09-14T10:34:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1473807100251/2016-09-14---VITO-PRIANTE-AS-FIGARO-DANIELA-MACK-AS-ROSINA-IL-BARBIERE-DI-SIVIGLIA-ROH-PHOTO-MARK-DOUET.jpg.jpg"
primary_image_credit = "Vito Priante as Figaro, Daniela Mack as Rosina, Il barbiere di Siviglia. © ROH. Photo by Mark Douet."
publishDate = "2016-09-14T10:15:00+01:00"
related_articles = ["articles/in-review-norma-at-roh.md","articles/in-review-cosi-fan-tutte-at-roh.md","articles/calgary-opera-delivers-comedy-gold-with-wellcast-barber.md","articles/leonard-reigns-as-rosina-in-wnos-barber.md","articles/opera-5-new-faces-new-show.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/javier-camarena.md","scene/people/daniela-mack.md","scene/people/vito-priante.md"]
short_description = "In theory, having a cast of big, hall-filling voices can seem like a pointless exercise (a futile precaution?), when the whole opera is designed to clear the way for easy, flexible, and funny singing. Yet this cast was a complete win from top to bottom; as they each sang their first notes of the evening, we were struck (and satisfied) with how these rich, go-big-or-go-home voices managed everything from dizzying coloratura to cackling comedy."
slug = "in-review-the-barber-of-seville-at-roh"
title = "In review: The Barber of Seville at ROH"
+++

The neat thing about *Il barbiere di Siviglia* is that it can become as grand or as intimate as you like. The production by Moshe Leiser and Patrice Caurier, which opened last night at the [Royal Opera House](http://www.roh.org.uk/productions/il-barbiere-di-siviglia-by-moshe-leiser-and-patrice-caurier), has a curious knack for reaping the benefits of both. Christian Fenouillat's set design seems to shrink the stage, and thrust it right out towards the audience; it's an effect delightfully reminiscent of when we went to see the Marionetten Theater in Salzburg. The production finds its roots along that tricky spectrum between real people and exaggerated archetypes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1473807217681/2016-09-14---VITO-PRIANTE-AS-FIGARO-JAVIER-CAMARENA-AS-COUNT-ALMAVIVA-IL-BARBIERE-DI-SIVIGLIA-ROH-PHOTO-MARK-DOUET.jpg.jpg)<figcaption>Vito Priante as Figaro, Javier Camarena as Count Almaviva, *Il barbiere di Siviglia*, ROH. Photo: Mark Douet.</figcaption>
</figure>

This *Barbiere* got laughs almost immediately, thanks to the men of the Royal Opera Chorus. The serenaders were decked out in orchestra black, with a full pit's worth of instruments on hand, and they clumsily poured themselves into place for Almaviva's first aria of the evening. The scene was a great set-up for a production that always had more than one interesting thing happening at once. The look was surreal, and the people were real, and it let us vascillate between laughter and sympathy. 

In theory, having a cast of big, hall-filling voices can seem like a pointless exercise (a futile precaution?), when the whole opera is designed to clear the way for easy, flexible, and funny singing. Yet this cast was a complete win from top to bottom; as they each sang their first notes of the evening, we were struck (and satisfied) with how these rich, go-big-or-go-home voices managed everything from dizzying coloratura to cackling comedy.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1473843718922/2016-09-14---VITO-PRIANTE-AS-FIGARO-DANIELA-MACK-AS-ROSINA-IL-BARBIERE-DI-SIVIGLIA-ROH-PHOTO-MARK-DOUET-2.jpg.jpg)
<figcaption>*Il barbiere di Siviglia*, ROH. Photo: Mark Douet.</figcaption>
</figure>

In the title role, [Vito Priante](/scene/people/vito-priante/) made a completely fun entrance through the house, adding quick banter with the audience between hollered Italian syllables. His sound was masculine, with an appealing wolfish grit. Priante's Figaro gave a beautifully simple answer to the question of why the town barber is such a popular guy: he's *sexy*. He bravely sang all those high G's, perhaps even an optional high A, all the while making the audience like him. Priante may be our preferred Figaro-du-jour.

Making his ROH debut, [Javier Camarena](/scene/people/javier-camarena/) was even better than expected as Count Almaviva. He moved like the wind, but took every opportunity to make a beautiful, thrilling tenor sound that filled the house (and a few soft moments to make us swoon). He had a perfect partner (also in her ROH debut) in [Daniela Mack](/talking-with-singers-daniela-mack/) as Rosina, who seemed to have an endless, smooth sound from rich chest singing, up to her thrilling top notes. She too brought out the *bel* in *bel canto*, and her Rosina was one of the first that we've genuinely liked.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1473843797005/2016-09-14---DANIELA-MACK-AS-ROSINA-JAVIER-CAMARENA-AS-COUNT-ALMAVIVA-IL-BARBIERE-DI-SIVIGLIA-ROH-PHOTO-MARK-DOUET.jpg.jpg)
<figcaption>Daniela Mack as Rosina, Javier Camarena as Count Almaviva, *Il barbiere di Siviglia*, ROH. Photo: Mark Douet.</figcaption>
</figure>

There was a touching moment during the storm scene, which in this production was all about Rosina's constantly frustrated quest for freedom. Throughout the show, Mack made it clear that what Rosina wanted - even more so than to be with "Lindoro" - was to get out of Bartolo's house. When the final blow seems to come, Rosina's rage was a beautiful moment of human behaviour, one that we saw rise up and boil over. 

José Fardilha was a beautiful Bartolo, blustering when needed, a perfect straight-man, even a little bit sympathetic, and always options to spare with his voice. A ridiculous character, no doubt, but still left room to share the silly-villain spotlight with Ferruccio Furlanetto as Don Basilio. Furlanetto's enormous sound was a comic device in itself, and it went beautifully with his looming, tall frame. His "La calunnia" was super-sized, delivered maniacally in an absurdly resonant sound. A properly crazy voice teacher, this Basilio.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1473843828539/2016-09-14---JOSE-FARDILHA-AS-DOCTOR-BARTOLO-FERRUCCIO-FURLANETTO-AS-DON-BASILIO-IL-BARBIERE-DI-SIVIGLIA-ROH-PHOTO-MARK-DOUET.jpg.jpg)
<figcaption>Ferruccio Furlanetto as Don Basilio, José Fardilha as Doctor Bartolo, *Il barbiere di Siviglia*, ROH. Photo: Mark Douet.</figcaption>
</figure>

Madeleine Pierard's Berta and Gyula Nagy's Fiorello were great layers of spice in this version of Seville. Directing comedy comes down to characters like these, who have limited stage time, yet can be the glue that holds together the who-when-why of *Barber*. There were moments of sluggishness, an unnecessary beat of silence before or after a gag. Part of it seemed to be in the pit, under maestro Henrik Nánási. The Orchestra of the Royal Opera House had a glorious lightness and sense of fun in their playing, yet Nánási seemed to dig in his heels against the singers' organic tempi; the transition from recit into number and back into recit needed more snappiness.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1473807291280/2016-09-14---FURLANETTO-FARDILHA-PIERARD-CAMARENA-PRIANTE-MACK---IL-BARBIERE-DI-SIVIGLIA-ROH-PHOTO-MARK-DOUET.jpg.jpg)
<figcaption>Furlanetto, Fardilha, Pierard, Camarena, Priante, Mack, *Il barbiere di Siviglia*, ROH. Photo: Mark Douet.</figcaption>
</figure>

Leiser and Caurier's *Il barbiere* is kind on the eyes, and the style of comedy is nestled uniquely between the aesthetics of [Els Comediants](/in-review-the-barber-of-seville-at-the-coc/) and of [Bartlett Sher](http://www.huffingtonpost.com/wilborn-hampton/barber-of-seville-met-opera_b_8861888.html). Yet it's the cast that should bring you to Covent Garden for this run. The singing is unreal, at a standard that remains extraordinarily high from downbeat to curtain calls. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1473807381454/2016-09-14---FURLANETTO-FARDILHA-MACK-PIERARD-CAMARENA-PRIANTE---IL-BARBIERE-DI-SIVIGLIA-ROH-PHOTO-MARK-DOUET.jpg.jpg)
<figcaption>Furlanetto, Fardilha, Mack, Pierard, Camarena, Priante, *Il barbiere di Siviglia*, ROH. Photo: Mark Douet.</figcaption>
</figure>

>Il barbiere di Siviglia runs until October 11 at the Royal Opera House. [Click here](http://www.roh.org.uk/productions/il-barbiere-di-siviglia-by-moshe-leiser-and-patrice-caurier) for full details and to book your tickets.
