+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-01-28T17:48:00-05:00"
lastmod = "2015-04-11T22:11:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1427065416481/DonGiovanni-MC-1220_Fotor.jpg.jpg"
primary_image_credit = "Michael Cooper"
publishDate = "2015-01-28T17:48:00-05:00"
related_articles = ["articles/concept-production-real-reason.md","articles/in-review-the-marriage-of-figaro.md","articles/in-review-lucia-di-lammermoor-at-roh.md","articles/gimmicks-tactics-discouraging-the-new-.md","articles/in-review-don-giovanni-at-nashville-opera.md","articles/when-don-giovanni-is-the-don.md","articles/don-giovanni-in-2018-in-search-of-a-concept.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/kyle-ketelsen.md","scene/people/russell-braun.md","scene/people/jennifer-holloway.md","scene/people/jane-archibald.md","scene/people/michael-schade.md","scene/people/sasha-djihanian.md","scene/people/zachary-nelson.md"]
short_description = "After much anticipation (and averting my eyes from the opening night reviews), I had the chance to see the COC&#039;s current production of Don Giovanni, directed and designed by Dmitri Tcherniakov, and conducted by Michael Hofstetter. The production was new to me, and my curiosity was piqued by some press photos and a few rumoured details. "
slug = "in-review-tcherniakovs-don-giovanni"
title = "In review: Tcherniakov&#039;s Don Giovanni"
+++

<p class="intro">
	After much anticipation (and averting my eyes from the opening night reviews), I had the chance to see the COC's current production of 
	<a href="http://www.coc.ca/PerformancesAndTickets/1415Season/DonGiovanni.aspx" target="_blank"><em>Don Giovanni</em></a>, directed and designed by <a href="http://operabase.com/a/Dmitri_Tcherniakov/4289" target="_blank">Dmitri Tcherniakov</a>, and conducted by <a href="http://www.michaelhofstetter.com/biography.html" target="_blank">Michael Hofstetter</a>. The production was new to me, and my curiosity was piqued by some press photos and a few rumoured details. Plus, there would be a new conductor in the pit, and an exciting cast, which was a good mix of no-brainers (Russell Braun) and familiar voices singing new roles (Jane Archibald).<br>
</p>
<p>
	As expected, the singing in this 
	<em>Giovanni </em>was stellar from Anna to Zerlina. In the title role was Russell Braun, returning to one of his signature roles in his signature opera house. It was so wonderful to be able to hear him sing this music, which he clearly loves and knows so well. He sang with a schizophrenic rang of colour, from morose and apathetic, to manically excited; he took enormous risks (high A!) and brought us close up with his "Deh vieni alla finestra". Many of his choices, like the pacing of recitative, came from this production; it made me curious to ask Russell about his own ideas about Da Ponte's libretto.
</p>
<p>
	Canadian fave 
	<a href="https://twitter.com/archibaldjane" target="_blank">Jane Archibald</a> made her role debut as Donna Anna, and I thought it was a beautiful fit for her. The agility in her voice allowed us to hear every note, which is a hard compromise for sopranos with more expanse. The result was that Jane's Donna Anna sounded young and fragile; if she had been staged as a true victim of Giovanni's, it would have been totally believable. Her "Non mi dir" was a highlight of the night for me.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428804402916/DonGiovanni-MC-0707.jpg"><img data-resize-src="http://lh3.googleusercontent.com/i0GYCANNYdnLR-2PnaKZYjKQMdL8HE7fOg1TGYAIpoKhgitEBQtKQurI0l-JdLSTINoQpLuRgIX5Nnv0zdl_1u7mtEvP" src="http://lh3.googleusercontent.com/i0GYCANNYdnLR-2PnaKZYjKQMdL8HE7fOg1TGYAIpoKhgitEBQtKQurI0l-JdLSTINoQpLuRgIX5Nnv0zdl_1u7mtEvP=s1200"></a><figcaption>Jane Archibald (Anna) and Michael Schade (Ottavio). Photo: Michael Cooper</figcaption></figure>
<p>
	Another highlight was 
	<a href="http://kyleketelsen.instantencore.com/web/home.aspx" target="_blank">Kyle Ketelsen</a>'s singing of Leporello. He carried clearly and easily through the hall; he always had a dark warmth in his sound, whether he was chattering <em>recit</em> or singing with his full voice. Kyle blended beautifully with Russell as Giovanni, but their respective consistent sounds kept their two voices distinct.
</p>
<p>
	As Donna Elvira, 
	<a href="/talking-with-singers-jennifer-holloway/" target="_blank">Jennifer Holloway</a> had some of the most exciting musical moments of the night. She seemed to have no problems at all with this notoriously difficult role, including a really easy top that had ring as well as guts. Jennifer has a few pants roles under her belt as well, and I loved that there seemed to be something strong in her top (masculine, almost?), that gave power to her Elvira. Her "Mi tradì" was totally stunning, expertly sung and exciting to watch. Most of the cast was onstage with her, a departure from the traditional monologue setting, and I thought Jennifer made great use of her "audience", almost screaming that great text into the vacant faces of her family. This was her COC debut, and I hope she'll be back soon.
</p>
<p>
	<a href="https://twitter.com/sashadjihanian" target="_blank">Sasha Djihanian</a> was a spunky, unpredictable, obsessive Zerlina. Physically, she exuded youth and innocence; the strength in her voice gave her character more depth. She sang "Vedrai, carino" with <em>gravitas</em> and beautiful line, less flirty and more protective; again, I was curious about Sasha's own ideas about this scene, since both of her arias had different dramatic motivation than I expected. As Masetto,<a href="http://www.cami.com/?webid=2402" target="_blank"> Zachary Nelson</a> had a gorgeous, almost dangerous sound that I loved loved loved, and I want to hear him in a role that shows more. He'll return as <a href="http://www.coc.ca/PerformancesAndTickets/1516Season/Carmen.aspx" target="_blank">Escamillo next season</a>, so I'll get that chance. <a href="http://operabase.com/a/Michael_Schade/12336" target="_blank">Michael Schade</a>, another Canadian favourite, sang Don Ottavio with lots of detail and nuance; he gave more spark and personality to Ottavio than we usually see, which worked well in this production. I was pleased that they hadn't cut "Dalla sua pace". As the Commendatore, bass <a href="http://www.andreasilvestrelli.com/bmd/biography.html" target="_blank">Andrea Silvestrelli</a> had the most surprising, humungous voice I'd heard in a long time. It was wide open, a quality I love in a bass, and the sound was a little wild. It was definitely menacing for his final appearance at dinner.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428804450546/DonGiovanni-MC-0871_Fotor.jpg"><img data-resize-src="http://lh3.googleusercontent.com/it6yaKeAyi5zgEEmh4RMWY0OC7-z7_2GjWnlGSglD_Ly1P9IMrsaSoNtswDiSA_R6DWru2PiRHO2wSnp77AdhN38LKfhZg" src="http://lh3.googleusercontent.com/it6yaKeAyi5zgEEmh4RMWY0OC7-z7_2GjWnlGSglD_Ly1P9IMrsaSoNtswDiSA_R6DWru2PiRHO2wSnp77AdhN38LKfhZg=s1200"></a><figcaption>Zachary Nelson (Masetto) and Sasha Djihanian (Zerlina). Photo: Michael Cooper</figcaption></figure>
<p>
	The COC Orchestra sounded at their usual high standard under maestro Hofstetter, and I have to give kudos to Michael Shannon on harpsichord continuo. That's a lotta 
	<em>recit;</em> bravo! At times the orchestra overwhelmed the singers onstage, and I thought some moments were a little too thick. I had a personal bias for quicker tempi than maestro Hofstetter's, and I felt a few of the singers wanted to move along a bit as well.
</p>
<p>
	*Before I talk about the production, I'd like to start with a disclaimer: I have worked with the COC, and I've had nothing but positive and inspiring experiences with the company. I think a great function of the COC is to bring the international opera scene to Toronto, and my criticisms of Dmitri Tcherniakov's production are not criticisms of the COC's decision to include it in their 2014/15 season.
</p>
<p>
	In his production of 
	<em>Don Giovanni</em>, Tcherniakov places the characters in one household, and creates a new web of relationships between them. Don Giovanni is married to Donna Elvira, whose cousin is Donna Anna. Zerlina is Anna's daughter, and Leporello is vaguely related to the rest of them. The timeline is also changed; instead of the action happening over 24 hours, the scenes are spread out, separated by days and weeks (punctuated by a dramatic, quickly falling curtain that probably created a breeze for the first few rows).  Finally, the entire cast spends huge amounts of time onstage, having characters present in scenes that are intended to happen in their absence. This combination of decisions created a lot of problems onstage.
</p>
<p>
	The night felt like a concept stretched much too thinly over the score and libretto. 
	<em>Don Giovanni</em> has much to say about human nature, sexuality, and morality, and this is all said through this opera that is earthy and tangible and largely available at face value. Tcherniakov decided to sacrifice a sensical story for the sake of his newly created web of characters. They weren't uninteresting characters, but they certainly wouldn't have spoken the lines that were in the Da Ponte libretto.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428804490412/DonGiovanni-MC-1232_Fotor.jpg"><img data-resize-src="http://lh3.googleusercontent.com/2wMIFrC2fcaDx4DBN9dGqPV5Li2bRfRffqVdrcjq-EfPlhvdxZe1no9SrfLHnjJZVU-V3DDPxIRvH0xvvYuOm9G71wkUYw" src="http://lh3.googleusercontent.com/2wMIFrC2fcaDx4DBN9dGqPV5Li2bRfRffqVdrcjq-EfPlhvdxZe1no9SrfLHnjJZVU-V3DDPxIRvH0xvvYuOm9G71wkUYw=s1200"></a><figcaption>Kyle Ketelsen (Leporello), Russell Braun (Giovanni), and Jennifer Holloway (Elvira). Photo: Michael Cooper</figcaption></figure>
<p>
	So many of Tcherniakov's decisions went against Mozart.
</p>
<ul>
	<li>The curtain opened to silence for an uncomfortable amount of time, and then the overture began randomly. Why not when the curtain goes up? Or when the Commendatore sits in his seat?</li>
	<li>There were characters exiting and re-entering in the middle of their scene, or finishing a line from offstage for no particularly obvious reason.</li>
	<li>Donna Anna sees Don Giovanni kill the Commendatore, apparently accidentally. Her frantic <em>recit</em> that happens right after her father dies seems odd and redundant, because Tcherniakov sets this scene five days after the murder.</li>
	<li><span style="font-family: Lato, Lato, 'Helvetica Neue', Helvetica, sans-serif;" rel="font-family: Lato, Lato, 'Helvetica Neue', Helvetica, sans-serif;">Elvira, Giovanni's very unhappy wife, sings her first lines deliberately within earshot of Giovanni and Leporello, making a strange power game out of her now rhetorical questions "ah! chi mi dice mai...", and Giovanni's "poverina" line directed right at Elvira. This was interesting to me, but the execution seemed off.</span></li>
	<li>When Giovanni and Leporello are disguised as each other, they simply exchange a coat. No mask, lights are on, whatever. But Giovanni and Leporello come up with the disguise plan right in front of Elvira. I get it, it makes her some sort of manipulated slave of Giovanni's, but there are specific lines that were nonsensical in this new scene. The entire sextet warranted questions: Leporello, why can't you find your way out of the place you live? Elvira, why can't you find "Giovanni" in the same room as you with the lights on and no mask?</li>
	<li>There was a Graveyard Scene, under a chandelier (that didn't nod, but I'd buy it). But then the return of the Commendatore in the Act II finale turned out to be a look-alike (still sung by Andrea Silvestrelli), paid off by Ottavio. Everyone, including a reluctant Elvira, had conspired to try and scare Giovanni to death.</li>
	<li>The Vienna ending: I don't mind this version, but it's weird for Leporello to narrate what happened to everyone, when the whole thing was apparently their idea.</li>
</ul>
<p>
	Stuff like that. Perhaps it seems like boring critique to nag about the plot making sense, but it's this kind of superimposition that arms the argument against 
	<em>Regieoper</em>. It felt as though Tcherniakov wanted to create the dark, incestuous household of the Commendatore, and opted to ignore the plot holes that surfaced as a result. I don't think it's conservative to start with the score and libretto, and give a fair go at taking the piece at face value. There are archaic hurdles that make <em>Don Giovanni</em> a difficult piece to direct already, and this production added so many more. Tcherniakov told what seemed like a story of women with low self-esteem and a manic protagonist in the midst of his many highs and lows. If only the text and music had told the same tale.
</p>
<p>
	The singing is fantastic, and worth hearing while it's here. 
	<em>Don Giovanni</em> runs until February 21st; <a href="http://www.coc.ca/PerformancesAndTickets/1415Season/DonGiovanni.aspx" target="_blank">click here</a> for more details and to purchase tickets.
</p>
